#modules/functions.py


import tkinter as tk
from tkinter import filedialog, scrolledtext, messagebox, Toplevel, Text, Button, Scrollbar, END, ttk, BooleanVar, Tk, Canvas, Entry, PhotoImage, font
from PIL import Image, ImageDraw, ImageFont, ImageTk
from pathlib import Path
import logging
import customtkinter
from customtkinter import *
from CTkListbox import *
from modules.font_handler import font_handler
from modules.load_questions import LoadQuestionsPopup
from modules.load_autoqm_questions import LoadQuestions_변형문제
from modules.load_questions3 import DragDropDialogTK

from openpyxl import load_workbook, Workbook
from openpyxl.styles import Alignment
from openpyxl.utils import get_column_letter
from openpyxl.utils.exceptions import InvalidFileException

from docx import Document
from docx.oxml.ns import qn
from docx.enum.style import WD_STYLE_TYPE
from docx.shared import Pt, Cm, Inches
from docx.enum.table import WD_TABLE_ALIGNMENT
from docx.enum.text import WD_LINE_SPACING, WD_PARAGRAPH_ALIGNMENT, WD_BREAK
from docx.oxml import OxmlElement
from docx.shared import RGBColor
from docx.oxml import parse_xml
from docx.oxml.ns import nsdecls
import json

import pygame
import urllib.request
import tempfile
import certifi

import pandas as pd
import ssl
import smtplib
import mimetypes
from email.message import EmailMessage
import pyperclip
import csv
import io
import platform


####### 오류 모아서 한번에 오류 리포트?
# Setup basic logging configuration
logging.basicConfig(level=logging.INFO)
app_logger = logging.getLogger("app")
app_logger.setLevel(logging.INFO)


# Initialize the API response logger for logging API responses to the terminal
api_response_logger = logging.getLogger("api_response")
processing_logger = logging.getLogger("processing")

logger = logging.getLogger()
logger.setLevel(logging.INFO)

DEFAULT_ROWS_ORDER = [
    "어휘1단계", "어휘2단계", "어휘3단계", "내용일치(한)", "내용일치", "밑줄의미", "함축의미", "무관한문장", 
    "빈칸추론", "추론", "추론불가", "순서", "삽입", "주제", 
    "제목", "요지", "연결어", "요약", "어법1단계", "어법2단계", "빈칸암기", "어휘종합", 
    "내용종합", "영작1", "영작2", "동형문제", "동반의어", "동반의어문제1", "동반의어문제2", "영영정의", "영영정의문제", "요약문", "커스텀", "실전모의고사", "기출문제세트"
]

시트_DEFAULT_ORDER = ["대기열"] + DEFAULT_ROWS_ORDER

app_data_dir = Path.home() / ".my_application_data"
app_data_dir.mkdir(exist_ok=True)  # Create the directory if it does not exist
OPTIONS_FILE = os.path.join(app_data_dir, 'app_options.json') #음성종류 & 커스텀AI종류


class BackupMailer:
    def __init__(self, smtp_server, smtp_port, auth_user, auth_password,
                 sender_addr, recipient_addrs, username, excel_file, version=""):
        self.smtp_server = smtp_server
        self.smtp_port = smtp_port
        self.auth_user = auth_user
        self.auth_password = auth_password
        self.sender_addr = sender_addr
        self.recipient_addrs = recipient_addrs  # list of strings
        self.username = username                # for the subject
        self.excel_file = excel_file
        self.version = version                  # app version info

    def send_backup_email(self, body_text=None):
        # 1) Create message
        # Detect OS
        os_name = "Mac" if platform.system() == "Darwin" else "Windows" if platform.system() == "Windows" else platform.system()

        if body_text is None:
            body_text = f"AutoQM 버전: {self.version}\nOS: {os_name}\n\n첨부 파일을 확인해주세요."
        else:
            # Prepend version and OS info to custom body_text
            body_text = f"AutoQM 버전: {self.version}\nOS: {os_name}\n\n{body_text}"

        msg = EmailMessage()
        msg["From"] = self.sender_addr
        msg["To"] = ", ".join(self.recipient_addrs)
        msg["Subject"] = f"AutoQM ({self.version}) 사용자 '{self.username}'가 보낸 파일"
        msg.set_content(body_text)

        file_path = self.excel_file
        # guess MIME type
        ctype, encoding = mimetypes.guess_type(file_path)
        if ctype is None or encoding is not None:
            ctype = "application/octet-stream"
        maintype, subtype = ctype.split("/", 1)
        with open(file_path, "rb") as f:
            file_data = f.read()
        msg.add_attachment(
            file_data,
            maintype=maintype,
            subtype=subtype,
            filename=file_path.split("/")[-1]
        )

        # 3) Send via SMTP with modified SSL context
        context = ssl.create_default_context(cafile=certifi.where())
        
        with smtplib.SMTP(self.smtp_server, self.smtp_port) as smtp:
            smtp.starttls(context=context)
            smtp.login(self.auth_user, self.auth_password)
            smtp.send_message(msg)
        print(f"Email sent: {msg['Subject']} → {self.recipient_addrs}")
        





class CopyManager(): #원래 이거 자체가 한국어 키보드용..... 근데 트리뷰는 영어로 해도 여기가 불려옴
    def __init__(self, parent_window, get_excel_file=None):

        self.parent_window = parent_window
        self.parent_window.bind("<KeyPress>", self.handle_keypress)
        self.get_excel_file = get_excel_file  # Store the getter function

        self.clipboard_data = None
        self.last_system_clipboard = None
        self._is_pasting = False  # Re-entry guard for paste operations

        self.COMMAND_KEY_MASK = 8  # Based on the state value provided
        self.SHIFT_KEY_MASK = 1  # Based on the state value provided
        self.TOGETHER_MASK = 9  # Based on the state value provided
        # Windows-specific masks
        self.WINDOWS_CONTROL = 4  # Control key state for Windows
        self.WINDOWS_SHIFT = 1  # Shift key state for Windows



    ## 영어로 해도 이게 불려오네????
    def update_clipboard(self):
        current_system_clipboard = pyperclip.paste()
        if current_system_clipboard != self.last_system_clipboard:
            self.last_system_clipboard = current_system_clipboard
            try:
                csv_reader = csv.reader(io.StringIO(current_system_clipboard), delimiter='\t')
                self.clipboard_data = list(csv_reader)
            except:
                self.clipboard_data = None

    def update_clipboard_mac(self):
        try:
            # Use Tkinter's clipboard_get instead of pyperclip.paste
            current_system_clipboard = self.parent_window.clipboard_get()
            
            if current_system_clipboard != self.last_system_clipboard:
                self.last_system_clipboard = current_system_clipboard
                try:
                    csv_reader = csv.reader(io.StringIO(current_system_clipboard), delimiter='\t')
                    self.clipboard_data = list(csv_reader)
                except:
                    self.clipboard_data = None
        except tk.TclError:
            # Handle case where clipboard is empty or contains non-text data
            self.clipboard_data = None


    def copy_treeview(self, treeview):
        print("copy_treeview called in CopyManager")
        selected_items = treeview.selection()
        if not selected_items:
            messagebox.showwarning("Warning", "No rows selected.")
            return
        
        self.clipboard_data = []
        for item in selected_items:
            values = treeview.item(item, 'values')
            self.clipboard_data.append(values)

        
        if platform.system() == 'Darwin':  # Mac OS
            self._copy_treeview_mac()
        else:  # Windows and other platforms
            self._copy_treeview_windows()

    """
    def _copy_treeview_mac(self):
        # Convert clipboard_data to a CSV string
        output = io.StringIO()
        csv_writer = csv.writer(output, quoting=csv.QUOTE_MINIMAL)
        csv_writer.writerows(self.clipboard_data)
        clipboard_str = output.getvalue().strip()
        
        pyperclip.copy(clipboard_str)
        self.last_system_clipboard = clipboard_str
        
        #print(f"Copied data (Mac): {clipboard_str}")
    """


    """def _copy_treeview_mac(self): ## 이거 사용시 packageed app 에서 클립보드로 복사가 안됨.
        messagebox.showinfo("Info", f"Copied.\n{self.clipboard_data}")

        # Manually create the clipboard string
        clipboard_lines = []
        for row in self.clipboard_data:
            processed_row = []
            for cell in row:
                # Escape internal quotes by doubling them
                cell = cell.replace('"', '""')
                # Enclose the entire cell content in quotes
                cell = f'"{cell}"'
                processed_row.append(cell)
            # Join the cells with tabs
            clipboard_line = '\t'.join(processed_row)
            clipboard_lines.append(clipboard_line)
        # Join the rows with newlines
        clipboard_str = '\n'.join(clipboard_lines)
        
        pyperclip.copy(clipboard_str)
        self.last_system_clipboard = clipboard_str
    """

    def _copy_treeview_mac(self): ## 이건 패키지 앱에서 클립보드로 복사는 됨. 근데 붙여넣기가 또 안되네
        # Show the data is correct
       
        # Create the clipboard string as you were doing
        clipboard_lines = []
        for row in self.clipboard_data:
            processed_row = []
            for cell in row:
                cell = cell.replace('"', '""')
                cell = f'"{cell}"'
                processed_row.append(cell)
            clipboard_line = '\t'.join(processed_row)
            clipboard_lines.append(clipboard_line)
        clipboard_str = '\n'.join(clipboard_lines)
        
        # Try using Tkinter's clipboard instead of pyperclip
        self.parent_window.clipboard_clear()
        self.parent_window.clipboard_append(clipboard_str)
        self.last_system_clipboard = clipboard_str


    def _copy_treeview_windows(self):
        # Use StringIO to create an in-memory file-like object
        output = io.StringIO()
        
        # Create a CSV writer object
        csv_writer = csv.writer(output, dialect='excel-tab')
        
        # Write the data
        csv_writer.writerows(self.clipboard_data)
        
        # Get the CSV string
        clipboard_str = output.getvalue()
        
        # Copy to clipboard
        pyperclip.copy(clipboard_str)
        self.last_system_clipboard = clipboard_str
        
        #print(f"Copied data (Windows): {clipboard_str}")

        

    def paste_treeview(self, treeview):
        print("paste_treeview called in CopyManager")
        

        sheet_selector = self.parent_window.sheet_selector
        sheet_name = sheet_selector.get()
        print(f"sheet_name: {sheet_name}")

        if platform.system() == 'Darwin':  # Mac OS
            # Update clipboard data
            self.update_clipboard_mac()
        else:  # Windows and other platforms
            # Update clipboard data
            self.update_clipboard()

        if not self.clipboard_data:
            messagebox.showwarning("Warning", "No data to paste.")
            return

        focus_item = treeview.focus()
        if not focus_item:
            messagebox.showwarning("Warning", "No row selected for pasting.")
            return

        # Check if we're about to overwrite existing non-empty data
        focus_index = treeview.index(focus_item)
        existing_items = treeview.get_children()[focus_index:focus_index + len(self.clipboard_data)]

        non_empty_rows = sum(1 for item in existing_items if any(treeview.item(item, 'values')))

        # Save the current state before making changes
        self.parent_window.undo_manager.save_state(treeview)

        # Perform the paste operation
        for i, row_data in enumerate(self.clipboard_data):
            # If sheet_name is "대기열", limit to first two columns
            if sheet_name == "대기열":
                row_data = row_data[:2]

            if i < len(existing_items):
                # Overwrite existing row
                treeview.item(existing_items[i], values=row_data)
            else:
                # Insert new row
                treeview.insert('', focus_index + i, values=row_data)

        # Update the UI and save changes
        self.parent_window.on_treeview_change()

        current_excel_file = self.get_excel_file() if self.get_excel_file else None
        if current_excel_file:
            self.parent_window.save_treeview_to_excel(current_excel_file, sheet_name)



    def cut_treeview(self, treeview):
        print("cut_treeview called")
        
        sheet_selector = self.parent_window.sheet_selector
        sheet_name = sheet_selector.get()

        selected_items = treeview.selection()
        if not selected_items:
            messagebox.showwarning("Warning", "No rows selected.")
            return
        
        # Save the current state before making changes
        self.parent_window.undo_manager.save_state(treeview)
        
        self.clipboard_data = []
        all_items = treeview.get_children()
        
        # Find the index of the last selected item
        last_selected_index = all_items.index(selected_items[-1])
        
        for item in selected_items:
            values = treeview.item(item, 'values')
            self.clipboard_data.append(values)
        
        # Check if we're about to cut all rows
        if set(selected_items) == set(all_items):
            # Keep one empty row
            for item in selected_items[:-1]:
                treeview.delete(item)
            last_item = selected_items[-1]
            treeview.item(last_item, values=('',) * len(treeview['columns']))
            next_item = last_item
        else:
            # Delete the selected rows
            for item in selected_items:
                treeview.delete(item)
            
            # Determine the next item to select
            remaining_items = treeview.get_children()
            if remaining_items:
                if last_selected_index < len(remaining_items):
                    next_item = remaining_items[last_selected_index]
                else:
                    next_item = remaining_items[-1]
            else:
                # If all rows were deleted, add an empty row
                next_item = treeview.insert('', 'end', values=('',) * len(treeview['columns']))
        
        # Select the next item
        if next_item:
            treeview.selection_set(next_item)
            treeview.focus(next_item)
            treeview.see(next_item)  # Ensure the selected item is visible
        
        # Update the UI and save changes
        self.parent_window.on_treeview_change()
        print("cut_treview 에서 저장 호출")

        current_excel_file = self.get_excel_file() if self.get_excel_file else None
        if current_excel_file:
            self.parent_window.save_treeview_to_excel(current_excel_file, sheet_name)



    def select_all_treeview(self, treeview):
        treeview.selection_set(treeview.get_children())



    def handle_keypress(self, event):
        #print(event.state)
        #print(event.keycode)
        #print(event.keysym)

        # CRITICAL: Skip processing for non-modifier keypresses to avoid
        # interfering with Korean Input Method (IMK) XPC communication.
        # Only process Command/Control key combinations.
        is_command = event.state & self.COMMAND_KEY_MASK
        is_control = event.state & self.WINDOWS_CONTROL
        if not is_command and not is_control:
            return  # Let normal typing pass through without interference

        # Copy (command+ㅊ)
        if event.keycode == 134217827 and (event.state & self.COMMAND_KEY_MASK):  # keycode for ㅊ
            #print("Copy text called")
            event.widget.event_generate("<<Copy>>")




        # Add these conditions for treeview operations
        if isinstance(event.widget, ttk.Treeview):
            #print(f"keycode: {event.keycode}, state: {event.state}")
            if event.keycode == 134217827 and (event.state & self.COMMAND_KEY_MASK):  # Copy (command+ㅊ)
                self.copy_treeview(event.widget)
            elif event.keycode == 150995062 and (event.state & self.COMMAND_KEY_MASK):  # Paste (command+ㅍ)
                self.paste_treeview(event.widget)
            elif event.keycode == 117440632 and (event.state & self.COMMAND_KEY_MASK):  # Cut (command+ㅌ)
                self.cut_treeview(event.widget)
            elif event.keycode == 97 and (event.state & self.COMMAND_KEY_MASK):  # Select All (command+ㅁ)
                self.select_all_treeview(event.widget)



            elif event.keycode == 67 and (event.state & self.WINDOWS_CONTROL):  # Copy (command+ㅊ) c
                self.copy_treeview(event.widget)
            elif event.keycode == 86 and (event.state & self.WINDOWS_CONTROL):  # Paste (command+ㅍ) v
                self.paste_treeview(event.widget)
            elif event.keycode == 88 and (event.state & self.WINDOWS_CONTROL):  # Cut (command+ㅌ) x
                self.cut_treeview(event.widget)
            elif event.keycode == 65 and (event.state & self.WINDOWS_CONTROL):  # Select All (command+ㅁ) a
                self.select_all_treeview(event.widget)








            # Undo (command+ㅋ)
            ########  z를 먼저 막아야 함.
            elif event.keysym == 'z' and (event.state & self.COMMAND_KEY_MASK):  # keysym for 'v'
                # Do nothing, let the system handle the paste
                print("Ignoring system undo")            
                pass
                

            elif event.keycode == 100663418 and (event.state & self.COMMAND_KEY_MASK):  # keycode for ㅋ
                print("실행취소")
                self.parent_window.undo_manager.undo(self.parent_window.treeview)

            elif event.keysym == 'Z' and (event.state & self.COMMAND_KEY_MASK): 
                # Do nothing, let the system handle the paste
                print("Ignoring system redo")            
                pass
                

            # Redo (command+shift+ㅋ)
            elif event.keycode == 104857722 and (event.state & self.COMMAND_KEY_MASK) and (event.state & self.SHIFT_KEY_MASK):  # keycode for ㅋ with Shift
                print("재실행")
                self.parent_window.undo_manager.redo(self.parent_window.treeview)
        

        ######## 이게 ㅍ 보다 앞에 있어야 함. v를 먼저 막아야 함.
        elif event.keysym == 'v' and (event.state & self.COMMAND_KEY_MASK):  # keysym for 'v'
            # Do nothing, let the system handle the paste
            pass
            print("Ignoring system paste")
 

        # Paste (command+ㅍ)
        elif event.keycode == 150995062 and (event.state & self.COMMAND_KEY_MASK):  # keycode for ㅍ (v)
            # Re-entry guard to prevent multiple paste operations
            if self._is_pasting:
                print("Paste already in progress, ignoring")
                return

            print("Paste text called")
            self._is_pasting = True
            widget = event.widget  # Capture widget reference for after() callback

            # Get the clipboard content
            try:
                clipboard_content = widget.clipboard_get()

                # Modify the clipboard content (e.g., replace '/i' with '\n')
                #modified_content = clipboard_content.replace('', '\n')
                modified_content = (clipboard_content
                    .replace("\u2028", "\n")
                    .replace("\u2029", "\n")
                    .replace("\f", "")
                    .replace("\u2013", "-")
                    .replace("\u200B", "")   # zero-width space
                    .replace("\u200C", "")   # zero-width non-joiner
                    .replace("\u200D", "")   # zero-width joiner
                    .replace("\uFEFF", "")   # byte order mark
                )

                # Set the modified content back to the clipboard
                widget.clipboard_clear()
                widget.clipboard_append(modified_content)

                # Use after() to decouple paste from clipboard modification
                # This gives macOS IMK time to process clipboard changes
                def do_paste():
                    try:
                        widget.event_generate("<<Paste>>")
                    except tk.TclError:
                        pass  # Widget might be destroyed
                    finally:
                        self._is_pasting = False

                widget.after(50, do_paste)  # 50ms delay to let Korean IMK settle

            except tk.TclError:
                # Handle empty clipboard
                print("Clipboard is empty or contains non-text data")
                self._is_pasting = False
        

        # Select All (command+ㅁ)
        elif event.keycode == 97 and (event.state & self.COMMAND_KEY_MASK):  # keycode for ㅁ
            event.widget.event_generate("<<SelectAll>>")

        # Cut (command+ㅌ)
        elif event.keycode == 117440632 and (event.state & self.COMMAND_KEY_MASK):  # keycode for ㅌ
            event.widget.event_generate("<<Cut>>")



        # Windows-specific Redo (Ctrl+Shift+Z)
        elif event.keysym == 'Z' and (event.state & self.WINDOWS_CONTROL) and (event.state & self.WINDOWS_SHIFT):
            event.widget.event_generate("<<Redo>>") 
        


        # 일단 z를 막고 그 다음에 ㅋ
        elif event.keysym == 'z' and (event.state & self.COMMAND_KEY_MASK):  # keysym for 'z'
            # Do nothing, let the system handle the paste
            pass
            #print("Ignoring system paste")

        # Undo (command+ㅋ)
        elif event.keycode == 100663418 and (event.state & self.COMMAND_KEY_MASK):  # keycode for ㅋ
            print("실행취소")
            event.widget.event_generate("<<Undo>>")

        # Redo (command+shift+ㅋ)
        elif event.keycode == 104857722 and (event.state & self.COMMAND_KEY_MASK) and (event.state & self.SHIFT_KEY_MASK):  # keycode for ㅋ with Shift
            print("재실행")
            event.widget.event_generate("<<Redo>>")
        
        # Redo (command+shift+ㅋ)
        #elif event.keycode == 104857722 and (event.state & self.TOGETHER_MASK):  # keycode for ㅋ with Shift
        #    print("재실행")
        #    event.widget.event_generate("<<Redo>>")
        





#툴팁
class ToolTip(object):
    def __init__(self, widget):
        self.widget = widget
        self.tip_window = None
        self.auto_hide_id = None  # Track auto-hide callback

        font_handler.set_default_font()
        self.default_font = font_handler.default_font

    def show_tip(self, tip_text, x, y):
        """Display text in a tooltip window"""
        if self.tip_window or not tip_text:
            return

        # Create the tooltip window
        try:
            self.tip_window = tw = tk.Toplevel(self.widget)
            tw.wm_overrideredirect(True)
            tw.wm_geometry("+%d+%d" % (x + 20, y + 20))

            # Set font sizes based on OS
            if sys.platform.startswith('darwin'):
                fontsize = 13
            elif sys.platform.startswith('win'):
                fontsize = 13
            else:
                fontsize = 12  # a default for other OS

            label = tk.Label(tw,
                             text=tip_text,
                             justify=tk.LEFT,
                             background="#ffffe0",
                             relief=tk.SOLID,
                             borderwidth=1,
                             fg="black",
                             font=(self.default_font, fontsize, "normal"),
                             wraplength=650)
            label.pack(ipadx=1, ipady=1)

            # Schedule the tooltip to be hidden after 15 seconds
            # Store the ID so we can cancel it if needed
            if self.auto_hide_id:
                try:
                    self.widget.after_cancel(self.auto_hide_id)
                except:
                    pass
            self.auto_hide_id = self.widget.after(15000, self.hide_tip)
        except Exception as e:
            # Silently handle widget destruction errors
            self.tip_window = None

    def hide_tip(self):
        """Destroy the tooltip window safely"""
        # Cancel auto-hide callback if scheduled
        if self.auto_hide_id:
            try:
                self.widget.after_cancel(self.auto_hide_id)
            except:
                pass
            self.auto_hide_id = None

        # Destroy tooltip window if it exists
        if self.tip_window:
            try:
                if self.tip_window.winfo_exists():
                    self.tip_window.destroy()
            except:
                pass
            finally:
                self.tip_window = None

    def cleanup(self):
        """Clean up resources when tooltip is no longer needed"""
        self.hide_tip()


class ToolTip유형설명(object):
    def __init__(self, widget, tip_text, default_font="Arial", delay=500):
        """
        Initialize the tooltip.

        :param widget: The widget to attach the tooltip to.
        :param tip_text: The text to display in the tooltip.
        :param default_font: The font to use for the tooltip text.
        :param delay: Delay in milliseconds before showing the tooltip.
        """
        self.widget = widget
        self.tip_text = tip_text
        self.default_font = default_font
        self.delay = delay
        self.tip_window = None
        self.schedule_id = None  # To manage the schedule event
        self.auto_hide_id = None  # To manage the auto-hide event
        self._event_coords = None  # Store event coordinates

        self.widget.bind("<Enter>", self.schedule)
        self.widget.bind("<Leave>", self.cancel)

    def schedule(self, event=None):
        """Schedule the tooltip to appear after a delay."""
        # Store event coordinates for later use
        if event:
            self._event_coords = (event.x_root, event.y_root)

        # Cancel any existing scheduled tooltip
        if self.schedule_id:
            try:
                self.widget.after_cancel(self.schedule_id)
            except:
                pass

        # Schedule new tooltip with lambda to pass coordinates
        self.schedule_id = self.widget.after(self.delay, lambda: self.enter())

    def cancel(self, event=None):
        """Cancel the scheduled tooltip if the mouse leaves before delay."""
        if self.schedule_id:
            try:
                self.widget.after_cancel(self.schedule_id)
            except:
                pass
            self.schedule_id = None
        self.hide_tip()

    def enter(self):
        """Show the tooltip using stored coordinates."""
        if self._event_coords:
            x, y = self._event_coords
            self.show_tip(self.tip_text, x + 20, y + 20)

    def show_tip(self, tip_text, x, y):
        """Create and display the tooltip window."""
        if self.tip_window or not tip_text:
            return

        # Create the tooltip window
        try:
            self.tip_window = tw = tk.Toplevel(self.widget)
            tw.wm_overrideredirect(True)
            tw.wm_geometry(f"+{x}+{y}")

            # Determine font size based on OS
            if sys.platform.startswith('darwin'):
                fontsize = 13
            elif sys.platform.startswith('win'):
                fontsize = 13
            else:
                fontsize = 12

            label = tk.Label(
                tw,
                text=tip_text,
                justify=tk.LEFT,
                background="#ffffe0",
                relief=tk.SOLID,
                borderwidth=1,
                fg="black",
                font=(self.default_font, fontsize, "normal"),
                wraplength=650,
                padx=5,
                pady=5
            )
            label.pack(ipadx=1, ipady=1)

            # Schedule the tooltip to be hidden after 15 seconds
            # Store the ID so we can cancel it if needed
            if self.auto_hide_id:
                try:
                    self.widget.after_cancel(self.auto_hide_id)
                except:
                    pass
            self.auto_hide_id = self.widget.after(15000, self.hide_tip)
        except Exception as e:
            # Silently handle widget destruction errors
            self.tip_window = None

    def hide_tip(self):
        """Destroy the tooltip window safely."""
        # Cancel auto-hide callback if scheduled
        if self.auto_hide_id:
            try:
                self.widget.after_cancel(self.auto_hide_id)
            except:
                pass
            self.auto_hide_id = None

        # Destroy tooltip window if it exists
        if self.tip_window:
            try:
                if self.tip_window.winfo_exists():
                    self.tip_window.destroy()
            except:
                pass
            finally:
                self.tip_window = None

    def cleanup(self):
        """Clean up resources and unbind events when tooltip is no longer needed."""
        # Cancel any scheduled callbacks
        if self.schedule_id:
            try:
                self.widget.after_cancel(self.schedule_id)
            except:
                pass
            self.schedule_id = None

        # Hide tooltip and cancel auto-hide
        self.hide_tip()

        # Unbind events
        try:
            self.widget.unbind("<Enter>")
            self.widget.unbind("<Leave>")
        except:
            pass



"""
# Define a Custom Logging Handler
class TextHandler(logging.Handler):
    def __init__(self, text_widget):
        super().__init__()
        self.text_widget = text_widget

    def emit(self, record):
        msg = self.format(record)
        # Safely update the Tkinter widget from another thread without filtering by logger name.
        self.text_widget.after(0, self.update_text_widget, msg)

    def update_text_widget(self, msg):
        self.text_widget.configure(state="normal")
        self.text_widget.insert(tk.END, msg + '\n')
        self.text_widget.configure(state="disabled")
        self.text_widget.see(tk.END)
"""

class TextHandler(logging.Handler):
    def __init__(self, text_widget):
        super().__init__()
        self.text_widget = text_widget

    def emit(self, record):
        msg = self.format(record)
        # Safely update the Tkinter widget from another thread without filtering by logger name.
        self.text_widget.after(0, self.update_text_widget, record.levelno, msg)

    def update_text_widget(self, level, msg):
        self.text_widget.configure(state="normal")
        try:
            _, current_bottom = self.text_widget.yview()
            auto_scroll = abs(current_bottom - 1.0) < 1e-3
        except tk.TclError:
            auto_scroll = True

        if level >= logging.ERROR:
            self.text_widget.insert(tk.END, msg + '\n', 'error')
        else:
            self.text_widget.insert(tk.END, msg + '\n')
        self.text_widget.configure(state="disabled")
        if auto_scroll:
            self.text_widget.see(tk.END)




###############################################################################################################
######################################### 엑셀 편집 기능 #########################################################
###############################################################################################################
class ExcelMergerApp(CTkToplevel):
    def __init__(self):
        super().__init__()
        self.title('Excel Merger Tool')
        self.geometry('640x300')
        self.minsize(640, 300)
        self.configure(fg_color=("white"))
        self.grid_rowconfigure(0, weight=1)
        self.grid_columnconfigure(0, weight=1)

        # Create a frame for file selection
        self.file_frame = CTkFrame(self, fg_color="#eff3f0", corner_radius=10)
        self.file_frame.grid(row=0, column=0, sticky="nsew", padx=20, pady=20)
        self.file_frame.grid_rowconfigure(1, weight=1)
        self.file_frame.grid_columnconfigure(0, weight=1)

        # Frame for buttons
        self.button_frame = CTkFrame(self.file_frame, fg_color="white")
        self.button_frame.grid(row=0, column=0, pady=10, padx=10, sticky="ew")
        self.button_frame.grid_columnconfigure((0, 1, 2, 3), weight=1)

        # Button to add Excel files
        self.add_files_button = CTkButton(self.button_frame, text='Add Excel Files', command=self.add_files, font=(None, 12), height=25, fg_color="white", hover_color="#DDA15C", text_color="black")
        self.add_files_button.grid(row=0, column=0, padx=5, pady=5, sticky="ew")

        # Button to clear selected files
        self.clear_files_button = CTkButton(self.button_frame, text='Clear', command=self.clear_files, font=(None, 12), height=25, fg_color="white", hover_color="#DDA15C", text_color="black")
        self.clear_files_button.grid(row=0, column=1, padx=5, pady=5, sticky="ew")

        # Move Up button
        self.move_up_button = CTkButton(self.button_frame, text='Move Up', command=self.move_up, font=(None, 12), height=25, fg_color="white", hover_color="#DDA15C", text_color="black")
        self.move_up_button.grid(row=0, column=2, padx=5, pady=5, sticky="ew")

        # Move Down button
        self.move_down_button = CTkButton(self.button_frame, text='Move Down', command=self.move_down, font=(None, 12), height=25, fg_color="white", hover_color="#DDA15C", text_color="black")
        self.move_down_button.grid(row=0, column=3, padx=5, pady=5, sticky="ew")

        # List box to display added files
        self.file_list_box = CTkListbox(self.file_frame, width=600, height=200, corner_radius=0, fg_color="white")
        self.file_list_box.grid(row=1, column=0, pady=10, padx=10, sticky="nsew")

        # Button to select output file path and start merging
        self.output_file_button = CTkButton(self.file_frame, text='Save', command=self.select_output_and_merge, font=(None, 13, 'bold'), height=25, fg_color="#FEF9E0", hover_color="#DDA15C", text_color="black")
        self.output_file_button.grid(row=2, column=0, pady=10)

        self.excel_files = []

        self.bind("<Escape>", self.on_popup_close)


    def on_popup_close(self, event=None):
        self.destroy()


    def add_files(self):
        filenames = filedialog.askopenfilenames(title='Select Excel Files', filetypes=[('Excel files', '*.xlsx'), ('All files', '*.*')])
        if filenames:
            for file in filenames:
                print(f"Adding file: {file}")  # Debug statement
            self.excel_files.extend(filenames)
            self.update_file_list()


    def clear_files(self):
        self.excel_files.clear()
        self.update_file_list()

    def move_up(self):
        index = self.file_list_box.curselection()
        if index and index > 0:
            self.excel_files[index], self.excel_files[index - 1] = self.excel_files[index - 1], self.excel_files[index]
            self.update_file_list()
            

    def move_down(self):
        index = self.file_list_box.curselection()   
        if index and index < len(self.excel_files) - 1:
            self.excel_files[index], self.excel_files[index + 1] = self.excel_files[index + 1], self.excel_files[index]
            self.update_file_list()


    def update_file_list(self):
        self.file_list_box.delete(0, "end")
        for filename in self.excel_files:
            self.file_list_box.insert("end", filename)


    def select_output_and_merge(self):
        output_path = filedialog.asksaveasfilename(
            title='Select Output File and Start Merging', 
            filetypes=[('Excel files', '*.xlsx')],
            defaultextension='.xlsx'
        )
        
        # Ensure the file has .xlsx extension
        if output_path:
            if not output_path.lower().endswith('.xlsx'):
                output_path += '.xlsx'
            
            # Check if the output path is one of the input files
            if output_path in self.excel_files:
                messagebox.showwarning(
                    "경고", 
                    "입력 파일과 동일한 이름으로 병합 파일을 저장할 수 없습니다. 다른 이름을 선택해주세요."
                )
                return
            
            # Check if file already exists (additional safeguard)
            if os.path.exists(output_path):
                if messagebox.askyesno("파일 존재", "이 파일이 이미 존재합니다. 덮어쓰시겠습니까?"):
                    # Make sure it's not currently open
                    try:
                        # Try to open the file in append mode to check if it's locked
                        with open(output_path, 'a+b'):
                            pass
                    except IOError:
                        messagebox.showwarning("파일 사용 중", "이 파일이 현재 다른 프로그램에서 열려 있습니다. 파일을 닫거나 다른 파일을 선택해주세요.")
                        return
                else:
                    return  # User chose not to overwrite
            
            self.output_path = output_path
            
            if not self.excel_files:
                messagebox.showwarning("경고", "병합하기 전에 파일을 추가해주세요.")
            else:
                self.start_merging()

                
                                
    def start_merging(self):
        if not self.excel_files or not self.output_path:
            messagebox.showwarning("Warning", "Please select both files and output path.")
        else:
            try:
                # Assume operations for file processing are done here
                self.merge_excel_files()  # Hypothetical method that performs file merging
                messagebox.showinfo("Success", "파일이 성공적으로 통합되었습니다.")
            except Exception as e:
                messagebox.showerror("Error", "An error occurred: " + str(e))



    def merge_excel_files(self):
        custom_column_widths = [10, 80, 80, 20, 60]  # Example widths

        # Function to extract base sheet name and sort key
        def sheet_sort_key(sheet_name):
            base_name = sheet_name.replace('_Normal', '').replace('_Hard', '')
            order_index = 시트_DEFAULT_ORDER.index(base_name) if base_name in 시트_DEFAULT_ORDER else float('inf')
            tag_index = 0 if '_Normal' in sheet_name else 1 if '_Hard' in sheet_name else 2
            return (order_index, tag_index, sheet_name)

        all_sheet_names = set()
        for file_path in self.excel_files:
            try:
                excel = pd.ExcelFile(file_path)
                all_sheet_names.update(excel.sheet_names)
            except Exception as e:
                messagebox.showerror("Error", f"Failed to read {file_path}: {e}")
                return

        with pd.ExcelWriter(self.output_path, engine='openpyxl') as writer:
            for sheet_name in all_sheet_names:
                dfs = []
                for file_path in self.excel_files:
                    try:
                        excel = pd.ExcelFile(file_path)
                        if sheet_name in excel.sheet_names:
                            df = pd.read_excel(file_path, sheet_name=sheet_name, header=None)
                            dfs.append(df)
                    except Exception as e:
                        messagebox.showerror("Error", f"Failed to read sheet {sheet_name} from {file_path}: {e}")
                        return
                if dfs:
                    df_combined = pd.concat(dfs, ignore_index=True)
                    try:
                        df_combined.to_excel(writer, sheet_name=sheet_name, index=False, header=False)
                    except Exception as e:
                        messagebox.showerror("Error", f"Failed to write sheet {sheet_name} to output: {e}")
                        return

        try:
            output_book = load_workbook(self.output_path)
            sorted_sheet_names = sorted(output_book.sheetnames, key=sheet_sort_key)

            # Apply custom column widths and text wrapping
            for sheet_name in sorted_sheet_names:
                sheet = output_book[sheet_name]
                for i, column_width in enumerate(custom_column_widths, start=1):
                    column_letter = get_column_letter(i)
                    sheet.column_dimensions[column_letter].width = column_width
                    for row in sheet.iter_rows(min_col=i, max_col=i):
                        for cell in row:
                            cell.alignment = Alignment(wrap_text=True)

            # Reorder the sheets according to the sorted list
            reordered_sheets = [output_book[sheet] for sheet in sorted_sheet_names]
            output_book._sheets = reordered_sheets  # Directly assign the reordered sheets

            output_book.save(self.output_path)
        except Exception as e:
            messagebox.showerror("Error", f"Failed to process the output workbook: {e}")




#엑셀 파일 선택 후 그 파일 내에서 특정 지문 지우기
class ExcelDeleteApp(CTkToplevel):
    def __init__(self):
        super().__init__()
        self.title('특정 엑셀파일에서 지문 전체 삭제 툴')
        self.geometry('640x300')
        self.minsize(640, 300)
        self.configure(fg_color=("white"))
        self.grid_rowconfigure(0, weight=1)
        self.grid_columnconfigure(0, weight=1)

        self.default_font = font_handler.default_font

        # Create a frame for file selection
        self.file_frame = CTkFrame(self, fg_color="#eff3f0", corner_radius=10)
        self.file_frame.grid(row=0, column=0, sticky="nsew", padx=20, pady=20)
        self.file_frame.grid_rowconfigure(1, weight=1)
        self.file_frame.grid_columnconfigure(0, weight=1)

        # Frame for buttons
        self.button_frame = CTkFrame(self.file_frame, fg_color="white")
        self.button_frame.grid(row=0, column=0, pady=10, padx=10, sticky="ew")
        self.button_frame.grid_columnconfigure((0, 1, 2), weight=1)

        # Button to add Excel files
        self.select_file_button = CTkButton(self.button_frame, text='엑셀파일 선택', command=self.select_file, font=(self.default_font, 12), width=130, height=25, fg_color="white", hover_color="#DDA15C", text_color="black")
        self.select_file_button.grid(row=0, column=1, padx=5, pady=5)

        # Label to display the selected file path
        self.excel_file_path = CTkLabel(self.button_frame, text='', font=(self.default_font, 12), height=25, fg_color="white", text_color="black")
        self.excel_file_path.grid(row=0, column=2, padx=5, pady=5, sticky="ew")

        # Textbox to input deletion list
        self.delete_list = CTkTextbox(self.file_frame, height=60, font=(self.default_font, 14), fg_color="white", text_color="black")
        self.delete_list.grid(row=1, column=0, pady=10, padx=10, sticky="nsew")

        self.placeholder_text = "삭제할 지문번호를 이곳에 입력하세요 (여러 항목은 엔터로 구분)."
        self.delete_list.insert("0.0", self.placeholder_text)
        self.delete_list.configure(text_color='grey')

        def on_entry_click(event):
            if self.delete_list.get("1.0", "end-1c").strip() == self.placeholder_text:
                self.delete_list.delete("1.0", "end")
                self.delete_list.configure(text_color='black')  # Change text color back to normal

        def on_entry_focusout(event):
            if not self.delete_list.get("1.0", "end-1c").strip():
                self.delete_list.insert("1.0", self.placeholder_text)
                self.delete_list.configure(text_color='grey')  # Change text color back to grey

        # Bind focus in and focus out events
        self.delete_list.bind('<FocusIn>', on_entry_click)
        self.delete_list.bind('<FocusOut>', on_entry_focusout)

        # Button to execute delete
        self.output_file_button = CTkButton(self.file_frame, text='Delete', command=self.execute_delete, font=(self.default_font, 13, 'bold'), width=130, height=25, fg_color="#FEF9E0", hover_color="#DDA15C", text_color="black")
        self.output_file_button.grid(row=2, column=0, pady=10, padx=10)

        self.bind("<Escape>", self.on_popup_close)



    def on_popup_close(self, event=None):
        self.destroy()


    def select_file(self):
        file_path = filedialog.askopenfilename(title='Select Excel File', filetypes=[('Excel files', '*.xlsx')])
        if file_path:  # This ensures it is not empty
            self.output_path = file_path  # Save the selected file path as a string
            self.excel_file_path.configure(text=self.output_path)  # Update the label

    def execute_delete(self):
        if not hasattr(self, 'output_path') or not self.output_path:
            messagebox.showerror("Error", "No file selected. Please select a file first.")
            return

        if self.delete_list.get("1.0", "end-1c").strip() == self.placeholder_text or self.delete_list.get("1.0", "end-1c").strip() == "":
            messagebox.showerror("Error", "삭제할 지문번호를 입력하세요.")
            return

        # Get the list of items to be deleted
        content = self.delete_list.get("1.0", "end-1c").strip()
        criteria_list = [line.strip() for line in content.splitlines()]
        criteria_list = [line for line in criteria_list if line]

        print(f"criteria_list: {criteria_list}")

        # Create the warning message
        warning_text = "아래 지문(들)을 선택하신 파일의 모든 유형에서 삭제합니다.\n삭제후엔 복구할 수 없습니다. 삭제 하시겠습니까?"
        list_text = " / ".join(criteria_list)




        # Create a custom dialog
        dialog = CTkToplevel(self)
        dialog.title("경고")
        dialog.resizable(False, False)

        # Create the label with the warning message
        warning_label = CTkLabel(dialog, text=warning_text, justify="center")
        warning_label.pack(pady=(20, 10), padx=20)

        list_label = CTkLabel(dialog, text=list_text, justify="center")
        list_label.pack(pady=(0, 20), padx=20)


        def on_cancel():
            dialog.destroy()

        def on_confirm():
            dialog.destroy()
            self.perform_deletion(criteria_list)

        # Create a frame for buttons
        button_frame = CTkFrame(dialog, fg_color="transparent")
        button_frame.pack(pady=10, padx=20, fill="x")

        CTkButton(button_frame, text="취소", command=on_cancel, width=100, font=(self.default_font, 12, "bold"), text_color="black", border_color="#FEF9E0", hover_color="#DDA15C", fg_color="#FEF9E0").pack(side="left", padx=10)
        CTkButton(button_frame, text="확인", command=on_confirm, width=100, font=(self.default_font, 12, "bold"), text_color="black", border_color="#FEF9E0", hover_color="#DDA15C", fg_color="#FEF9E0").pack(side="right", padx=10)

        # Adjust window size to fit content
        dialog.update()
        dialog.geometry(f"{warning_label.winfo_reqwidth() + 40}x{warning_label.winfo_reqheight() + button_frame.winfo_reqheight() + 60}")

        dialog.transient(self)
        dialog.grab_set()
        self.wait_window(dialog)

    def perform_deletion(self, criteria_list):
        # Specify your desired column widths here
        custom_column_widths = [10, 80, 80, 20, 60]

        # Load the workbook and the names of all sheets
        workbook = load_workbook(self.output_path)
        sheet_names = workbook.sheetnames

        # Process each sheet
        for sheet_name in sheet_names:
            # Load the sheet into a DataFrame without headers
            df = pd.read_excel(self.output_path, sheet_name=sheet_name, header=None)

            # Find rows where column A matches any of the criteria
            mask = df.iloc[:, 0].apply(lambda x: any(criterion in str(x) for criterion in criteria_list))
            
            # Filter out rows that match the criteria
            filtered_df = df[~mask]

            # Save the modified DataFrame back to the sheet, overwriting it
            with pd.ExcelWriter(self.output_path, engine='openpyxl', mode='a', if_sheet_exists='replace') as writer:
                filtered_df.to_excel(writer, sheet_name=sheet_name, index=False, header=False)

        # After updating the sheets, set custom column widths using openpyxl
        workbook = load_workbook(self.output_path)
        for sheet_name in workbook.sheetnames:
            sheet = workbook[sheet_name]
            for i, column_width in enumerate(custom_column_widths, start=1):
                sheet.column_dimensions[get_column_letter(i)].width = column_width
                for row in sheet.iter_rows(min_col=i, max_col=i):
                    for cell in row:
                        cell.alignment = Alignment(wrapText=True)

        workbook.save(self.output_path)
        messagebox.showinfo("Success", "Successfully deleted specified entries.")




#현재 로딩된 엑셀파일에서 특정 지문 지우기
class ExcelDeleteAppCurrent(CTkToplevel):
    def __init__(self, main_frame, sheet_selector, update_sheet_selector_func, load_excel_into_treeview, excel_file, sheet_name):
        super().__init__()

        self.main_frame = main_frame  # Store the reference to MainFrame        
        self.sheet_selector = sheet_selector
        
        self.update_sheet_selector = update_sheet_selector_func
        self.load_excel_into_treeview = load_excel_into_treeview        

        self.title('현재 파일에서 지문 전체 삭제 툴')
        self.geometry('640x500')
        self.minsize(640, 400)
        self.configure(fg_color="white")
        self.grid_rowconfigure(0, weight=1)
        self.grid_columnconfigure(0, weight=1)
        self.grab_set()
        self.focus_set()
        self.default_font = font_handler.default_font
        self.excel_file = excel_file
        self.sheet_name = sheet_name

        # Dictionary to store checkbox variables
        self.checkbox_vars = {}
        
        # Add these for shift-click functionality
        self.checkboxes = []  # List to store checkbox widgets in order
        self.last_clicked_index = None  # Track the last clicked checkbox index

        # Create a main frame
        self.main_frame = CTkFrame(self, fg_color="#eff3f0", corner_radius=10)
        self.main_frame.grid(row=0, column=0, sticky="nsew", padx=20, pady=20)
        self.main_frame.grid_rowconfigure(2, weight=1)  # Give more weight to the checkbox area
        self.main_frame.grid_columnconfigure(0, weight=1)

        # Label to display information with proper file path handling
        def format_file_path(path, max_length=50):
            if path and len(path) > max_length:
                # Get the drive and filename parts
                drive, tail = os.path.splitdrive(path)
                filename = os.path.basename(path)
                directory = os.path.dirname(path)
                
                # Format with ellipsis in the middle
                formatted_path = f"{drive}{os.path.sep}...{os.path.sep}{filename}"
                return formatted_path
            return path

        formatted_path = format_file_path(self.excel_file)
        self.info_label = CTkLabel(
            self.main_frame, 
            text=f'아래의 지문을 현재 작업중인 파일의 모든 유형에서 삭제합니다.\n(현재 파일 경로: {formatted_path})', 
            font=(self.default_font, 14), 
            fg_color="white", 
            text_color="black",
            wraplength=580,  # Add wrapping to handle long text
            justify="left"   # Left-align the text for better readability
        )
        self.info_label.grid(row=0, column=0, padx=10, pady=(10, 5), sticky="ew")

        # Title for checkboxes with select all/none buttons
        self.checkbox_title_frame = CTkFrame(self.main_frame, fg_color="transparent")
        self.checkbox_title_frame.grid(row=1, column=0, padx=10, pady=(5, 0), sticky="ew")
        self.checkbox_title_frame.grid_columnconfigure(0, weight=0)
        self.checkbox_title_frame.grid_columnconfigure(1, weight=1)
        
        self.checkbox_title = CTkLabel(self.checkbox_title_frame, text="삭제할 지문번호에 체크하세요", 
                                      font=(self.default_font, 14, 'bold'), fg_color="transparent", text_color="black")
        self.checkbox_title.grid(row=0, column=0, sticky="w")
        
        # Add Select All/None buttons
        self.select_buttons_frame = CTkFrame(self.checkbox_title_frame, fg_color="transparent")
        self.select_buttons_frame.grid(row=0, column=1, sticky="e", padx=(10, 0))
        
        self.select_all_button = CTkButton(self.select_buttons_frame, text="전체 선택", 
                                          command=self.select_all, width=70, height=25,
                                          font=(self.default_font, 11), fg_color="#FEF9E0", 
                                          hover_color="#DDA15C", text_color="black")
        self.select_all_button.grid(row=0, column=0, padx=2)
        
        self.select_none_button = CTkButton(self.select_buttons_frame, text="전체 해제", 
                                           command=self.select_none, width=70, height=25,
                                           font=(self.default_font, 11), fg_color="#FEF9E0", 
                                           hover_color="#DDA15C", text_color="black")
        self.select_none_button.grid(row=0, column=1, padx=2)

        # Create a scrollable frame for checkboxes
        self.scrollable_frame = CTkScrollableFrame(self.main_frame, fg_color="white")
        self.scrollable_frame.grid(row=2, column=0, pady=5, padx=10, sticky="nsew")

        # Label for manual entry
        self.manual_entry_title = CTkLabel(self.main_frame, text="삭제할 지문번호 임의 입력:", font=(self.default_font, 14), fg_color="transparent", text_color="black")
        self.manual_entry_title.grid(row=3, column=0, padx=10, pady=(10, 0), sticky="nw")

        # Textbox for manual entry
        self.manual_entry = CTkTextbox(self.main_frame, font=(self.default_font, 14), fg_color="white", text_color="black", height=60)
        self.manual_entry.grid(row=4, column=0, pady=5, padx=10, sticky="ew")

        # Button frame
        self.button_frame = CTkFrame(self.main_frame, fg_color="transparent", height=60)
        self.button_frame.grid(row=5, column=0, pady=10, padx=10, sticky="sew")
        self.button_frame.grid_columnconfigure(0, weight=1)
        self.button_frame.grid_columnconfigure(1, weight=0)

        # Add checkbox for excluding waiting queue
        self.exclude_waiting_var = tk.BooleanVar()
        self.exclude_waiting_checkbox = CTkCheckBox(self.button_frame, text="대기열에서는 삭제 제외", variable=self.exclude_waiting_var, 
                                                  font=(self.default_font, 13), text_color="black", 
                                                  fg_color="#CA7900", hover_color="#DDA15C")
        self.exclude_waiting_checkbox.grid(row=0, column=0, pady=10, padx=10, sticky="w")

        # Execute delete button
        self.delete_button = CTkButton(self.button_frame, text='삭제 실행', command=self.execute_delete, 
                                     font=(self.default_font, 13, 'bold'), width=120, height=40, 
                                     fg_color="#FEF9E0", hover_color="#DDA15C", text_color="black")
        self.delete_button.grid(row=0, column=1, padx=10, pady=10, sticky="e")

        self.bind("<Escape>", self.on_popup_close)
        
        # Load items from 대기열 sheet automatically
        self.load_items_from_waiting_sheet()
    
    def on_checkbox_click(self, event, index):
        """Handle checkbox click with shift functionality"""
        if event.state & 0x0001:  # Shift key is pressed
            if self.last_clicked_index is not None:
                # Determine the range to select/deselect
                start = min(self.last_clicked_index, index)
                end = max(self.last_clicked_index, index)
                
                # Get the state of the clicked checkbox (will be toggled)
                # We need to check what the state will be after the click
                current_state = self.checkboxes[index].get()
                
                # Apply the same state to all checkboxes in range
                for i in range(start, end + 1):
                    self.checkboxes[i].select() if current_state else self.checkboxes[i].deselect()
        
        # Update the last clicked index
        self.last_clicked_index = index
    
    def select_all(self):
        """Select all checkboxes"""
        for checkbox in self.checkboxes:
            checkbox.select()
    
    def select_none(self):
        """Deselect all checkboxes"""
        for checkbox in self.checkboxes:
            checkbox.deselect()
    
    def load_items_from_waiting_sheet(self):
        # Clear any existing checkboxes
        for widget in self.scrollable_frame.winfo_children():
            widget.destroy()
        self.checkbox_vars.clear()
        self.checkboxes.clear()  # Clear the checkbox list
        self.last_clicked_index = None  # Reset last clicked index
        
        if not self.excel_file:
            label = CTkLabel(self.scrollable_frame, text="엑셀 파일이 로딩되지 않았습니다.", font=(self.default_font, 12), fg_color="white", text_color="red")
            label.pack(pady=5, anchor="w")
            return
            
        try:
            wb = load_workbook(filename=self.excel_file, read_only=True)
            if "대기열" not in wb.sheetnames:
                label = CTkLabel(self.scrollable_frame, text="'대기열' 시트를 찾을 수 없습니다.", font=(self.default_font, 12), fg_color="white", text_color="red")
                label.pack(pady=5, anchor="w")
                return
                
            sheet = wb["대기열"]
            
            # Load items from the waiting sheet
            items = []
            for row in sheet.iter_rows(min_row=1, max_col=1, values_only=True):
                cell_value = row[0]
                # Skip None values or empty strings
                if cell_value is not None and str(cell_value).strip() and str(cell_value).strip() != "None":
                    items.append(str(cell_value).strip())
            
            if not items:
                label = CTkLabel(self.scrollable_frame, text="대기열에 항목이 없습니다.", font=(self.default_font, 12), fg_color="white", text_color="blue")
                label.pack(pady=5, anchor="w")
                return
            
            # Create checkboxes for each item
            for i, item in enumerate(items):
                var = tk.BooleanVar(value=False)
                self.checkbox_vars[item] = var
                checkbox = CTkCheckBox(self.scrollable_frame, text=item, variable=var, 
                                      font=(self.default_font, 12), text_color="black", 
                                      fg_color="#CA7900", hover_color="#DDA15C")
                checkbox.pack(pady=3, anchor="w", padx=10)
                
                # Store checkbox reference
                self.checkboxes.append(checkbox)
                
                # Bind click event with index
                checkbox.bind("<Button-1>", lambda e, idx=i: self.on_checkbox_click(e, idx))
                
        except Exception as e:
            label = CTkLabel(self.scrollable_frame, text=f"오류: {str(e)}", font=(self.default_font, 12), fg_color="white", text_color="red")
            label.pack(pady=5, anchor="w")

    def is_sheet_empty(self, sheet):
        for row in sheet.iter_rows(values_only=True):
            for cell in row:
                if cell is not None:
                    return False
        return True

    def on_popup_close(self, event=None):
        self.destroy()

    def execute_delete(self):
        if not self.excel_file:
            messagebox.showerror("Error", "No file selected. Please select a file first.")
            return

        # Get checked items
        checked_items = [item for item, var in self.checkbox_vars.items() if var.get()]
        
        # Get manually entered items
        manual_text = self.manual_entry.get("1.0", "end-1c").strip()
        manual_items = [line.strip() for line in manual_text.splitlines() if line.strip()]
        
        # Combine both lists
        criteria_list = checked_items + manual_items
        
        if not criteria_list:
            messagebox.showerror("Error", "삭제할 지문번호를 선택하거나 입력하세요.")
            return

        # Create the warning message based on the checkbox state
        if self.exclude_waiting_var.get():
            warning_message = f"아래 지문(들)을 현재 작업중인 파일의 대기열을 제외한 모든 유형에서 삭제합니다.\n삭제 후엔 복구할 수 없습니다. 삭제 하시겠습니까?\n\n"
        else:
            warning_message = f"아래 지문(들)을 현재 작업중인 파일의 모든 유형에서 삭제합니다.\n삭제 후엔 복구할 수 없습니다. 삭제 하시겠습니까?\n\n"
        warning_message += " / ".join(criteria_list)

        # Create a custom dialog
        dialog = CTkToplevel(self)
        dialog.title("경고")
        dialog.resizable(False, False)

        # Create the label with the warning message
        label = CTkLabel(dialog, text=warning_message, wraplength=380, justify="center")
        label.pack(pady=20, padx=20)

        def on_cancel():
            dialog.destroy()

        def on_confirm():
            dialog.destroy()
            self.perform_deletion(criteria_list)

        # Create a frame for buttons
        button_frame = CTkFrame(dialog, fg_color="transparent")
        button_frame.pack(pady=10, padx=20, fill="x")

        CTkButton(button_frame, text="취소", command=on_cancel, width=100, font=(self.default_font, 12, "bold"), text_color="black", border_color="#FEF9E0", hover_color="#DDA15C", fg_color="#FEF9E0").pack(side="left", padx=10)
        CTkButton(button_frame, text="확인", command=on_confirm, width=100, font=(self.default_font, 12, "bold"), text_color="black", border_color="#FEF9E0", hover_color="#DDA15C", fg_color="#FEF9E0").pack(side="right", padx=10)

        # Adjust window size to fit content
        dialog.update()
        dialog.geometry(f"{label.winfo_reqwidth() + 40}x{label.winfo_reqheight() + button_frame.winfo_reqheight() + 60}")

        dialog.transient(self)
        dialog.grab_set()
        self.wait_window(dialog)
        
    def perform_deletion(self, criteria_list):
        custom_column_widths = [10, 80, 80, 20, 60]

        workbook = load_workbook(self.excel_file)
        sheet_names = workbook.sheetnames

        for sheet_name in sheet_names:
            # Skip the "대기열" sheet if the checkbox is checked
            if self.exclude_waiting_var.get() and sheet_name == "대기열":
                continue

            df = pd.read_excel(self.excel_file, sheet_name=sheet_name, header=None)

            if df.empty:
                print("Warning: No data found in sheet:", sheet_name)
                continue

            if df.shape[1] == 0:
                print("Error: No columns found in the DataFrame for sheet:", sheet_name)
                continue

            try:
                mask = df.iloc[:, 0].apply(lambda x: str(x) in criteria_list)
                filtered_df = df[~mask]
            except Exception as e:
                print(f"Error processing data in sheet {sheet_name}: {e}")
                continue

            with pd.ExcelWriter(self.excel_file, engine='openpyxl', mode='a', if_sheet_exists='replace') as writer:
                filtered_df.to_excel(writer, sheet_name=sheet_name, index=False, header=False)

        workbook = load_workbook(self.excel_file)
        for sheet_name in workbook.sheetnames:
            sheet = workbook[sheet_name]
            for i, column_width in enumerate(custom_column_widths, start=1):
                sheet.column_dimensions[get_column_letter(i)].width = column_width
                for row in sheet.iter_rows(min_col=i, max_col=i):
                    for cell in row:
                        cell.alignment = Alignment(wrapText=True)

        # 빈 시트 삭제
        # Identify empty sheets excluding "대기열"
        empty_sheets = [
            sheet for sheet in workbook.sheetnames
            if self.is_sheet_empty(workbook[sheet]) and sheet != "대기열"
        ]

        # Remove the identified sheets
        for sheet in empty_sheets:
            workbook.remove(workbook[sheet])
        
        workbook.save(self.excel_file)

        sheet_name = self.sheet_selector.get()    

        def after_update():
            self.sheet_selector.set(sheet_name)
            self.destroy()

        self.update_sheet_selector(self.excel_file, callback=after_update)
        self.load_excel_into_treeview(self.excel_file, sheet_name)
        self.destroy()

        messagebox.showinfo("Success", "성공적으로 삭제되었습니다.")





#현재 선택된 시트 삭제하기
class ExcelSheetDeleteApp(CTkToplevel):
    def __init__(self, main_frame, sheet_selector, load_excel_func, update_sheet_func, excel_file):
        
        super().__init__()

        self.main_frame = main_frame  # Store the reference to MainFrame
        self.sheet_selector = sheet_selector  # Reference to the sheet selector widget
        self.sheet_name = self.sheet_selector.get()
        self.load_excel_into_treeview = load_excel_func  # Function to load Excel into treeview
        self.update_sheet_selector = update_sheet_func  # Function to update the sheet selector
        self.excel_file = excel_file   

        self.title('현재 유형 전체 삭제 툴')
        self.geometry('400x170')
        self.resizable(False, False)
        self.configure(fg_color="white")
        self.grid_rowconfigure(0, weight=1)
        self.grid_columnconfigure(0, weight=1)

        self.default_font = font_handler.default_font

        # Create a main frame
        self.main_frame = CTkFrame(self, fg_color="#eff3f0", corner_radius=10)
        self.main_frame.grid(row=0, column=0, sticky="nsew", padx=20, pady=20)
        self.main_frame.grid_rowconfigure(1, weight=1)
        self.main_frame.grid_columnconfigure(0, weight=1)

        # Label to display information
        self.sheet_to_delete_label = CTkLabel(self.main_frame, text=f'선택된 유형("{self.sheet_name}")을 통째로 삭제합니다.\n삭제하면 되돌릴 수 없습니다. 삭제하시겠습니까?', font=(self.default_font, 14), fg_color="white", text_color="black", height=40)
        self.sheet_to_delete_label.grid(row=0, column=0, padx=10, pady=10, sticky="ew")

        # Frame for the delete button
        self.button_frame = CTkFrame(self.main_frame, fg_color="transparent", height=35)
        self.button_frame.grid(row=1, column=0, pady=10, padx=10, sticky="ew")
        self.button_frame.grid_columnconfigure(0, weight=1)
        self.button_frame.grid_columnconfigure(1, weight=1)
        self.button_frame.grid_columnconfigure(2, weight=1)

        # Delete button
        delete_button = CTkButton(self.button_frame, text="삭제 실행", font=(self.default_font, 13, 'bold'), command=self.delete_sheet, width=120, height=35, fg_color="#FEF9E0", hover_color="#DDA15C", text_color="black")
        delete_button.grid(row=0, column=1, pady=0)

        self.bind('<Return>', self.delete_sheet)
        self.bind("<Escape>", self.on_popup_close)


    def on_popup_close(self, event=None):
        self.destroy()

    def delete_sheet(self, event=None):
        
        if not self.sheet_name:
            messagebox.showerror("Error", "No sheet selected. Please select a sheet.")
            return

        workbook = load_workbook(self.excel_file)
        if self.sheet_name in workbook.sheetnames:
            # Remove the sheet
            workbook.remove(workbook[self.sheet_name])
            workbook.save(self.excel_file)
            messagebox.showinfo("Success", f"'{self.sheet_name}' 유형이 성공적으로 삭제되었습니다. '대기열' 화면으로 전환합니다.")
            self.destroy()  # Close the popup window after selection
            self.update_sheet_selector(self.excel_file)
            self.sheet_name = "대기열"
            self.load_excel_into_treeview(self.excel_file, self.sheet_name)
            #self.sheet_selector.set(sheet_name) #이거 소용 없음.  self.update_sheet_selector(excel_file) 에서 이미 대기열로 세팅.

        else:
            messagebox.showerror("Error", "Selected sheet does not exist in the workbook.")
            


# 새로운 시트 생성하기
class ExcelSheetCreateApp(CTkToplevel):
    def __init__(self, main_frame, sheet_selector, treeview, load_excel_func, save_treeview_to_excel_func, update_sheet_func, on_treeview_change, excel_file):
        
        super().__init__()

        self.main_frame = main_frame  # Store the reference to MainFrame
        self.sheet_selector = sheet_selector  # Reference to the sheet selector widget
        self.treeview = treeview
        self.load_excel_into_treeview = load_excel_func  # Function to load Excel into treeview
        self.save_treeview_to_excel = save_treeview_to_excel_func
        self.update_sheet_selector = update_sheet_func  # Function to update the sheet selector
        self.on_treeview_change = on_treeview_change

        self.title('새 시트 생성 툴')
        self.geometry('400x200')
        self.resizable(False, False)
        self.configure(fg_color="white")
        self.grid_rowconfigure(0, weight=1)
        self.grid_columnconfigure(0, weight=1)

        self.default_font = font_handler.default_font
        self.excel_file = excel_file

        # Create a main frame
        self.main_frame = CTkFrame(self, fg_color="#eff3f0", corner_radius=10)
        self.main_frame.grid(row=0, column=0, sticky="nsew", padx=20, pady=20)
        self.main_frame.grid_rowconfigure(1, weight=1)
        self.main_frame.grid_columnconfigure(0, weight=1)

        # Label to display information
        self.create_sheet_label = CTkLabel(
            self.main_frame,
            text='새 시트 이름을 입력하세요.',
            font=(self.default_font, 12),
            fg_color="white",
            text_color="black",
            height=40,
            justify="left"
        )
        self.create_sheet_label.grid(row=0, column=0, padx=10, pady=(10, 5), sticky="ew")

        # CTkEntry for sheet name input
        self.sheet_name_entry = CTkEntry(
            self.main_frame,
            placeholder_text="시트 이름 입력",
            font=(self.default_font, 14),
            width=300,
            height=30
        )
        self.sheet_name_entry.grid(row=1, column=0, padx=10, pady=(5, 10), sticky="ew")
        self.sheet_name_entry.focus_set()

        # Frame for the confirm button
        self.button_frame = CTkFrame(self.main_frame, fg_color="transparent", height=35)
        self.button_frame.grid(row=2, column=0, pady=10, padx=10, sticky="ew")
        self.button_frame.grid_columnconfigure(0, weight=1)

        # Confirm button
        confirm_button = CTkButton(
            self.button_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            command=self.create_sheet,
            width=120,
            height=35,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black"
        )
        confirm_button.grid(row=0, column=0, pady=0, padx=140)  # Center the button

        # Bind Enter and Escape keys
        self.bind('<Return>', self.create_sheet)
        self.bind("<Escape>", self.on_popup_close)

    def on_popup_close(self, event=None):
        self.destroy()

    def create_sheet(self, event=None):
        new_sheet_name = self.sheet_name_entry.get().strip()

        if not new_sheet_name:
            messagebox.showerror("Error", "시트 이름을 입력하세요.")
            return

        workbook = load_workbook(self.excel_file)

        if new_sheet_name in workbook.sheetnames:
            messagebox.showerror("Error", f"시트 '{new_sheet_name}'이(가) 이미 존재합니다.")
            return

        try:
            # Create a new sheet at the end
            workbook.create_sheet(title=new_sheet_name)
            workbook.save(self.excel_file)

            messagebox.showinfo("Success", f"시트 '{new_sheet_name}'이(가) 성공적으로 생성되었습니다.")

            print("new_sheet_name:", new_sheet_name)
            self.sheet_selector.set(new_sheet_name)
            self.treeview.delete(*self.treeview.get_children())
            for _ in range(30):
                self.treeview.insert("", "end", values=["", "", "", "", ""])
            self.on_treeview_change()
            self.save_treeview_to_excel(self.excel_file, new_sheet_name)
            
            sheet_names = workbook.sheetnames
            print(f"sheet_names: {sheet_names}")
            self.sheet_selector.configure(values=sheet_names)
            if sheet_names:
                self.sheet_selector.set(new_sheet_name)

            self.load_excel_into_treeview(self.excel_file, new_sheet_name)
            self.destroy()                




        except Exception as e:
            messagebox.showerror("Error", f"시트 생성 중 오류가 발생했습니다: {e}")



# 현재 시트 이름 변경하기
class ExcelSheetRenameApp(CTkToplevel):
    def __init__(self, main_frame, sheet_selector, load_excel_func, update_sheet_func, excel_file):
        
        super().__init__()

        self.main_frame = main_frame  # MainFrame의 참조 저장
        self.sheet_selector = sheet_selector  # 시트 선택 위젯의 참조

        self.sheet_name = self.sheet_selector.get()
        self.load_excel_into_treeview = load_excel_func  # Excel을 treeview에 로드하는 함수
        self.update_sheet_selector = update_sheet_func  # 시트 선택기를 업데이트하는 함수

        self.title('현재 시트 이름 변경 툴')
        self.geometry('400x250')
        self.resizable(False, False)
        self.configure(fg_color="white")
        self.grid_rowconfigure(0, weight=1)
        self.grid_columnconfigure(0, weight=1)

        self.default_font = font_handler.default_font
        self.excel_file = excel_file

        # 메인 프레임 생성
        self.main_frame = CTkFrame(self, fg_color="#eff3f0", corner_radius=10)
        self.main_frame.grid(row=0, column=0, sticky="nsew", padx=20, pady=20)
        self.main_frame.grid_rowconfigure(2, weight=1)
        self.main_frame.grid_columnconfigure(0, weight=1)


        # 안내 레이블
        self.instruction_label = CTkLabel(
            self.main_frame,
            text='새로운 시트 이름을 입력하고 "확인" 버튼을 클릭하세요.',
            font=(self.default_font, 12),
            fg_color="white",
            text_color="black",
            height=30,
            justify="left"
        )
        self.instruction_label.grid(row=0, column=0, padx=10, pady=(10, 0), sticky="ew")


        # 현재 시트 이름 표시 레이블
        self.current_sheet_label = CTkLabel(
            self.main_frame,
            text=f'현재 시트 이름: {self.sheet_name}',
            font=(self.default_font, 14),
            fg_color="white",
            text_color="black",
            height=30,
            justify="left"
        )
        self.current_sheet_label.grid(row=1, column=0, padx=10, pady=(0, 5), sticky="ew")

        # 새로운 시트 이름 입력 CTkEntry
        self.new_sheet_name_entry = CTkEntry(
            self.main_frame,
            placeholder_text="새 시트 이름 입력",
            font=(self.default_font, 14),
            width=300,
            height=30
        )
        self.new_sheet_name_entry.grid(row=2, column=0, padx=10, pady=(5), sticky="ew")

        # 현재 시트 이름을 자동으로 로드하고 선택
        self.new_sheet_name_entry.insert(0, self.sheet_name)
        self.new_sheet_name_entry.select_range(0, 'end')
        self.new_sheet_name_entry.focus_set()

        # 버튼 프레임 생성
        self.button_frame = CTkFrame(self.main_frame, fg_color="transparent", height=35)
        self.button_frame.grid(row=3, column=0, pady=(0, 10), padx=10, sticky="ew")
        self.button_frame.grid_columnconfigure(0, weight=1)

        # 확인 버튼
        confirm_button = CTkButton(
            self.button_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            command=self.rename_sheet,
            width=120,
            height=35,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black"
        )
        confirm_button.grid(row=0, column=0, pady=0, padx=140)  # 버튼 중앙 배치

        # Enter 및 Escape 키 바인딩
        self.bind('<Return>', self.rename_sheet)
        self.bind("<Escape>", self.on_popup_close)

    def on_popup_close(self, event=None):
        self.destroy()

    def rename_sheet(self, event=None):
        new_sheet_name = self.new_sheet_name_entry.get().strip()

        if not new_sheet_name:
            messagebox.showerror("Error", "새 시트 이름을 입력하세요.")
            return

        workbook = load_workbook(self.excel_file)

        if new_sheet_name in workbook.sheetnames:
            messagebox.showerror("Error", f"시트 '{new_sheet_name}'이(가) 이미 존재합니다.")
            return

        try:
            # 현재 시트 가져오기
            sheet = workbook[self.sheet_name]
            # 시트 이름 변경
            sheet.title = new_sheet_name
            workbook.save(self.excel_file)
            messagebox.showinfo("Success", f"시트 이름이 '{self.sheet_name}'에서 '{new_sheet_name}'으로 성공적으로 변경되었습니다.")

            # 시트 선택기 및 treeview 업데이트
            print("new_sheet_name:", new_sheet_name)

            # Use callback pattern to ensure sheet name is set AFTER update completes
            def after_update():
                self.sheet_selector.set(new_sheet_name)
                self.load_excel_into_treeview(self.excel_file, new_sheet_name)
                self.destroy()  # Close popup after everything is updated

            self.update_sheet_selector(self.excel_file, callback=after_update)

        except Exception as e:
            messagebox.showerror("Error", f"시트 이름 변경 중 오류가 발생했습니다: {e}")







class LoadTextOrQuestionPopup(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, 
                 treeview=None, row_to_treeview_id_map=None, base_url=None, user_token=None):
        super().__init__(parent)
        self.title("지문/문제 불러오기")
        self.geometry("600x350")
        self.minsize(600, 350)

        self.parent = parent
        self.default_font = default_font
        self.excel_file = excel_file
        self.treeview = treeview
        self.row_to_treeview_id_map = row_to_treeview_id_map
        self.base_url = base_url
        self.user_token = user_token

        # Main frame
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=20, padx=20, fill='both', expand=True)

        # Button frame
        button_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        button_frame.pack(side="top", fill="both", expand=True)

        # --------------------------------------------------
        # Switch to grid geometry on the button_frame
        # --------------------------------------------------
        # Make the frame fill available space
        # (already done via pack: fill="both", expand=True)

        # Configure rows/columns
        button_frame.grid_rowconfigure(0, weight=1)       # one row
        button_frame.grid_columnconfigure(0, weight=1)    # three equal-width columns
        button_frame.grid_columnconfigure(1, weight=1)
        button_frame.grid_columnconfigure(2, weight=1)



        self.logo_image3 = CTkImage(light_image=Image.open(Path(__file__).parent.parent / "assets" / "images" / "frontierlogo.png"), size=(50, 50))



        self.user_role = self.parent.fetch_user_role_custom(self.user_token)

        is_allowed = self.parent.check_role_with_flask(self.user_role)
        if is_allowed:
            self.parent.role_label.configure(text=f"정회원")







        # Left button: "지문만 불러오기"
        self.load_text_button = customtkinter.CTkButton(
            button_frame,
            text="지문만 불러오기(무료)",
            font=(self.default_font, 14, "bold"),  # or your default_font
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            width=150,
            height=150,
            command=self.on_load_text_button_click,
            image=self.logo_image3,       # <-- attach the image
            compound="top"            # <-- place image above the text
        )
        self.load_text_button.grid(row=0, column=0, sticky="nsew", padx=5, pady=10)

        # Middle button: "기출문제(원본) 불러오기"
        self.load_question_button = customtkinter.CTkButton(
            button_frame,
            text="기출문제(원본) 불러오기",
            font=(self.default_font, 14, "bold"),
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            width=150,  # optional
            height=150,
            command=self.on_load_question_button_click,
            image=self.logo_image3,
            compound="top"

        )
        self.load_question_button.grid(row=0, column=1, sticky="nsew", padx=5, pady=10)

        # Right button: "변형문제 불러오기"
        self.load_variant_button = customtkinter.CTkButton(
            button_frame,
            text="변형문제 불러오기",
            font=(self.default_font, 14, "bold"),
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            width=150,  # optional
            height=150,
            command=self.on_load_variant_button_click,
            image=self.logo_image3,
            compound="top"

        )
        self.load_variant_button.grid(row=0, column=2, sticky="nsew", padx=5, pady=10)

        # Tooltips
        self.load_text_button_tooltip = ToolTip유형설명(
            self.load_text_button,
            tip_text="역대 수능/평가원/교육청 모의고사의 '지문'만을 대기열로 불러오는 기능입니다.\n지문을 불러온 후 autoQM으로 원하는 변형문제 제작에 사용합니다.",
            default_font=self.default_font,
            delay=500
        )
        self.load_question_button_tooltip = ToolTip유형설명(
            self.load_question_button,
            tip_text="역대 수능/평가원/교육청 모의고사의 '원본문제'를 불러오는 기능입니다. 변형문제가 아닌 기출문제 원본을 그대로 불러와 바로 편집본으로 추출하여 사용합니다.",
            default_font=self.default_font,
            delay=500
        )
        self.load_variant_button_tooltip = ToolTip유형설명(
            self.load_variant_button,
            tip_text="기존에 제작된 모의고사 변형문제 풀세트를 불러오는 기능입니다.",
            default_font=self.default_font,
            delay=500
        )

        # Info frame at the bottom
        info_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        info_frame.pack(side="bottom", fill="x", pady=(10, 0))

        # Info message
        info_message = (
            "일반회원은 기출문제(원본) 불러오기 1회당 40 포인트, "
            "변형문제 불러오기 1회당 200 포인트가 사용됩니다.\n"
            "정회원 가입시 무제한 무료입니다."
        )
        info_label = customtkinter.CTkLabel(
            info_frame,
            text=info_message,
            font=(self.default_font, 11),
            text_color="#666666",
            wraplength=550,
            justify="center"
        )
        info_label.pack(pady=(0, 10))

        # 정회원 가입 button
        upgrade_button = customtkinter.CTkButton(
            info_frame,
            text="정회원 가입",
            command=self.on_upgrade_click,
            width=120,
            height=32,
            fg_color="#CA7900",
            hover_color="#DDA15C",
            text_color="white",
            font=(self.default_font, 12, 'bold')
        )
        upgrade_button.pack()

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)


    def on_popup_close(self, event=None):
        self.parent.rebind_all_menubutton_tooltips()
        self.destroy()

    def on_upgrade_click(self):
        """Open premium membership page in browser."""
        import webbrowser
        webbrowser.open("https://frontierenglish.net/product/autoqm-membership/")

    def on_load_text_button_click(self):
        popup = LoadQuestionsPopup(
            parent=self.master,
            default_font=self.default_font,
            excel_file=self.excel_file,        # use self.excel_file
            treeview=self.treeview,
            row_to_treeview_id_map=self.row_to_treeview_id_map,
            base_url=self.base_url,
        )
        popup.grab_set()
        self.withdraw()  # This hides the current window instead of destroying it

        #self.destroy()

    def on_load_variant_button_click(self):
        """Handle 변형문제 불러오기 button click."""
        self.user_role = self.parent.fetch_user_role_custom(self.user_token)
        is_allowed = self.parent.check_role_with_flask(self.user_role)

        if is_allowed:
            # Premium member - update label
            self.parent.role_label.configure(text=f"정회원")

        # Open LoadQuestions_변형문제 dialog
        popup = LoadQuestions_변형문제(
            parent=self.master,
            default_font=self.default_font,
            excel_file=self.excel_file,
            treeview=self.treeview,
            row_to_treeview_id_map=self.row_to_treeview_id_map,
            base_url=self.base_url,
            user_token=self.user_token,
        )
        popup.grab_set()
        self.withdraw()  # This hides the current window instead of destroying it

    def on_load_question_button_click(self):
        """Handle 기출문제(원본) 불러오기 button click."""
        self.user_role = self.parent.fetch_user_role_custom(self.user_token)
        is_allowed = self.parent.check_role_with_flask(self.user_role)

        if is_allowed:
            # Premium member - update label
            self.parent.role_label.configure(text=f"정회원")

        # Open DragDropDialogTK dialog
        popup = DragDropDialogTK(
            parent=self.master,
            default_font=self.default_font,
            excel_file=self.excel_file,
            treeview=self.treeview,
            row_to_treeview_id_map=self.row_to_treeview_id_map,
            base_url=self.base_url,
            user_token=self.user_token,
        )
        popup.grab_set()
        self.withdraw()  # This hides the current window instead of destroying it




"""
class SynonymQuestionOptionWindow(CTkToplevel):
    def __init__(self, master, set_checkbox_func=None, *args, **kwargs):
        super().__init__(master, *args, **kwargs)
        self.title("동의어 문제 유형 선택")
        self.geometry("300x200")
        self.grab_set()
        self.focus_set()
        self.default_font = font_handler.default_font
        self.set_checkbox_func = set_checkbox_func

        self.configure(fg_color="#eff3f0")
        self.pack_propagate(False)

        self.last_option = self.load_last_option()
        self.option_var = tk.StringVar(value=self.last_option)

        option_frame = CTkFrame(self, fg_color="transparent")
        option_frame.pack(expand=True, fill='both')

        CTkLabel(option_frame, text="출제할 문제 유형을 선택하세요:", font=(self.default_font, 14), text_color="black").pack(pady=10)

        options = ["동의어 고르기 (4지선다)", "동의어가 아닌 것 고르기 (4지선다)"]
        for option in options:
            CTkRadioButton(option_frame, text=option, variable=self.option_var, value=option,
                           font=(self.default_font, 12, "bold"), text_color="black",
                           fg_color="#CA7900", hover_color="#DDA15C").pack(anchor='w', padx=20, pady=5)

        self.create_button_frame()

        self.protocol("WM_DELETE_WINDOW", self.on_closing)
        self.bind('<Escape>', lambda event: self.on_closing())  # Bind Esc key to close window

    def create_button_frame(self):
        button_frame = CTkFrame(self, fg_color="#2B3D2D", height=50)
        button_frame.pack(side='bottom', fill='x')
        button_frame.pack_propagate(False)

        confirm_button = CTkButton(button_frame, text="확인", command=self.on_confirm, width=70, height=25,
                                   fg_color="#FEF9E0", hover_color="#DDA15C", text_color='black',
                                   font=(self.default_font, 13, 'bold'))
        confirm_button.place(relx=0.5, rely=0.5, anchor='center')  # Center the button

    def on_confirm(self):
        selected_option = self.option_var.get()
        print(f"Selected option: {selected_option}")
        self.save_last_option(selected_option)

        if self.set_checkbox_func:
            self.set_checkbox_func(True)

        self.destroy()

    def on_closing(self):
        self.destroy()

    def load_last_option(self):
        if os.path.exists(OPTIONS_FILE):
            with open(OPTIONS_FILE, 'r', encoding='utf-8') as f:
                data = json.load(f)
                last_option = data.get('last_synonym_option', 'option_A')
                if last_option == 'option_A':
                    return "동의어 고르기 (4지선다)"
                elif last_option == 'option_B':
                    return "동의어가 아닌 것 고르기 (4지선다)"
        return "동의어 고르기 (4지선다)"

    def save_last_option(self, option):
        options = {}
        if os.path.exists(OPTIONS_FILE):
            with open(OPTIONS_FILE, 'r', encoding='utf-8') as f:
                options = json.load(f)

        if option == "동의어 고르기 (4지선다)":
            options['last_synonym_option'] = 'option_A'
        elif option == "동의어가 아닌 것 고르기 (4지선다)":
            options['last_synonym_option'] = 'option_B'

        with open(OPTIONS_FILE, 'w', encoding='utf-8') as f:
            json.dump(options, f, ensure_ascii=False)
"""

class CustomOptionWindow(CTkToplevel):
    def __init__(self, master, set_checkbox_func=None, *args, **kwargs):
        super().__init__(master, *args, **kwargs)
        self.title("커스텀 프롬프트 편집")
        self.geometry("800x380")  # Increased width to accommodate side-by-side layout
        self.grab_set()
        self.focus_set()
        self.default_font = font_handler.default_font
        self.set_checkbox_func = set_checkbox_func

        self.configure(fg_color="#eff3f0")

        self.copy_manager = CopyManager(self)
        if sys.platform.startswith('darwin'):            
            self.bind("<KeyPress>", self.copy_manager.handle_keypress)


        self.ai_mapping = {
            "OpenAI GPT-4o": "gpt-4o",
            "OpenAI GPT-5": "gpt-5",
            "Claude Sonnet 4.5": "claude-sonnet-4-5-20250929",
            "Google Gemini 2.5 flash": "gemini-2.5-flash"
        }

        self.last_ai = self.load_last_ai()
        print(f"last_ai: {self.last_ai}")
        self.ai_var = tk.StringVar(value=self.last_ai)


        # Main container frame
        main_frame = CTkFrame(self, fg_color="#EFF3F0")
        main_frame.pack(fill='both', expand=True, padx=20, pady=20)
        main_frame.grid_columnconfigure(0, weight=3)  # Prompt frame takes more space
        main_frame.grid_columnconfigure(1, weight=1)  # AI frame takes less space



        # Prompt section
        self.prompt_frame = CTkFrame(main_frame, fg_color="#EFF3F0")
        self.prompt_frame.grid(row=0, column=0, sticky="nsew", padx=(0, 10))

        CTkLabel(self.prompt_frame, text="커스텀 프롬프트 입력:", font=(self.default_font, 14), text_color="black").pack(pady=0)

        self.text_for_customprompt = CTkTextbox(self.prompt_frame, wrap="word", font=(self.default_font, 13), fg_color="#FFFFF8", border_width=1, corner_radius=10)
        self.text_for_customprompt.pack(fill='both', expand=True, padx=10, pady=5)
        self.text_for_customprompt.insert(END, self.load_custom_prompt())

        # Preset controls
        preset_frame = CTkFrame(self.prompt_frame, fg_color="transparent")
        preset_frame.pack(fill='x', padx=10, pady=5)

        CTkLabel(preset_frame, text="불러오기:", font=(self.default_font, 12), text_color="black").pack(side=tk.LEFT, padx=(0, 5))
        self.preset_combobox = CTkComboBox(preset_frame, font=(self.default_font, 12), command=self.on_preset_selected, state='readonly', width=150)
        self.preset_combobox.pack(side=tk.LEFT, padx=5)
        
        CTkButton(preset_frame, text="삭제", command=self.커스텀옵션delete_preset, width=60, fg_color="white", hover_color="#DDA15C", text_color="black").pack(side=tk.RIGHT, padx=5)
        CTkButton(preset_frame, text="저장", command=self.커스텀옵션save_preset, width=60, fg_color="white", hover_color="#DDA15C", text_color="black").pack(side=tk.RIGHT, padx=5)

        self.preset_name_entry = CTkEntry(preset_frame, width=150, placeholder_text="저장할 이름 입력")
        self.preset_name_entry.pack(side=tk.RIGHT, padx=5)
        

        # AI model section
        ai_frame = CTkFrame(main_frame, fg_color="#EFF3F0")
        ai_frame.grid(row=0, column=1, sticky="nsew", padx=(10, 0))

        CTkLabel(ai_frame, text="사용할 AI 모델 선택:", font=(self.default_font, 14), text_color="black").pack(pady=(0, 10), anchor='w')

        for ai in self.ai_mapping.keys():
            CTkRadioButton(ai_frame, text=ai, variable=self.ai_var, value=ai,
                        font=(self.default_font, 12, "bold"), text_color="black",
                        fg_color="#CA7900", hover_color="#DDA15C").pack(pady=5, anchor='w')


        # Button frame
        button_frame = CTkFrame(self, fg_color="#2B3D2D")
        button_frame.pack(fill='x', padx=0, pady=0)

        CTkButton(button_frame, text="확인", command=self.on_confirm, width=100, 
                fg_color="#FEF9E0", hover_color="#DDA15C", text_color='black',
                font=(self.default_font, 13, 'bold')).pack(pady=10)
        
        
        self.protocol("WM_DELETE_WINDOW", self.on_closing)
        self.bind('<Escape>', lambda event: self.on_closing())

        self.load_presets()

    def load_custom_prompt(self):
        file_path = app_data_dir / "custom_prompt.txt"
        
        # Try multiple encodings
        encodings_to_try = ['utf-8', 'cp949', 'euc-kr', 'latin1']
        
        for encoding in encodings_to_try:
            try:
                with open(file_path, "r", encoding=encoding) as file:
                    return file.read().strip()
            except FileNotFoundError:
                return ""  # Return an empty string if no custom prompt has been saved
            except UnicodeDecodeError:
                continue  # Try the next encoding
        
        # If all encodings fail, try binary mode and handle manually
        try:
            with open(file_path, "rb") as file:
                content = file.read()
                # Try to detect encoding or just use a fallback with replacement
                return content.decode('utf-8', errors='replace').strip()
        except FileNotFoundError:
            return ""
        except Exception as e:
            print(f"Could not read custom_prompt.txt: {str(e)}")
            return ""

    def load_presets(self):
        presets_file_path = app_data_dir / "customprompt_presets.json"
        try:
            with open(presets_file_path, 'r', encoding='utf-8') as file:
                self.CUSTOM_OPTION_presets = json.load(file)
        except FileNotFoundError:
            self.CUSTOM_OPTION_presets = {}
        self.preset_combobox.configure(values=list(self.CUSTOM_OPTION_presets.keys()))

    def on_preset_selected(self, preset_name):
        if preset_name in self.CUSTOM_OPTION_presets:
            self.text_for_customprompt.delete("1.0", tk.END)
            self.text_for_customprompt.insert("1.0", self.CUSTOM_OPTION_presets[preset_name])

    def 커스텀옵션save_preset(self):
        preset_name = self.preset_name_entry.get().strip()
        if preset_name:
            preset_content = self.text_for_customprompt.get("1.0", tk.END).strip()
            self.CUSTOM_OPTION_presets[preset_name] = preset_content
            self.커스텀옵션save_presets_to_file()
            self.preset_combobox.configure(values=list(self.CUSTOM_OPTION_presets.keys()))
            self.preset_combobox.set(preset_name)
            self.preset_name_entry.delete(0, tk.END)

    def 커스텀옵션delete_preset(self):
        preset_name = self.preset_combobox.get()
        if preset_name in self.CUSTOM_OPTION_presets:
            del self.CUSTOM_OPTION_presets[preset_name]
            self.save_presets_to_file()
            self.preset_combobox.configure(values=list(self.CUSTOM_OPTION_presets.keys()))
            if self.CUSTOM_OPTION_presets:
                self.preset_combobox.set(list(self.CUSTOM_OPTION_presets.keys())[0])
            else:
                self.preset_combobox.set("")

    def 커스텀옵션save_presets_to_file(self):
        presets_file_path = app_data_dir / "customprompt_presets.json"
        with open(presets_file_path, 'w', encoding='utf-8') as file:
            json.dump(self.CUSTOM_OPTION_presets, file, ensure_ascii=False)

    def load_last_ai(self):
        if os.path.exists(OPTIONS_FILE):
            with open(OPTIONS_FILE, 'r', encoding='utf-8') as f:
                data = json.load(f)
                last_ai_api = data.get('last_ai', "gpt-4o")
                
                # Convert API value back to display name for UI selection
                for display_name, api_value in self.ai_mapping.items():
                    if api_value == last_ai_api:
                        return display_name
        
        # Default to the first AI option if no match is found
        return "OPENAI GPT-4o"

    def save_last_ai(self, ai):
        options = {}
        if os.path.exists(OPTIONS_FILE):
            with open(OPTIONS_FILE, 'r', encoding='utf-8') as f:
                options = json.load(f)
        options['last_ai'] = ai
        with open(OPTIONS_FILE, 'w', encoding='utf-8') as f:
            json.dump(options, f, ensure_ascii=False)

    def on_confirm(self):
        selected_ai_display = self.ai_var.get()
        self.selected_ai = self.ai_mapping[selected_ai_display]
        self.save_last_ai(self.selected_ai)
        
        custom_prompt = self.text_for_customprompt.get("1.0", tk.END).strip()
        file_path = app_data_dir / "custom_prompt.txt"
        with open(file_path, "w", encoding='utf-8') as file:
            file.write(custom_prompt)
        
        print(f"Selected AI: {self.selected_ai}")
        print(f"Custom Prompt saved to: {file_path}")


        if self.set_checkbox_func:
            # Set the checkbox state to True
            self.set_checkbox_func(True)

        self.destroy()

    def on_closing(self):
        self.destroy()






class VoiceOptionsWindow(CTkToplevel):
    def __init__(self, master, set_checkbox_func=None, *args, **kwargs):
        super().__init__(master, *args, **kwargs)
        self.title("음성 옵션")
        self.geometry("450x720")
        self.grab_set()
        self.focus_set()
        self.default_font = font_handler.default_font
        self.set_checkbox_func = set_checkbox_func

        self.configure(fg_color="#eff3f0")
        self.pack_propagate(False)

        if not pygame.get_init():
            pygame.init()

        pygame.mixer.init()

        # Single source of truth for voice data
        VOICE_DATA = {
            "alloy": "여성, 중저음, 허스키한",
            "ash": "남성, 중저음, 거친 듯 활기찬",
            "ballad": "남성, 중고음, 맑은, 영국식 억양",
            "coral": "여성, 고음, 맑은, 지시 반응성 매우 좋음",
            "echo": "남성, 중고음, 활기차고 따뜻한",
            "fable": "여성, 중음, 영국/뉴질랜드 억양",
            "onyx": "남성, 저음, 허스키한, 넓은 음역",
            "nova": "여성, 중음, 지시 반응성 매우 좋음",
            "sage": "여성, 고음, 지시 반응성 매우 좋음",
            "shimmer": "여성, 중저음, 차분한, 지시 반응성 좋음",
            "verse": "남성, 중고음, 지시 반응성 최고",
            "alternating": "남녀 교차 (W: Sage, M: Verse)"
        }

        # Generate display names and mappings from VOICE_DATA
        self.voice_mapping = {
            f"{voice_id.capitalize()} ({description})": voice_id
            for voice_id, description in VOICE_DATA.items()
        }

        # Generate voice URLs 
        self.voice_urls = {
            f"{voice_id.capitalize()} ({description})": f"https://frontierenglish.net/autoqmdata/tts_voice_samples/{voice_id}.mp3"
            for voice_id, description in VOICE_DATA.items()
        }

        self.last_voice, self.last_speed, self.last_instructions = self.load_last_options()
        self.voice_var = tk.StringVar(value=self.last_voice)
        self.speed_var = tk.DoubleVar(value=self.last_speed)

        # Main scrollable frame
        main_frame = CTkScrollableFrame(self, fg_color="transparent")
        main_frame.pack(expand=True, fill='both', padx=10, pady=(10, 5))

        # Voice selection section
        CTkLabel(main_frame, text="음성을 선택하세요:", font=(self.default_font, 14), text_color="black").pack(pady=(0, 3))

        # Generate voices list from voice_mapping
        voices = list(self.voice_mapping.keys())

        self.temp_files = {}
        self.play_buttons = {}
        self.current_playing = None

        for voice in voices:
            frame = CTkFrame(main_frame, fg_color="transparent", corner_radius=5)
            frame.pack(fill='x', padx=20, pady=5)

            CTkRadioButton(frame, text=voice, variable=self.voice_var, value=voice,
                        font=(self.default_font, 12, "bold"), text_color="black",
                        fg_color="#CA7900", hover_color="#DDA15C",
                        command=lambda v=voice: self.on_voice_selected(v)).pack(side='left', padx=(10, 10))

            # Only show play button if voice has a sample URL
            if voice in self.voice_urls:
                play_button = CTkButton(frame, text="▶", width=45, height=15,
                                        fg_color="white", hover_color="#DDA15E", text_color="black",
                                        font=(self.default_font, 11), command=lambda v=voice: self.toggle_audio(v))
                play_button.pack(side='right', padx=(0, 10))
                self.play_buttons[voice] = play_button

        # Speed control section
        speed_frame = CTkFrame(main_frame, fg_color="transparent")
        speed_frame.pack(fill='x', padx=20, pady=10)

        CTkLabel(speed_frame, text="속도 (0.25 ~ 4.0):", font=(self.default_font, 14), text_color="black").pack(anchor='w', pady=(0, 5))

        speed_control_frame = CTkFrame(speed_frame, fg_color="transparent")
        speed_control_frame.pack(fill='x')

        self.speed_slider = CTkSlider(speed_control_frame, from_=0.25, to=4.0, variable=self.speed_var,
                                       number_of_steps=75, width=250, fg_color="#CA7900", progress_color="#DDA15C",
                                       command=self.update_speed_label)
        self.speed_slider.pack(side='left', padx=(0, 0))

        self.speed_label = CTkLabel(speed_control_frame, text=f"{self.last_speed:.2f}x",
                                     font=(self.default_font, 12), text_color="black", width=50)
        self.speed_label.pack(side='left')

        # Instructions textbox section
        instructions_frame = CTkFrame(main_frame, fg_color="transparent")
        instructions_frame.pack(fill='x', padx=20, pady=(0, 10))

        CTkLabel(instructions_frame, text="어떻게 읽어야 할지 아래에 지시사항을 적어주세요.",
                 font=(self.default_font, 12), text_color="black", wraplength=400).pack(anchor='w', pady=(0, 5))

        self.instructions_textbox = CTkTextbox(instructions_frame, height=100, font=(self.default_font, 11),
                                                fg_color="white", text_color="black", border_width=1,
                                                border_color="#CA7900")
        self.instructions_textbox.pack(fill='x')
        if self.last_instructions:
            self.instructions_textbox.insert("1.0", self.last_instructions)

        self.create_button_frame()

        self.protocol("WM_DELETE_WINDOW", self.on_closing)
        self.bind('<Escape>', lambda event: self.on_closing())  # Bind Esc key to close window

    def update_speed_label(self, value):
        self.speed_label.configure(text=f"{float(value):.2f}x")

    def reset_instructions(self):
        default_instructions = "You are a voice actor reading English listening comprehension script. Read the script naturally and friendly."
        self.instructions_textbox.delete("1.0", "end")
        self.instructions_textbox.insert("1.0", default_instructions)

    def create_button_frame(self):
        button_frame = CTkFrame(self, fg_color="#2B3D2D", height=50)
        button_frame.pack(side='bottom', fill='x')
        button_frame.pack_propagate(False)

        reset_button = CTkButton(button_frame, text="지시사항 초기화", command=self.reset_instructions, width=120, height=25,
                fg_color="#FEF9E0", hover_color="#DDA15C", text_color='black',
                font=(self.default_font, 13, 'bold'))
        reset_button.pack(side='left', padx=20, pady=12)

        confirm_button = CTkButton(button_frame, text="확인", command=self.on_confirm, width=70, height=25,
                fg_color="#FEF9E0", hover_color="#DDA15C", text_color='black',
                font=(self.default_font, 13, 'bold'))
        confirm_button.pack(side='right', padx=20, pady=12)

    def toggle_audio(self, voice):
        if self.current_playing == voice and pygame.mixer.music.get_busy():
            pygame.mixer.music.pause()
            self.play_buttons[voice].configure(text="▶")
            self.current_playing = None
        else:
            if self.current_playing:
                pygame.mixer.music.stop()
                self.play_buttons[self.current_playing].configure(text="▶")

            url = self.voice_urls[voice]
            if url not in self.temp_files:
                temp_file = tempfile.NamedTemporaryFile(delete=False, suffix='.mp3')
                urllib.request.urlretrieve(url, temp_file.name)
                self.temp_files[url] = temp_file.name

            pygame.mixer.music.load(self.temp_files[url])
            pygame.mixer.music.play()
            self.play_buttons[voice].configure(text="⏸")
            self.current_playing = voice

    def load_last_options(self):
        voice = "Alloy (여성, 중저음, 허스키한)"
        speed = 1.0
        default_instructions = """Voice Affect: Calm, composed, and reassuring. Competent and in control, instilling trust.

Tone: Sincere, empathetic, with genuine concern for the customer and understanding of the situation.

Pacing: Slower during the apology to allow for clarity and processing. Faster when offering solutions to signal action and resolution.

Emotions: Calm reassurance, empathy, and gratitude.

Pronunciation: Clear, precise: Ensures clarity, especially with key details. Focus on key words like "refund" and "patience."

Pauses: Before and after the apology to give space for processing the apology."""
        instructions = default_instructions

        if os.path.exists(OPTIONS_FILE):
            with open(OPTIONS_FILE, 'r', encoding='utf-8') as f:
                data = json.load(f)
                saved_voice = data.get('last_voice', "alloy")
                speed = data.get('tts_speed', 1.0)
                instructions = data.get('tts_instructions', default_instructions)

                for display_name, voice_name in self.voice_mapping.items():
                    if voice_name == saved_voice:
                        voice = display_name
                        break

        return voice, speed, instructions

    def save_last_options(self, voice, speed, instructions):
        options = {}
        if os.path.exists(OPTIONS_FILE):
            with open(OPTIONS_FILE, 'r', encoding='utf-8') as f:
                options = json.load(f)

        options['last_voice'] = self.voice_mapping[voice]
        options['tts_speed'] = speed
        options['tts_instructions'] = instructions
        options['tts_model'] = 'gpt-4o-mini-tts'

        with open(OPTIONS_FILE, 'w', encoding='utf-8') as f:
            json.dump(options, f, ensure_ascii=False)

    def on_voice_selected(self, voice_display):
        """Called when a voice radio button is clicked"""
        voice_id = self.voice_mapping.get(voice_display)
        if voice_id == "alternating":
            self.show_alternating_voice_info()
            # Set default instructions for alternating voice
            #default_alternating_instructions = """You are a voice actor reading English listening comprehension script. Read the script naturally and friendly."""
            #self.instructions_textbox.delete("1.0", "end")
            #self.instructions_textbox.insert("1.0", default_alternating_instructions)

    def show_alternating_voice_info(self):
        """Show information popup for alternating voice option"""
        info_window = CTkToplevel(self)
        info_window.title("남녀 교차 음성 안내")
        info_window.geometry("550x400")
        info_window.grab_set()
        info_window.configure(fg_color="#eff3f0")

        # Center the window
        info_window.transient(self)

        # Info message
        info_text = """남녀 교차 음성을 사용하시려면 지문에 W: M: 로 남/녀 대화가 구분되어 있어야 합니다.
• M: 로 시작하는 대사는 Verse (남성) 음성으로 읽힙니다.
• W: 로 시작하는 대사는 Sage (여성) 음성으로 읽힙니다.
• W:, M: 표시가 없는 경우 기본 음성은 Sage (여성)입니다.

특별 기능:
• 첫 줄에 '듣고'가 포함된 발문(ex: 대화를 듣고, ...)을 적으면 발문을 별도의 한국어 음성으로 읽습니다.
• 문제 번호를 쓸 경우 숫자(15.)가 아닌 한글 문자(십 오번.)를 사용해야 정확히 읽습니다.

예시:
십 오번. 대화를 듣고, 남자의 의견으로 가장 적절한 것을 고르시오
M: Honey, I was thinking about asking our daughter to sign up for drama camp this winter. What do you think?
W: Hmm. Why do you want her to participate in drama camp?
"""

        # Pack button at the bottom first
        CTkButton(info_window, text="확인", command=info_window.destroy,
                 fg_color="#FEF9E0", hover_color="#DDA15C", text_color='black',
                 font=(self.default_font, 13, 'bold')).pack(side='bottom', pady=20)

        # Then pack the label content
        CTkLabel(info_window, text=info_text, font=(self.default_font, 12),
                text_color="black", justify="left", wraplength=450).pack(pady=20, padx=20)

    def on_confirm(self):
        pygame.mixer.music.stop()
        selected_voice_display = self.voice_var.get()
        self.selected_voice = self.voice_mapping[selected_voice_display]
        self.selected_speed = self.speed_var.get()
        self.selected_instructions = self.instructions_textbox.get("1.0", "end-1c").strip()

        self.save_last_options(selected_voice_display, self.selected_speed, self.selected_instructions)

        print(f"Selected voice: {self.selected_voice}, speed: {self.selected_speed}x")
        if self.selected_instructions:
            print(f"Instructions: {self.selected_instructions}")

        self.set_checkbox_func(True)

        self.destroy()

    def on_closing(self):
        pygame.mixer.music.stop()
        
        for temp_file in self.temp_files.values():
            os.remove(temp_file)
        
        self.destroy()



