#modules/make_questions_options.py
from pathlib import Path
import customtkinter
import tkinter as tk
import json
import os
import sys  
from tkinter import messagebox
from openpyxl import load_workbook
from customtkinter import CTkToplevel, CTkFrame, CTkButton, CTkLabel, CTkScrollableFrame, CTkEntry
from .copymanager import CopyManager
from .functions import ToolTip유형설명

# File path constants for options JSON files
GLOBAL_OPTIONS_FILE = "make_questions_options.json"
MOCKTEST_OPTIONS_FILE = "manual_mocktest_options.json"

def get_default_options_file_path(app_data_dir):
    """Returns path to global options file."""
    return os.path.join(str(app_data_dir), GLOBAL_OPTIONS_FILE)

def get_mocktest_options_file_path(app_data_dir):
    """Returns path to mocktest options file."""
    return os.path.join(str(app_data_dir), MOCKTEST_OPTIONS_FILE)


class ManualQuestionPopup문제선택(CTkToplevel): #WINDOWS
    def __init__(self, parent, main_frame_ref=None, excel_file=None, default_font=None, passage_ids=None, 유형=None, 난이도=None):
        super().__init__(parent)

        print("ManualQuestionPopup문제선택 called")
        print(f"passage_ids: {passage_ids}")

        #self.process_excel_callback = process_excel_callback
        self.title("수동으로 출제할 문제 선택")
        self.geometry("580x400")
        self.minsize(580, 400)

        self.main_frame_ref = main_frame_ref  # Store the reference to main frame
        self.excel_file = excel_file
        self.default_font = default_font

        self.current_status = "자동"

        # If passage_ids is a multi-line string, convert it to a list of lines
        if isinstance(passage_ids, str):
            passage_ids = passage_ids.strip().split('\n')
        self.passage_ids = passage_ids
        self.유형 = 유형
        self.난이도 = 난이도    



        # Define column widths as class constants
        self.COL_WIDTHS = {
            "번호": 40,
            "지문번호": 200,
            "문제유형": 80,
            "출제방식": 80,
            "수동출제": 100
        }



        # Container Frame
        main_frame = CTkFrame(self, fg_color="transparent")
        main_frame.pack(fill="both", expand=True, padx=10, pady=10)
        main_frame.grid_rowconfigure(1, weight=1)
        main_frame.grid_columnconfigure(0, weight=1)

        # Header
        # Header
        header_frame = CTkFrame(main_frame, fg_color="transparent")
        header_frame.grid(row=0, column=0, sticky="ew", padx=(5, 25))
        
        # Configure columns with exact widths
        header_frame.grid_columnconfigure(0, weight=0, minsize=self.COL_WIDTHS["번호"])
        header_frame.grid_columnconfigure(1, weight=0, minsize=self.COL_WIDTHS["지문번호"])
        header_frame.grid_columnconfigure(2, weight=0, minsize=self.COL_WIDTHS["문제유형"])
        header_frame.grid_columnconfigure(3, weight=0, minsize=self.COL_WIDTHS["출제방식"])
        header_frame.grid_columnconfigure(4, weight=0, minsize=self.COL_WIDTHS["수동출제"])

        # Header labels
        CTkLabel(header_frame, width=self.COL_WIDTHS["번호"], height=18, text="번호",
                font=(self.default_font, 11), fg_color="transparent", text_color=("black", "white")
                ).grid(row=0, column=0, sticky='nsew', padx=(0, 5), pady=(5, 0))

        CTkLabel(header_frame, width=self.COL_WIDTHS["지문번호"], height=18, text="지문번호",
                font=(self.default_font, 11), fg_color="transparent", text_color=("black", "white")
                ).grid(row=0, column=1, sticky='nsew', padx=(5, 5), pady=(5, 0))

        CTkLabel(header_frame, width=self.COL_WIDTHS["문제유형"], height=18, text="문제유형",
                font=(self.default_font, 11), fg_color="transparent", text_color=("black", "white")
                ).grid(row=0, column=2, sticky='nsew', padx=(0, 5), pady=(5, 0))

        CTkLabel(header_frame, width=self.COL_WIDTHS["출제방식"], height=18, text="출제방식",
                font=(self.default_font, 11), fg_color="transparent", text_color=("black", "white")
                ).grid(row=0, column=3, sticky='nsew', padx=(0, 5), pady=(5, 0))

        CTkLabel(header_frame, width=self.COL_WIDTHS["수동출제"], height=18, text="수동출제 설정",
                font=(self.default_font, 11), fg_color="transparent", text_color=("black", "white")
                ).grid(row=0, column=4, sticky='nsew', padx=(0, 5), pady=(5, 0))

        # Scrollable Frame
        self.scrollable_frame = CTkScrollableFrame(main_frame, fg_color="transparent")
        self.scrollable_frame.grid(row=1, column=0, sticky='nsew', padx=0, pady=0)
        
        # Use the same column configurations for scrollable frame
        self.scrollable_frame.grid_columnconfigure(0, weight=0, minsize=self.COL_WIDTHS["번호"])
        self.scrollable_frame.grid_columnconfigure(1, weight=0, minsize=self.COL_WIDTHS["지문번호"])
        self.scrollable_frame.grid_columnconfigure(2, weight=0, minsize=self.COL_WIDTHS["문제유형"])
        self.scrollable_frame.grid_columnconfigure(3, weight=0, minsize=self.COL_WIDTHS["출제방식"])
        self.scrollable_frame.grid_columnconfigure(4, weight=0, minsize=self.COL_WIDTHS["수동출제"])



        # Load all rows
        self.row_widgets = []
        for i, passage_id in enumerate(self.passage_ids, start=1):
            self.add_row(i, passage_id)
            self.update_current_status_label(i, passage_id)            

        

        # Bottom frame with two buttons
        button_frame = CTkFrame(self, fg_color="#2B3D2D")
        button_frame.pack(side='bottom', fill='x', pady=(5, 0))

        # Buttons at the bottom: only "취소" and "출제시작"
        start_button = CTkButton(
            button_frame,
            text="확인",
            width=70,
            height=25,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color='black',
            font=(self.default_font, 13, 'bold'),
            command=self.start
        )
        start_button.pack(side='right', padx=10, pady=5)

        cancel_button = CTkButton(
            button_frame,
            text="기본값 복원",
            width=70,
            height=25,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color='black',
            font=(self.default_font, 13, 'bold'),
            command=self.cancel
        )
        cancel_button.pack(side='left', padx=10, pady=5)

        self.bind("<Escape>", self.cancel)

    def add_row(self, row_idx, passage_id):
        # Column 0: Row number
        index_label = CTkLabel(self.scrollable_frame,
                            text=str(row_idx),
                            font=(self.default_font, 10, "bold"),
                            width=self.COL_WIDTHS["번호"],
                            height=19,
                            corner_radius=5,
                            text_color="black",
                            fg_color="#B6C2B7")
        index_label.grid(row=row_idx, column=0, sticky='ew', padx=(0, 5), pady=3)

        # Column 1: 지문번호
        passage_label = CTkLabel(self.scrollable_frame,
                                text=passage_id,
                                font=(self.default_font, 11),
                                fg_color="#FEF9E0",
                                text_color="black",
                                width=self.COL_WIDTHS["지문번호"]-10,
                                wraplength=self.COL_WIDTHS["지문번호"]-20,
                                anchor="center")
        passage_label.grid(row=row_idx, column=1, sticky='ew', padx=(5, 5), pady=3)

        # Column 2: 문제유형
        type_label = CTkLabel(self.scrollable_frame,
                                text=self.유형,
                                font=(self.default_font, 11),
                                fg_color="#FEF9E0",
                                text_color="black",
                                width=self.COL_WIDTHS["문제유형"],
                                anchor="center")
        type_label.grid(row=row_idx, column=2, sticky='ew', padx=(5, 5), pady=3)

        # Column 3: 출제방식
        current_status_label = CTkLabel(self.scrollable_frame,
                                        font=(self.default_font, 11),
                                        fg_color="#FEF9E0",
                                        width=self.COL_WIDTHS["출제방식"],
                                        anchor="center")

        if self.main_frame_ref and hasattr(self.main_frame_ref, 'manual_edited_texts') and passage_id in self.main_frame_ref.manual_edited_texts:
            current_status_label.configure(text="수동", text_color="red")
        else:
            current_status_label.configure(text="자동", text_color=("black", "white"))

        current_status_label.grid(row=row_idx, column=3, sticky='ew', padx=(5, 5), pady=3)

        # Column 4: 수동출제 버튼
        manual_button = CTkButton(
            self.scrollable_frame,
            text="수동출제",
            width=self.COL_WIDTHS["수동출제"]-20,  # Slightly smaller to account for padding
            height=25,
            fg_color="white",
            hover_color="#DDA15E",
            text_color="black",
            font=(self.default_font, 11),
            command=lambda idx=row_idx, pid=passage_id: self.on_manual_button_click(idx, pid)
        )
        manual_button.grid(row=row_idx, column=4, sticky='ew', padx=(5, 5), pady=3)

        row_data = {
            'index_label': index_label,
            'passage_label': passage_label,
            'manual_button': manual_button,
            'passage_id': passage_id,
            'current_status_label': current_status_label,
            'row_idx': row_idx
        }
        self.row_widgets.append(row_data)

    def update_current_status_label(self, row_idx, passage_id):
        print("update_current_status_label called")
        print(self.main_frame_ref.manual_edited_texts)
        # Loop through row_widgets to find the matching row
        for row_data in self.row_widgets:
            if row_data['row_idx'] == row_idx:
                current_status_label = row_data['current_status_label']
                # Check if passage_id is now in manual_edited_texts

                수동지문있는지확인용 = passage_id + " // " + self.유형
                print(f"수동지문있는지확인용: {수동지문있는지확인용}")
                if 수동지문있는지확인용 in self.main_frame_ref.manual_edited_texts:
                    current_status_label.configure(text="수동", text_color="red")
                else:
                    current_status_label.configure(text="자동", text_color=("black", "white"))
                break


    def on_manual_button_click(self, row_idx, passage_id):
        def save_callback(row_idx, 수동출제할지문번호, 유형, 난이도, edited_text):
            self.main_frame_ref.save_manual_placement_text일반(row_idx, 수동출제할지문번호, 유형, 난이도, edited_text)
            # Update the current status label after manual text is saved
            self.update_current_status_label(row_idx, 수동출제할지문번호)

        popup = ManualPlacementPopup(
            parent=self,
            default_font=self.default_font,
            excel_file=self.excel_file,
            row_idx=row_idx,
            수동출제할지문번호=passage_id,
            유형=self.유형,
            난이도="Normal",
            save_callback=save_callback,
            manual_edited_texts=self.main_frame_ref.manual_edited_texts,
            일반or실모="일반"
        )
        popup.grab_set()



    def start(self):       
        self.destroy()        

    def cancel(self, event=None):       
        self.destroy()        


    def restore_default_values(self, event=None):
        response = messagebox.askyesno("주의", f"수동으로 수정한 지문을 모두 원래 지문으로 복원하시겠습니까?")
        if response is True:

            # Remove all passages shown here from manual_edited_texts
            for row_data in self.row_widgets:
                passage_id = row_data['passage_id']
                if passage_id in self.main_frame_ref.manual_edited_texts:
                    del self.main_frame_ref.manual_edited_texts[passage_id]
                
                # Update the current status label for each row after deletion
                self.update_current_status_label(row_data['row_idx'], passage_id)




class ManualPlacementPopup(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font, excel_file, row_idx, 수동출제할지문번호, 유형, 난이도, save_callback, manual_edited_texts=None, 일반or실모=None, manual_mocktest_popup=None):
        super().__init__(parent)
        self.title("수동출제할 지문 수정")
        self.geometry("650x400")
        self.minsize(650, 400)
        self.parent = parent  
        self.default_font = default_font
        self.excel_file = excel_file
        self.row_idx = row_idx
        self.수동출제할지문번호 = 수동출제할지문번호
        self.유형 = 유형
        print(f"class ManualPlacementPopup called")
        print(f"유형: {self.유형}")
        self.난이도 = 난이도   
        self.save_callback = save_callback
        self.manual_edited_texts=manual_edited_texts
        print(f"self.manual_edited_texts: {self.manual_edited_texts}")
        self.일반or실모 = 일반or실모
        self.manual_mocktest_popup = manual_mocktest_popup


        self.수동출제할지문번호and유형 = self.수동출제할지문번호 + " // " + self.유형
        self.수동출제할지문번호and유형and난이도 = self.수동출제할지문번호 + " // " + self.유형 + "_" + self.난이도
        
        self.copy_manager = CopyManager(self)

        if self.일반or실모 == "일반":
            if self.수동출제할지문번호and유형 in self.manual_edited_texts:
                self.loaded_text = self.manual_edited_texts[self.수동출제할지문번호and유형]
            else:
                # Load text from Excel
                self.loaded_text = self.load_text_from_excel(self.excel_file, self.수동출제할지문번호)
        elif self.일반or실모 == "실모":
            if self.수동출제할지문번호and유형and난이도 in self.manual_edited_texts:
                self.loaded_text = self.manual_edited_texts[self.수동출제할지문번호and유형and난이도]
            else:
                # Load text from Excel
                self.loaded_text = self.load_text_from_excel(self.excel_file, self.수동출제할지문번호)



        main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        main_frame.pack(fill='both', expand=True, padx=20, pady=20)

        # Row 1: Labels
        label_frame = customtkinter.CTkFrame(main_frame, fg_color="transparent")
        label_frame.pack(side='top', fill='x', pady=(0,10))
        
        row_idx_label0 = customtkinter.CTkLabel(
            label_frame, text="번호:", font=(self.default_font, 12, 'bold'), text_color=('black', 'white')
        )
        row_idx_label0.pack(side='left', padx=0)
        row_idx_label = customtkinter.CTkEntry(
            label_frame, width=30, border_width=1, corner_radius=0, fg_color="#d7d7d7",
            font=(self.default_font, 12, 'bold'), text_color='black'
        )
        row_idx_label.pack(side='left', padx=(5, 10))
        row_idx_label.insert(0, f"{self.row_idx}")
        row_idx_label.configure(state="disabled")
        

        waiting_label0 = customtkinter.CTkLabel(
            label_frame, text="지문번호:", font=(self.default_font, 12, 'bold'), text_color=('black', 'white')
        )
        waiting_label0.pack(side='left', padx=0)

        waiting_label = customtkinter.CTkEntry(
            label_frame, width=220, border_width=1, corner_radius=0, fg_color="#d7d7d7",
            font=(self.default_font, 12, 'bold'), text_color='black'
        )
        waiting_label.pack(side='left', padx=(5, 10), fill='x', expand=True)
        waiting_label.insert(0, f"{self.수동출제할지문번호}")
        waiting_label.configure(state="disabled")
        






        난이_label = customtkinter.CTkEntry(
            label_frame, width=60, border_width=1, corner_radius=0, fg_color="#d7d7d7",
            font=(self.default_font, 12, 'bold'), text_color='black')
        난이_label.pack(side='right', padx=(5, 0))
        난이_label.insert(0, f"{self.난이도}")
        난이_label.configure(state="disabled")

        난이_label0 = customtkinter.CTkLabel(
            label_frame, text="난이도:", font=(self.default_font, 12, 'bold'), text_color=('black', 'white'))
        난이_label0.pack(side='right', padx=0)


        유형_label = customtkinter.CTkEntry(
            label_frame, width=80, border_width=1, corner_radius=0, fg_color="#d7d7d7",
            font=(self.default_font, 12, 'bold'), text_color='black')
        유형_label.pack(side='right', padx=(5, 10))
        유형_label.insert(0, f"{self.유형}")
        유형_label.configure(state="disabled")


        유형_label0 = customtkinter.CTkLabel(
            label_frame, text="유형:", font=(self.default_font, 12, 'bold'), text_color=('black', 'white'))
        유형_label0.pack(side='right', padx=0)




        # Row 2: Large Textbox
        self.textbox = customtkinter.CTkTextbox(main_frame, width=550, height=150, wrap='word', fg_color="white", text_color="black", activate_scrollbars=True, undo=True, font=(self.default_font, 14))
        self.textbox.pack(side='top', fill='both', expand=True, pady=(0,10))
        if self.loaded_text:
            self.textbox.insert("1.0", self.loaded_text)


        if self.유형 == "요약":
            self.placeholder_text = "이곳에 요약문을 입력하고, 빈칸으로 출제할 단어 2개를 [[  ]]로 표시하세요."

            self.textbox.configure(state="disabled")
            self.요약문textbox = customtkinter.CTkTextbox(main_frame, width=550, height=50, wrap='word', fg_color="white", text_color="black", activate_scrollbars=True, undo=True, font=(self.default_font, 12))
            self.요약문textbox.pack(side='top', fill='both', expand=True, pady=(0,10))
            self.요약문textbox.insert("0.0", self.placeholder_text)
            self.요약문textbox.configure(text_color=('grey', 'lightgrey'))


            # Find the paragraph containing '[[' and assign it to passage
            if self.loaded_text.count('[[') == 2 and self.loaded_text.count(']]') == 2:
                지문passage = ''
                요약문passage = ''
                paragraphs = self.loaded_text.split('\n')
                for paragraph in paragraphs:
                    paragraph = paragraph.strip()  # Remove leading/trailing spaces
                    if not paragraph:  # Skip empty lines
                        continue
                    if '[[' not in paragraph:
                        지문passage += paragraph + '\n'  # Collect all non-summary paragraphs
                    elif '[[' in paragraph:
                        요약문passage = paragraph  # Save the first paragraph with [[ ]]
                        break  # Stop after finding the first 요약문passage

                지문passage = 지문passage.strip()  # Clean up final result
                print(f"지문passage: {지문passage}")
                print(f"요약문passage: {요약문passage}")

                self.textbox.configure(state="normal")
                self.textbox.delete("1.0", "end")
                self.textbox.insert("1.0", 지문passage)
                self.textbox.configure(state="disabled")
                self.요약문textbox.delete("1.0", "end")
                self.요약문textbox.insert("1.0", 요약문passage)
                self.요약문textbox.configure(text_color=('black', 'white'))




            def on_entry_click(event):
                if self.요약문textbox.get("1.0", "end-1c").strip() == self.placeholder_text:
                    self.요약문textbox.delete("1.0", "end")
                    self.요약문textbox.configure(text_color=('black', 'white'))

            def on_entry_focusout(event):
                if not self.요약문textbox.get("1.0", "end-1c").strip():
                    self.요약문textbox.insert("1.0", self.placeholder_text)
                    self.요약문textbox.configure(text_color=('grey', 'lightgrey'))

            self.요약문textbox.bind('<FocusIn>', on_entry_click)
            self.요약문textbox.bind('<FocusOut>', on_entry_focusout)

            



        # Row 3: Instruction Label
        if self.유형 == "어휘3단계":
            안내문 = "정답(반의어)으로 출제할 단어 1개에 <   >, 오답(동의어)으로 출제할 단어 4개에 [   ]를 표시하세요. (반의어만 표시해도 됩니다)\n출제시 난이도는 Normal를 선택하세요."
        elif self.유형 == "함축의미":
            안내문 = "함축의미 문제를 출제할 어구를 [[   ]]로 표시하세요. (대괄호 2개씩)"
        elif self.유형 == "빈칸추론":
            안내문 = "빈칸으로 출제할 부분을 [[   ]]로 표시하세요. (대괄호 2개씩)"
        elif self.유형 == "순서":
            안내문 = "Normal 유형으로 출제할 경우 3군데, Hard 유형으로 출제할 경우 4군데에 // 를 표시하세요. (한 군데에 슬래시 2개씩)"
        elif self.유형 == "삽입":
            안내문 = "주어진 문장으로 사용할 문장을 [[   ]]로 표시하세요. (대괄호 2개씩)"
        elif self.유형 == "요약":
            안내문 = "아래 창에 요약문을 입력하고, 빈칸으로 출제할 단어 2개를 [[   ]]로 표시하세요. (대괄호 2개씩)"

        elif self.유형 == "영작1":
            안내문 = "영작 문제로 출제할 부분을 [[   ]]로 표시하세요. (대괄호 2개씩)\n(영작1은 단어 배열식입니다.)"
        elif self.유형 == "영작2":
            안내문 = "영작 문제로 출제할 부분을 [[   ]]로 표시하세요. (대괄호 2개씩)\n(영작2는 어형변화, 단어추가 가능 유형입니다.)"



        instruction_label = customtkinter.CTkLabel(
            main_frame,
            text=안내문,
            font=(self.default_font, 11),
            text_color=("black", "white")
        )
        instruction_label.pack(side='top', pady=(0,10))

        # Row 4: Buttons
        button_frame = customtkinter.CTkFrame(main_frame, fg_color="transparent")
        button_frame.pack(side='bottom', fill='x', pady=(10,0))


        restore_button = customtkinter.CTkButton(
            button_frame, 
            text="원래 지문 복원",
            font=(self.default_font, 13, 'bold'),
            fg_color="#FEF9E0",
            text_color="black",
            hover_color="#DDA15C",
            command=self.on_restore_default
        )
        restore_button.pack(side='left', padx=5)



        confirm_button = customtkinter.CTkButton(
            button_frame,
            text="확인",
            width=70,
            font=(self.default_font, 13, 'bold'),
            fg_color="#FEF9E0",
            text_color="black",
            hover_color="#DDA15C",
            command=self.on_confirm
        )
        confirm_button.pack(side='right', padx=5)


        cancel_button = customtkinter.CTkButton(
            button_frame, 
            text="닫기",
            width=70,
            font=(self.default_font, 13, 'bold'),
            fg_color="#FEF9E0",
            text_color="black",
            hover_color="#DDA15C",
            command=self.on_cancel
        )
        cancel_button.pack(side='right', padx=5)


        self.modifier_key = None
        if sys.platform.startswith('darwin'):
            # Mac OS
            self.modifier_key = 'Command'
        elif sys.platform.startswith('win'):
            # Windows
            self.modifier_key = 'Control'
        else:
            # Linux or other; adjust as needed
            self.modifier_key = 'Control'


        if sys.platform.startswith('darwin'):                    
            self.textbox.bind("<KeyPress>", self.copy_manager.handle_keypress)
            if self.유형 == "요약":
                self.요약문textbox.bind("<KeyPress>", self.copy_manager.handle_keypress)



        self.bind("<Escape>", self.on_cancel)
        self.textbox.bind(f'<{self.modifier_key}-Return>', self.on_confirm)
        if self.유형 == "요약":
            self.요약문textbox.bind(f'<{self.modifier_key}-Return>', self.on_confirm)


    


    def load_text_from_excel(self, excel_file, waiting_text):
        if not excel_file or not waiting_text:
            return ""

        try:
            wb = load_workbook(excel_file, read_only=True, data_only=True)
            if "대기열" not in wb.sheetnames:
                return ""

            sheet = wb["대기열"]

            # Find the row where column A matches 수동출제할지문번호
            for row in sheet.iter_rows(values_only=True):
                if row and row[0] == waiting_text:
                    # Row found, return column B if available
                    return str(row[1]) if len(row) > 1 and row[1] is not None else ""
            return ""
        except:
            return ""

    def on_restore_default(self, event=None):
        self.loaded_text = self.load_text_from_excel(self.excel_file, self.수동출제할지문번호)
        self.textbox.delete("1.0", "end")
        self.textbox.insert("1.0", self.loaded_text)
        
        if self.일반or실모 == "일반":     
            if self.수동출제할지문번호and유형 in self.manual_edited_texts:
                del self.manual_edited_texts[self.수동출제할지문번호and유형]
        elif self.일반or실모 == "실모":
            if self.수동출제할지문번호and유형and난이도 in self.manual_edited_texts:
                del self.manual_edited_texts[self.수동출제할지문번호and유형and난이도]

        if self.유형 == "요약":
            self.요약문textbox.delete("1.0", "end")
            self.요약문textbox.insert("1.0", self.placeholder_text)
            self.요약문textbox.configure(text_color=('grey', 'lightgrey'))

    def on_cancel(self, event=None):
        if self.일반or실모 == "일반":
            if self.parent and self.parent.winfo_exists() and hasattr(self.parent, 'update_current_status_label'):
                self.parent.update_current_status_label(self.row_idx, self.수동출제할지문번호)

        elif self.일반or실모 == "실모":
            if self.manual_mocktest_popup and self.manual_mocktest_popup.winfo_exists() and hasattr(self.manual_mocktest_popup, 'update_current_status_label수동실모'):
                #self.manual_mocktest_popup.update_current_status_label수동실모(self.row_idx, self.수동출제할지문번호and유형and난이도) #하나만
                self.manual_mocktest_popup.update_current_status_label수동실모(None, self.수동출제할지문번호and유형and난이도) #전체


        self.destroy()

    def on_confirm(self, event=None):
        edited_text = self.textbox.get("1.0", "end-1c").strip()

        if self.유형 == "어휘3단계":
            if edited_text.count('[') != 4 and edited_text.count('<') != 1:
                messagebox.showwarning("경고", "정답(반의어)으로 출제할 단어 1개에 <   >, 오답(동의어)으로 출제할 단어 4개에 [   ]를 표시하세요. (반의어만 표시해도 됩니다) 출제시 난이도는 Normal를 선택하세요.")
                return

        elif self.유형 == "함축의미":
            if '[[' not in edited_text or ']]' not in edited_text:
                messagebox.showwarning("경고", "함축의미 문제를 출제할 어구를 [[  ]]로 표시하세요.")
                return

        elif self.유형 == "빈칸추론":
            if '[[' not in edited_text or ']]' not in edited_text:
                messagebox.showwarning("경고", "빈칸으로 출제할 부분을 [[  ]]로 표시하세요.")
                return

        elif self.유형 == "순서":
            if edited_text.count('//') != 3 and edited_text.count('//') != 4:
                messagebox.showwarning("경고", "Normal 유형으로 출제할 경우 3군데, Hard 유형으로 출제할 경우 4군데에 // 를 표시하세요. (한 군데에 슬래시 2개씩)")
                return

        elif self.유형 == "삽입":
            if '[[' not in edited_text or ']]' not in edited_text:
                messagebox.showwarning("경고", "주어진 문장으로 사용할 문장을 [[   ]]로 표시하세요. (대괄호 2개씩)")
                return

        elif self.유형 == "요약":
            edited_text요약문 = self.요약문textbox.get("1.0", "end-1c").strip()
            if edited_text요약문 == "" or edited_text요약문.count('[[') != 2 or edited_text요약문.count(']]') != 2:
                messagebox.showwarning("경고", "아래 창에 요약문을 입력하고, 빈칸으로 출제할 단어 2개를 [[  ]]로 표시하세요.")
                return
            edited_text = edited_text + "\n\n" + edited_text요약문



        if self.save_callback:
            self.save_callback(self.row_idx, self.수동출제할지문번호, self.유형, self.난이도, edited_text)
        self.destroy()







class QuestionOptions어휘3단계(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, 실모flag=None, 수동출제할지문번호=None, row_idx=None, 유형=None, 난이도=None, passage_ids=None, manual_mocktest_popup=None, options_file_path=None):
        super().__init__(parent)
        self.title('어휘3단계 옵션')
        self.geometry('650x250')
        self.minsize(650, 250)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame
        self.excel_file = excel_file
        self.실모flag = 실모flag
        self.수동출제할지문번호 = 수동출제할지문번호
        self.row_idx = row_idx
        self.유형 = 유형
        self.난이도 = 난이도
        self.passage_ids = passage_ids
        self.manual_mocktest_popup = manual_mocktest_popup

        # Passage transformation variables
        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)  # Default: 같은 난이도
        self.지문길이_var = tk.IntVar(value=2)  # Default: 비슷하게
        self.content_change_var = tk.IntVar(value=0)  # Default: 내용 변화 없음

        self.default_font = default_font
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        # Main frame
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)

        # Passage transformation frame
        transform_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        transform_frame.pack(side='top', fill='x', expand=False, pady=(10, 0))

        # Checkbox
        self.transform_checkbox = customtkinter.CTkCheckBox(
            transform_frame,
            text="지문을 변형하여 출제",
            variable=self.지문변형_var,
            command=self.toggle_difficulty_options,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.transform_checkbox.pack(side='top', anchor='w', pady=(0, 5))

        # Difficulty options container (hidden by default)
        self.difficulty_container = customtkinter.CTkFrame(transform_frame, fg_color="transparent")

        # Label
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 난이도:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame
        radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        radio_frame.grid(row=0, column=1, sticky="w")

        self.radio_easier = customtkinter.CTkRadioButton(
            radio_frame,
            text='더 쉽게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))

        self.radio_same = customtkinter.CTkRadioButton(
            radio_frame,
            text='같은 난이도',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))

        self.radio_harder = customtkinter.CTkRadioButton(
            radio_frame,
            text='더 높게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')

        # Length label and radio buttons (row=1)
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for length
        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")

        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 짧게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))

        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='비슷하게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))

        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 길게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change mode label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for content change
        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='내용 변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "글의 요지는 유지하되, 세부사항에 변화를 줍니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 요지 자체를 바꿉니다", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "EBS 간접연계처럼 소재만 연계하여 새로운 글을 씁니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Initialize radio button states
        self.toggle_difficulty_options()

        # Load saved values
        self.load_values_from_json()

        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10, 0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=100,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Manual placement button (middle)
        if not self.opened_from_dashboard:
            if 실모flag == True:
                수동출제버튼텍스트 = "어휘 위치 수동출제\n(현재 문항)"
                수동출제버튼커맨드 = self.on_manual_placement실모
            else:
                수동출제버튼텍스트 = "어휘 위치 수동출제"
                수동출제버튼커맨드 = self.on_manual_placement

            self.manual_button = customtkinter.CTkButton(
                action_frame,
                text=수동출제버튼텍스트,
                font=(self.default_font, 13, 'bold'),
                width=160,
                height=40,
                fg_color="#FEF9E0",
                hover_color="#DDA15C",
                text_color="black",
                command=수동출제버튼커맨드
            )
            self.manual_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=100,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        confirm_button.pack(side='right', padx=5, pady=(0, 5))

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)

        # Show/hide difficulty options based on loaded checkbox state
        self.toggle_difficulty_options()

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)



    def on_manual_placement(self):
        
        popup = ManualQuestionPopup문제선택(
            parent=self.master,
            main_frame_ref=self.main_frame_ref,
            excel_file=self.excel_file,
            default_font=self.default_font,
            passage_ids=self.passage_ids,
            유형=self.유형,
            난이도=self.난이도,
        )
        self.destroy()

        popup.grab_set()

    def on_manual_placement실모(self):
        # Open the manual placement popup with 실모flag = True
        if self.main_frame_ref is None or self.실모flag is None or self.row_idx is None or self.수동출제할지문번호 is None:
            messagebox.showerror("오류", "필요한 정보가 부족합니다.")
            return

        def save_callback(row_idx, 수동출제할지문번호, 유형, 난이도, edited_text):
            # Called by popup after user hits '확인'
            self.main_frame_ref.save_manual_placement_text실모(row_idx, 수동출제할지문번호, 유형, 난이도, edited_text)
            passageid유형난이도합본 = 수동출제할지문번호 + " // " + 유형 + "_" + 난이도
            self.manual_mocktest_popup.update_current_status_label수동실모(None, passageid유형난이도합본) #전체
        
        popup = ManualPlacementPopup(
            parent=self.master,
            default_font=self.default_font,
            excel_file=self.excel_file, 
            row_idx=self.row_idx,
            수동출제할지문번호=self.수동출제할지문번호,
            유형=self.유형,
            난이도=self.난이도,
            save_callback=save_callback,
            manual_edited_texts=self.main_frame_ref.manual_edited_texts,
            일반or실모="실모",
            manual_mocktest_popup=self.manual_mocktest_popup,
        )
        self.destroy()

        popup.grab_set()

    def on_confirm(self):
        """Save options and update button color"""
        self.save_values_to_json()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update UI state
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def load_values_from_json(self):
        """Load saved option values from JSON"""
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.지문변형_var.set(data.get("어휘3단계paraphrase_enabled", False))
                    self.지문난이도_var.set(data.get("어휘3단계difficulty_level", 2))
                    self.지문길이_var.set(data.get("어휘3단계length_level", 2))
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("어휘3단계content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except:
                pass

    def save_values_to_json(self):
        """Save current option values to JSON"""
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        existing_data["어휘3단계paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["어휘3단계difficulty_level"] = self.지문난이도_var.get()
        existing_data["어휘3단계length_level"] = self.지문길이_var.get()
        # Save content_change_mode (None when checkbox unchecked, actual value when checked)
        existing_data["어휘3단계content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)


class QuestionOptions빈칸추론(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, 실모flag=None, 수동출제할지문번호=None, row_idx=None, 유형=None, 난이도=None, passage_ids=None, manual_mocktest_popup=None, 검토창에서넘어옴=False, options_file_path=None):
        super().__init__(parent)
        self.title('빈칸추론 옵션')
        self.geometry('650x500')
        self.minsize(650, 500)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame  # Store the reference to main frame
        self.excel_file = excel_file
        self.실모flag = 실모flag
        self.수동출제할지문번호 = 수동출제할지문번호
        self.row_idx = row_idx
        self.유형 = 유형
        self.난이도 = 난이도
        self.passage_ids = passage_ids
        self.manual_mocktest_popup = manual_mocktest_popup
        self.검토창에서넘어옴 = 검토창에서넘어옴


        self.default_font = default_font
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        # Default values
        self.normal_default_min = "1"
        self.normal_default_max = "4"
        self.hard_default_min = "5"
        self.hard_default_max = "10"

        # Values (will be loaded from JSON or default)
        self.normal_min_val = self.normal_default_min
        self.normal_max_val = self.normal_default_max
        self.hard_min_val = self.hard_default_min
        self.hard_max_val = self.hard_default_max

        # Mode variable (1 or 2)
        self.빈칸추론_선지재진술_mode = tk.IntVar(value=1)

        # Passage transformation variables
        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)  # Default: 같은 난이도
        self.지문길이_var = tk.IntVar(value=2)  # Default: 비슷하게
        self.content_change_var = tk.IntVar(value=0)  # Default: 내용 변화 없음

        # Main frame
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)

        # Instruction Label
        intro_label = customtkinter.CTkLabel(
            self.main_frame,
            text="빈칸추론 세부 옵션을 설정합니다. (모든 문항에 적용됩니다)",
            font=(self.default_font, 12),
            text_color=("black", "white")
        )
        intro_label.pack(side='top', anchor='center', pady=(0, 10))

        # Frame for mode selection
        mode_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        mode_frame.pack(side='top', fill='x', expand=False, pady=(0, 10))

        mode_label = customtkinter.CTkLabel(
            mode_frame,
            text="정답 재진술:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        mode_label.pack(side='top', anchor='w', pady=(0,5))

        radio_container = customtkinter.CTkFrame(mode_frame, fg_color="transparent")
        radio_container.pack(side='top', fill='x', expand=False)

        self.radio_button_transformed = customtkinter.CTkRadioButton(
            radio_container,
            text='원문을 재진술하여 선지 제작',
            font=(self.default_font, 13),
            variable=self.빈칸추론_선지재진술_mode,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_button_transformed.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        self.radio_button_original = customtkinter.CTkRadioButton(
            radio_container,
            text='원문을 그대로 선지 제작',
            font=(self.default_font, 13),
            variable=self.빈칸추론_선지재진술_mode,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_button_original.grid(row=0, column=1, padx=(10, 10), pady=5, sticky="w")

        # Frame for length configurations
        length_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        length_frame.pack(side='top', fill='x', expand=False, pady=(0,10))

        self.option_length_label = customtkinter.CTkLabel(
            length_frame,
            text="선지 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.option_length_label.pack(side='top', anchor='w', pady=(0))

        # Create a frame using grid for both Normal and Hard settings
        config_frame = customtkinter.CTkFrame(length_frame, fg_color="transparent")
        config_frame.pack(side='top', fill='x', expand=False)

        # Configure columns for uniform resizing
        for col in [1, 3]:
            config_frame.grid_columnconfigure(col, weight=1)

        # Normal row
        normal_label = customtkinter.CTkLabel(
            config_frame,
            text="Normal 선지 길이:",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        normal_label.grid(row=0, column=0, padx=(0, 5), pady=5, sticky="e")

        self.length_entry1_normal = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry1_normal.grid(row=0, column=1, padx=(0, 5), pady=5, sticky="we")

        normal_tilde = customtkinter.CTkLabel(
            config_frame,
            text=" ~ ",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        normal_tilde.grid(row=0, column=2, padx=(5, 5), pady=5, sticky="we")

        self.length_entry2_normal = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry2_normal.grid(row=0, column=3, padx=(0, 5), pady=5, sticky="we")

        normal_unit = customtkinter.CTkLabel(
            config_frame,
            text="단어",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        normal_unit.grid(row=0, column=4, padx=(5, 5), pady=5, sticky="w")

        normal_default_btn = customtkinter.CTkButton(
            config_frame,
            text="기본값",
            font=(self.default_font, 12, 'bold'),
            width=40,
            height=25,
            fg_color="white",
            hover_color="#DDA15C",
            text_color="black",
            command=self.set_normal_defaults
        )
        normal_default_btn.grid(row=0, column=5, padx=5, pady=5, sticky="e")

        # Hard row
        hard_label = customtkinter.CTkLabel(
            config_frame,
            text="Hard 선지 길이:",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        hard_label.grid(row=1, column=0, padx=(0, 5), pady=5, sticky="e")

        self.length_entry1_hard = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry1_hard.grid(row=1, column=1, padx=(0, 5), pady=5, sticky="we")

        hard_tilde = customtkinter.CTkLabel(
            config_frame,
            text=" ~ ",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        hard_tilde.grid(row=1, column=2, padx=(5, 5), pady=5, sticky="we")

        self.length_entry2_hard = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry2_hard.grid(row=1, column=3, padx=(0, 5), pady=5, sticky="we")

        hard_unit = customtkinter.CTkLabel(
            config_frame,
            text="단어",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        hard_unit.grid(row=1, column=4, padx=(5, 5), pady=5, sticky="w")

        normal_default_hard = customtkinter.CTkButton(
            config_frame,
            text="기본값",
            font=(self.default_font, 12, 'bold'),
            width=40,
            height=25,
            fg_color="white",
            hover_color="#DDA15C",
            text_color="black",
            command=self.set_hard_defaults
        )
        normal_default_hard.grid(row=1, column=5, padx=5, pady=5, sticky="e")

        # Bind focus out events to validate right entries immediately
        self.length_entry2_normal.bind("<FocusOut>", self.validate_normal_range)
        self.length_entry2_hard.bind("<FocusOut>", self.validate_hard_range)

        # Passage transformation frame
        transform_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        transform_frame.pack(side='top', fill='x', expand=False, pady=(10, 0))

        # Checkbox
        self.transform_checkbox = customtkinter.CTkCheckBox(
            transform_frame,
            text="지문을 변형하여 출제",
            variable=self.지문변형_var,
            command=self.toggle_difficulty_options,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.transform_checkbox.pack(side='top', anchor='w', pady=(0, 5))

        # Difficulty options container (hidden by default)
        self.difficulty_container = customtkinter.CTkFrame(transform_frame, fg_color="transparent")

        # Label
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 난이도:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame
        radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        radio_frame.grid(row=0, column=1, sticky="w")

        self.radio_easier = customtkinter.CTkRadioButton(
            radio_frame,
            text='더 쉽게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))

        self.radio_same = customtkinter.CTkRadioButton(
            radio_frame,
            text='같은 난이도',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))

        self.radio_harder = customtkinter.CTkRadioButton(
            radio_frame,
            text='더 높게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')

        # Length label and radio buttons (row=1)
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for length
        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")

        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 짧게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))

        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='비슷하게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))

        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 길게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change mode label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for content change
        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='내용 변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "글의 요지는 유지하되, 세부사항에 변화를 줍니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 요지 자체를 바꿉니다", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "EBS 간접연계처럼 소재만 연계하여 새로운 글을 씁니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Load saved values from JSON
        self.load_values_from_json()

        # Initialize radio button states (after loading)
        self.toggle_difficulty_options()

        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10,0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        if not self.opened_from_dashboard and not self.검토창에서넘어옴:
            if 실모flag == True:
                수동출제버튼텍스트 = "빈칸 위치 수동출제\n(현재 문항)"
                수동출제버튼커맨드 = self.on_manual_placement실모
            else:
                수동출제버튼텍스트 = "빈칸 위치 수동출제"
                수동출제버튼커맨드 = self.on_manual_placement

            self.manual_button = customtkinter.CTkButton(
                action_frame,
                text=수동출제버튼텍스트,
                font=(self.default_font, 13, 'bold'),
                width=160,
                height=40,
                fg_color="#FEF9E0",
                hover_color="#DDA15C",
                text_color="black",
                command=수동출제버튼커맨드
            )
            self.manual_button.pack(side='left', padx=5, pady=(0, 5))

        self.confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        self.confirm_button.pack(side='right', padx=5, pady=(0, 5))

        # Populate entries with loaded or default values
        self.restore_current_values_to_entries()

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_manual_placement(self):

        popup = ManualQuestionPopup문제선택(
            parent=self.master,
            main_frame_ref=self.main_frame_ref,
            excel_file=self.excel_file,
            default_font=self.default_font,
            passage_ids=self.passage_ids,
            유형=self.유형,
            난이도=self.난이도,
        )
        self.on_confirm()
        popup.grab_set()


    def on_manual_placement실모(self):
        # Debug: Print the values of all required variables
        print("\non_manual_placement실모 called")
        print(f"main_frame_ref: {self.main_frame_ref}")
        print(f"실모flag: {self.실모flag}")
        print(f"row_idx: {self.row_idx}")
        print(f"수동출제할지문번호: {self.수동출제할지문번호}")

        # Open the manual placement popup with 실모flag = True
        if self.main_frame_ref is None or self.실모flag is None or self.row_idx is None or self.수동출제할지문번호 is None:
            messagebox.showerror("오류", "필요한 정보가 부족합니다.")
            return

        def save_callback(row_idx, 수동출제할지문번호, 유형, 난이도, edited_text):
            # Called by popup after user hits '확인'
            self.main_frame_ref.save_manual_placement_text실모(row_idx, 수동출제할지문번호, 유형, 난이도, edited_text)
            passageid유형난이도합본 = 수동출제할지문번호 + " // " + 유형 + "_" + 난이도
            self.manual_mocktest_popup.update_current_status_label수동실모(None, passageid유형난이도합본) #전체
            #self.manual_mocktest_popup.update_current_status_label수동실모(row_idx, passageid유형난이도합본) #하나만

        popup = ManualPlacementPopup(
            parent=self.master,
            default_font=self.default_font,
            excel_file=self.excel_file, 
            row_idx=self.row_idx,
            수동출제할지문번호=self.수동출제할지문번호,
            유형=self.유형,
            난이도=self.난이도,
            save_callback=save_callback,
            manual_edited_texts=self.main_frame_ref.manual_edited_texts,
            일반or실모="실모",
            manual_mocktest_popup=self.manual_mocktest_popup,
        )
        self.on_confirm()
        popup.grab_set()



    def on_confirm(self):
        # Validate entries on confirm as well
        normal_valid = self.validate_entries(self.length_entry1_normal, self.length_entry2_normal)
        hard_valid = self.validate_entries(self.length_entry1_hard, self.length_entry2_hard)

        # If validation fails for either Normal or Hard, do not close or save
        if not normal_valid or not hard_valid:
            return

        # If validation passes, proceed
        normal_min_val = self.length_entry1_normal.get().strip()
        normal_max_val = self.length_entry2_normal.get().strip()
        hard_min_val = self.length_entry1_hard.get().strip()
        hard_max_val = self.length_entry2_hard.get().strip()

        # Save to JSON, including mode
        self.save_values_to_json(
            normal_min_val=normal_min_val,
            normal_max_val=normal_max_val,
            hard_min_val=hard_min_val,
            hard_max_val=hard_max_val,
            mode=self.빈칸추론_선지재진술_mode.get()
        )

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def validate_entries(self, left_entry, right_entry):
        return self.check_and_fix_range(left_entry, right_entry, show_warning=True)

    def validate_normal_range(self, event=None):
        # Validate immediately after focus leaves the Normal right entry
        self.check_and_fix_range(self.length_entry1_normal, self.length_entry2_normal, show_warning=True)

    def validate_hard_range(self, event=None):
        # Validate immediately after focus leaves the Hard right entry
        self.check_and_fix_range(self.length_entry1_hard, self.length_entry2_hard, show_warning=True)

    def check_and_fix_range(self, left_entry, right_entry, show_warning=False):
        left_val = left_entry.get().strip()
        right_val = right_entry.get().strip()

        # Ensure they are integers
        try:
            left_num = int(left_val)
            right_num = int(right_val)
        except ValueError:
            if show_warning:
                messagebox.showwarning("경고", "숫자를 입력해주세요.")
            return False

        if right_num < left_num:
            if show_warning:
                messagebox.showwarning("경고", f"우측 값이 좌측 값보다 작습니다. 우측 값을 {left_num}으로 설정합니다.")
            right_entry.delete(0, tk.END)
            right_entry.insert(0, str(left_num))
            return False

        return True

    def set_normal_defaults(self):
        self.normal_min_val = self.normal_default_min
        self.normal_max_val = self.normal_default_max
        self.restore_current_values_to_entries()

    def set_hard_defaults(self):
        self.hard_min_val = self.hard_default_min
        self.hard_max_val = self.hard_default_max
        self.restore_current_values_to_entries()

    def restore_current_values_to_entries(self):
        # Set Normal entries
        self.length_entry1_normal.delete(0, tk.END)
        self.length_entry1_normal.insert(0, self.normal_min_val)
        self.length_entry2_normal.delete(0, tk.END)
        self.length_entry2_normal.insert(0, self.normal_max_val)

        # Set Hard entries
        self.length_entry1_hard.delete(0, tk.END)
        self.length_entry1_hard.insert(0, self.hard_min_val)
        self.length_entry2_hard.delete(0, tk.END)
        self.length_entry2_hard.insert(0, self.hard_max_val)

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.normal_min_val = data.get("빈칸추론normal_min_val", self.normal_default_min)
                    self.normal_max_val = data.get("빈칸추론normal_max_val", self.normal_default_max)
                    self.hard_min_val = data.get("빈칸추론hard_min_val", self.hard_default_min)
                    self.hard_max_val = data.get("빈칸추론hard_max_val", self.hard_default_max)
                    # Load mode if available
                    saved_mode = data.get("빈칸추론mode", 1)
                    self.빈칸추론_선지재진술_mode.set(saved_mode)
                    # Load transformation settings
                    paraphrase_enabled = data.get("빈칸추론paraphrase_enabled", False)
                    difficulty_level = data.get("빈칸추론difficulty_level", 2)
                    length_level = data.get("빈칸추론length_level", 2)
                    self.지문변형_var.set(paraphrase_enabled)
                    self.지문난이도_var.set(difficulty_level)
                    self.지문길이_var.set(length_level)
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("빈칸추론content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except:
                # If there's an error reading the file, fallback to defaults
                self.normal_min_val = self.normal_default_min
                self.normal_max_val = self.normal_default_max
                self.hard_min_val = self.hard_default_min
                self.hard_max_val = self.hard_default_max
                self.빈칸추론_선지재진술_mode.set(1)
                self.지문변형_var.set(False)
                self.지문난이도_var.set(2)
                self.지문길이_var.set(2)
        else:
            # No file, use defaults
            self.normal_min_val = self.normal_default_min
            self.normal_max_val = self.normal_default_max
            self.hard_min_val = self.hard_default_min
            self.hard_max_val = self.hard_default_max
            self.빈칸추론_선지재진술_mode.set(1)
            self.지문변형_var.set(False)
            self.지문난이도_var.set(2)
            self.지문길이_var.set(2)

    def save_values_to_json(self, normal_min_val, normal_max_val, hard_min_val, hard_max_val, mode=0):
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        # Load existing data to preserve other question types' settings
        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        # Update with current values
        existing_data["빈칸추론normal_min_val"] = normal_min_val
        existing_data["빈칸추론normal_max_val"] = normal_max_val
        existing_data["빈칸추론hard_min_val"] = hard_min_val
        existing_data["빈칸추론hard_max_val"] = hard_max_val
        existing_data["빈칸추론mode"] = mode
        existing_data["빈칸추론paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["빈칸추론difficulty_level"] = self.지문난이도_var.get()
        existing_data["빈칸추론length_level"] = self.지문길이_var.get()
        # Save content_change_mode (None when checkbox unchecked, actual value when checked)
        existing_data["빈칸추론content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)
        self.content_change_var.set(0)

        # Reset mode
        self.빈칸추론_선지재진술_mode.set(1)

        # Reset entry values to defaults
        self.normal_min_val = self.normal_default_min
        self.normal_max_val = self.normal_default_max
        self.hard_min_val = self.hard_default_min
        self.hard_max_val = self.hard_default_max

        # Update UI
        self.restore_current_values_to_entries()

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update radio button states
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")





class QuestionOptions함축의미(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, 실모flag=None, 수동출제할지문번호=None, row_idx=None, 유형=None, 난이도=None, passage_ids=None, manual_mocktest_popup=None, options_file_path=None):
        super().__init__(parent)
        self.title('함축의미 옵션')
        self.geometry('650x250')
        self.minsize(650, 250)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame
        self.excel_file = excel_file
        self.실모flag = 실모flag
        self.수동출제할지문번호 = 수동출제할지문번호

        self.row_idx = row_idx
        self.유형 = 유형
        self.난이도 = 난이도
        self.passage_ids = passage_ids
        self.manual_mocktest_popup = manual_mocktest_popup

        # Passage transformation variables
        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)  # Default: 같은 난이도
        self.지문길이_var = tk.IntVar(value=2)  # Default: 비슷하게
        self.content_change_var = tk.IntVar(value=0)  # Default: 내용 변화 없음

        self.default_font = default_font
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        # Main frame
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)

        # Passage transformation frame
        transform_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        transform_frame.pack(side='top', fill='x', expand=False, pady=(10, 0))

        # Checkbox
        self.transform_checkbox = customtkinter.CTkCheckBox(
            transform_frame,
            text="지문을 변형하여 출제",
            variable=self.지문변형_var,
            command=self.toggle_difficulty_options,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.transform_checkbox.pack(side='top', anchor='w', pady=(0, 5))

        # Difficulty and length options container (hidden by default)
        self.difficulty_container = customtkinter.CTkFrame(transform_frame, fg_color="transparent")

        # Configure grid columns
        self.difficulty_container.grid_columnconfigure(0, weight=0)  # Label column
        self.difficulty_container.grid_columnconfigure(1, weight=1)  # Radio buttons column

        # Difficulty label and radio buttons (row=0)
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 난이도:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for difficulty
        difficulty_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_radio_frame.grid(row=0, column=1, sticky="w")

        self.radio_easier = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='더 쉽게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))

        self.radio_same = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='같은 난이도',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))

        self.radio_harder = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='더 높게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')

        # Length label and radio buttons (row=1)
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for length
        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")

        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 짧게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))

        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='비슷하게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))

        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 길게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change mode label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for content change
        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='내용 변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "글의 요지는 유지하되, 세부사항에 변화를 줍니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 요지 자체를 바꿉니다", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "EBS 간접연계처럼 소재만 연계하여 새로운 글을 씁니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Initialize radio button states
        self.toggle_difficulty_options()

        # Load saved values
        self.load_values_from_json()

        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10, 0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=100,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Manual placement button (middle)
        if not self.opened_from_dashboard:
            if 실모flag == True:
                수동출제버튼텍스트 = "밑줄 위치 수동출제\n(현재 문항)"
                수동출제버튼커맨드 = self.on_manual_placement실모
            else:
                수동출제버튼텍스트 = "밑줄 위치 수동출제"
                수동출제버튼커맨드 = self.on_manual_placement

            self.manual_button = customtkinter.CTkButton(
                action_frame,
                text=수동출제버튼텍스트,
                font=(self.default_font, 13, 'bold'),
                width=160,
                height=40,
                fg_color="#FEF9E0",
                hover_color="#DDA15C",
                text_color="black",
                command=수동출제버튼커맨드
            )
            self.manual_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=100,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        confirm_button.pack(side='right', padx=5, pady=(0, 5))

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)

        # Show/hide difficulty options based on loaded checkbox state
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)


    def on_manual_placement(self):
        popup = ManualQuestionPopup문제선택(
            parent=self.master,
            main_frame_ref=self.main_frame_ref,
            excel_file=self.excel_file,
            default_font=self.default_font,
            passage_ids=self.passage_ids,
            유형=self.유형,
            난이도=self.난이도,
        )
        self.destroy()

        popup.grab_set()


    def on_manual_placement실모(self):
        # Open the manual placement popup with 실모flag = True
        if self.main_frame_ref is None or self.실모flag is None or self.row_idx is None or self.수동출제할지문번호 is None:
            messagebox.showerror("오류", "필요한 정보가 부족합니다.")
            return

        def save_callback(row_idx, 수동출제할지문번호, 유형, 난이도, edited_text):
            # Called by popup after user hits '확인'
            self.main_frame_ref.save_manual_placement_text실모(row_idx, 수동출제할지문번호, 유형, 난이도, edited_text)
            passageid유형난이도합본 = 수동출제할지문번호 + " // " + 유형 + "_" + 난이도
            self.manual_mocktest_popup.update_current_status_label수동실모(None, passageid유형난이도합본) #전체

        popup = ManualPlacementPopup(
            parent=self.master,
            default_font=self.default_font,
            excel_file=self.excel_file, 
            row_idx=self.row_idx,
            수동출제할지문번호=self.수동출제할지문번호,
            유형=self.유형,
            난이도=self.난이도,
            save_callback=save_callback,
            manual_edited_texts=self.main_frame_ref.manual_edited_texts,
            일반or실모="실모",
            manual_mocktest_popup=self.manual_mocktest_popup,
        )
        self.destroy()

        popup.grab_set()

    def on_confirm(self):
        """Save options and update button color"""
        self.save_values_to_json()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update UI state
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def load_values_from_json(self):
        """Load saved option values from JSON"""
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.지문변형_var.set(data.get("함축의미paraphrase_enabled", False))
                    self.지문난이도_var.set(data.get("함축의미difficulty_level", 2))
                    self.지문길이_var.set(data.get("함축의미length_level", 2))
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("함축의미content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except:
                pass

    def save_values_to_json(self):
        """Save current option values to JSON"""
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        existing_data["함축의미paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["함축의미difficulty_level"] = self.지문난이도_var.get()
        existing_data["함축의미length_level"] = self.지문길이_var.get()
        # Save content_change_mode (None when checkbox unchecked, actual value when checked)
        existing_data["함축의미content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)









class QuestionOptions내용일치(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", main_frame=None, manual_mocktest_popup=None, options_file_path=None):
        super().__init__(parent)
        self.title('내용일치 옵션')
        self.geometry('650x500')
        self.minsize(650, 500)

        self.default_font = default_font

        # Store reference to main frame and question type
        self.main_frame_ref = main_frame
        self.manual_mocktest_popup = manual_mocktest_popup
        self.유형 = "내용일치"

        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        # Default values
        self.normal_default_min = "10"
        self.normal_default_max = "20"
        self.hard_default_min = "15"
        self.hard_default_max = "25"

        # Values (will be loaded from JSON or default)
        self.normal_min_val = self.normal_default_min
        self.normal_max_val = self.normal_default_max
        self.hard_min_val = self.hard_default_min
        self.hard_max_val = self.hard_default_max

        # Mode variable (0-4: 0=랜덤, 1=1개, 2=2개, 3=3개, 4=4개)
        self.mode = tk.IntVar(value=0)

        # Passage transformation variables
        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)  # Default: 같은 난이도
        self.지문길이_var = tk.IntVar(value=2)  # Default: 비슷하게
        self.content_change_var = tk.IntVar(value=0)  # Default: 내용 변화 없음

        # Attempt to load saved values
        self.load_values_from_json()

        # Main frame
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)








        # Instruction Label
        intro_label = customtkinter.CTkLabel(
            self.main_frame,
            text="내용일치 세부 옵션을 설정합니다. (모든 문항에 적용됩니다)",
            font=(self.default_font, 12),
            text_color=("black", "white")
        )
        intro_label.pack(side='top', anchor='center', pady=(0, 10))

        # Mode selection frame (정답 개수)
        mode_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        mode_frame.pack(side='top', fill='x', expand=False, pady=(0, 10))

        mode_label = customtkinter.CTkLabel(
            mode_frame,
            text="정답(일치하는 선지) 개수:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        mode_label.pack(side='top', anchor='w', pady=(0, 5))

        # Radio buttons frame
        mode_radio_frame = customtkinter.CTkFrame(mode_frame, fg_color="transparent")
        mode_radio_frame.pack(side='top', fill='x', expand=False)

        self.radio_mode_random = customtkinter.CTkRadioButton(
            mode_radio_frame,
            text='랜덤(1~4개)',
            font=(self.default_font, 13),
            variable=self.mode,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C",
            border_color="gray"
        )
        self.radio_mode_random.pack(side='left', padx=(0, 10))

        self.radio_mode_1 = customtkinter.CTkRadioButton(
            mode_radio_frame,
            text='1개',
            font=(self.default_font, 13),
            variable=self.mode,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C",
            border_color="gray"
        )
        self.radio_mode_1.pack(side='left', padx=(0, 10))

        self.radio_mode_2 = customtkinter.CTkRadioButton(
            mode_radio_frame,
            text='2개',
            font=(self.default_font, 13),
            variable=self.mode,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C",
            border_color="gray"
        )
        self.radio_mode_2.pack(side='left', padx=(0, 10))

        self.radio_mode_3 = customtkinter.CTkRadioButton(
            mode_radio_frame,
            text='3개',
            font=(self.default_font, 13),
            variable=self.mode,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C",
            border_color="gray"
        )
        self.radio_mode_3.pack(side='left', padx=(0, 10))

        self.radio_mode_4 = customtkinter.CTkRadioButton(
            mode_radio_frame,
            text='4개(내용 불일치 문제)',
            font=(self.default_font, 13),
            variable=self.mode,
            value=4,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C",
            border_color="gray"
        )
        self.radio_mode_4.pack(side='left')

        # Informational note
        mode_note = customtkinter.CTkLabel(
            mode_frame,
            text="*문제는 T/F 형식으로 출제되나, 편집본 추출시 'Export Question' -> '편집 옵션' -> '문제 옵션'에서 5지선다 형식으로 변경할 수 있습니다.",
            font=(self.default_font, 11),
            text_color=("gray", "lightgray"),
            wraplength=600,
            justify="left"
        )
        mode_note.pack(side='top', anchor='w', pady=(5, 0))

        # Frame for length configurations
        length_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        length_frame.pack(side='top', fill='x', expand=False, pady=(0,10))

        self.option_length_label = customtkinter.CTkLabel(
            length_frame,
            text="선지 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.option_length_label.pack(side='top', anchor='w', pady=(0))

        # Create a frame using grid for both Normal and Hard settings
        config_frame = customtkinter.CTkFrame(length_frame, fg_color="transparent")
        config_frame.pack(side='top', fill='x', expand=False)

        # Configure columns for uniform resizing
        for col in [1, 3]:
            config_frame.grid_columnconfigure(col, weight=1)

        # Normal row
        normal_label = customtkinter.CTkLabel(
            config_frame,
            text="Normal 선지 길이:",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        normal_label.grid(row=0, column=0, padx=(0, 5), pady=5, sticky="e")

        self.length_entry1_normal = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry1_normal.grid(row=0, column=1, padx=(0, 5), pady=5, sticky="we")

        normal_tilde = customtkinter.CTkLabel(
            config_frame,
            text=" ~ ",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        normal_tilde.grid(row=0, column=2, padx=(5, 5), pady=5, sticky="we")

        self.length_entry2_normal = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry2_normal.grid(row=0, column=3, padx=(0, 5), pady=5, sticky="we")

        normal_unit = customtkinter.CTkLabel(
            config_frame,
            text="단어",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        normal_unit.grid(row=0, column=4, padx=(5, 5), pady=5, sticky="w")

        normal_default_btn = customtkinter.CTkButton(
            config_frame,
            text="기본값",
            font=(self.default_font, 12, 'bold'),
            width=40,
            height=25,
            fg_color="white",
            hover_color="#DDA15C",
            text_color="black",
            command=self.set_normal_defaults
        )
        normal_default_btn.grid(row=0, column=5, padx=5, pady=5, sticky="e")

        # Hard row
        hard_label = customtkinter.CTkLabel(
            config_frame,
            text="Hard 선지 길이:",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        hard_label.grid(row=1, column=0, padx=(0, 5), pady=5, sticky="e")

        self.length_entry1_hard = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry1_hard.grid(row=1, column=1, padx=(0, 5), pady=5, sticky="we")

        hard_tilde = customtkinter.CTkLabel(
            config_frame,
            text=" ~ ",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        hard_tilde.grid(row=1, column=2, padx=(5, 5), pady=5, sticky="we")

        self.length_entry2_hard = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry2_hard.grid(row=1, column=3, padx=(0, 5), pady=5, sticky="we")

        hard_unit = customtkinter.CTkLabel(
            config_frame,
            text="단어",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        hard_unit.grid(row=1, column=4, padx=(5, 5), pady=5, sticky="w")

        normal_default_hard = customtkinter.CTkButton(
            config_frame,
            text="기본값",
            font=(self.default_font, 12, 'bold'),
            width=40,
            height=25,
            fg_color="white",
            hover_color="#DDA15C",
            text_color="black",
            command=self.set_hard_defaults
        )
        normal_default_hard.grid(row=1, column=5, padx=5, pady=5, sticky="e")

        # Bind focus out events to validate right entries immediately
        self.length_entry2_normal.bind("<FocusOut>", self.validate_normal_range)
        self.length_entry2_hard.bind("<FocusOut>", self.validate_hard_range)







        # Passage transformation checkbox
        self.지문변형_checkbox = customtkinter.CTkCheckBox(
            self.main_frame,
            text="지문을 변형하여 출제",
            variable=self.지문변형_var,
            command=self.on_transform_toggle,
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25",
            checkbox_width=20,
            checkbox_height=20
        )
        self.지문변형_checkbox.pack(pady=(5, 5), anchor='w')

        # Difficulty and length options container (initially hidden)
        self.difficulty_container = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")

        # Configure grid columns
        self.difficulty_container.grid_columnconfigure(0, weight=0)  # Label column
        self.difficulty_container.grid_columnconfigure(1, weight=1)  # Radio buttons column

        # Difficulty label and radio buttons (row=0)
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 난이도:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for difficulty
        difficulty_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_radio_frame.grid(row=0, column=1, sticky="w")

        self.radio_easier = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='더 쉽게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))

        self.radio_same = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='같은 난이도',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))

        self.radio_harder = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='더 높게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')

        # Length label and radio buttons (row=1)
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for length
        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")

        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 짧게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))

        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='비슷하게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))

        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 길게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for content change mode
        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "글의 요지는 유지하되, 세부 내용(예시, 통계 등)을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 주제는 유지하되, 요지(주장/결론)를 변경합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "원문의 소재만 활용하여 전혀 다른 내용의 지문을 생성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))







        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10,0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        self.confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        self.confirm_button.pack(side='right', padx=5, pady=(0, 5))

        # Populate entries with loaded or default values
        self.restore_current_values_to_entries()

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)

        # Show/hide difficulty options based on loaded checkbox state
        self.on_transform_toggle()

    def on_transform_toggle(self):
        """Enable/disable difficulty and length options based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        print(f"   Paraphrase enabled: {is_enabled}")
        print(f"   UI state: {state}")
        print(f"   Difficulty level: {self.지문난이도_var.get()}")
        print(f"   Length level: {self.지문길이_var.get()}")
        print(f"   Content change mode: {self.content_change_var.get()}")

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def on_confirm(self):

        # Validate entries on confirm as well
        normal_valid = self.validate_entries(self.length_entry1_normal, self.length_entry2_normal)
        hard_valid = self.validate_entries(self.length_entry1_hard, self.length_entry2_hard)

        # If validation fails for either Normal or Hard, do not close or save
        if not normal_valid or not hard_valid:
            return

        # If validation passes, proceed
        normal_min_val = self.length_entry1_normal.get().strip()
        normal_max_val = self.length_entry2_normal.get().strip()
        hard_min_val = self.length_entry1_hard.get().strip()
        hard_max_val = self.length_entry2_hard.get().strip()
        mode = self.mode.get()

        # Save to JSON, including mode
        self.save_values_to_json(
            normal_min_val=normal_min_val,
            normal_max_val=normal_max_val,
            hard_min_val=hard_min_val,
            hard_max_val=hard_max_val,
            mode=mode
        )

        # Update the option button color in real-time
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()

        self.destroy()

    def validate_entries(self, left_entry, right_entry):
        return self.check_and_fix_range(left_entry, right_entry, show_warning=True)

    def validate_normal_range(self, event=None):
        # Validate immediately after focus leaves the Normal right entry
        self.check_and_fix_range(self.length_entry1_normal, self.length_entry2_normal, show_warning=True)

    def validate_hard_range(self, event=None):
        # Validate immediately after focus leaves the Hard right entry
        self.check_and_fix_range(self.length_entry1_hard, self.length_entry2_hard, show_warning=True)

    def check_and_fix_range(self, left_entry, right_entry, show_warning=False):
        left_val = left_entry.get().strip()
        right_val = right_entry.get().strip()

        # Ensure they are integers
        try:
            left_num = int(left_val)
            right_num = int(right_val)
        except ValueError:
            if show_warning:
                messagebox.showwarning("경고", "숫자를 입력해주세요.")
            return False

        if right_num < left_num:
            if show_warning:
                messagebox.showwarning("경고", f"우측 값이 좌측 값보다 작습니다. 우측 값을 {left_num}으로 설정합니다.")
            right_entry.delete(0, tk.END)
            right_entry.insert(0, str(left_num))
            return False

        return True

    def set_normal_defaults(self):
        self.normal_min_val = self.normal_default_min
        self.normal_max_val = self.normal_default_max
        self.restore_current_values_to_entries()

    def set_hard_defaults(self):
        self.hard_min_val = self.hard_default_min
        self.hard_max_val = self.hard_default_max
        self.restore_current_values_to_entries()

    def restore_current_values_to_entries(self):
        # Set Normal entries
        self.length_entry1_normal.delete(0, tk.END)
        self.length_entry1_normal.insert(0, self.normal_min_val)
        self.length_entry2_normal.delete(0, tk.END)
        self.length_entry2_normal.insert(0, self.normal_max_val)

        # Set Hard entries
        self.length_entry1_hard.delete(0, tk.END)
        self.length_entry1_hard.insert(0, self.hard_min_val)
        self.length_entry2_hard.delete(0, tk.END)
        self.length_entry2_hard.insert(0, self.hard_max_val)

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.normal_min_val = data.get("내용일치normal_min_val", self.normal_default_min)
                    self.normal_max_val = data.get("내용일치normal_max_val", self.normal_default_max)
                    self.hard_min_val = data.get("내용일치hard_min_val", self.hard_default_min)
                    self.hard_max_val = data.get("내용일치hard_max_val", self.hard_default_max)
                    saved_mode = data.get("내용일치mode", 0)
                    self.mode.set(saved_mode)
                    # Load transformation settings
                    paraphrase_enabled = data.get("내용일치paraphrase_enabled", False)
                    difficulty_level = data.get("내용일치difficulty_level", 2)
                    length_level = data.get("내용일치length_level", 2)
                    self.지문변형_var.set(paraphrase_enabled)
                    self.지문난이도_var.set(difficulty_level)
                    self.지문길이_var.set(length_level)
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("내용일치content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except Exception as e:
                # If there's an error reading the file, fallback to defaults
                self.normal_min_val = self.normal_default_min
                self.normal_max_val = self.normal_default_max
                self.hard_min_val = self.hard_default_min
                self.hard_max_val = self.hard_default_max
                self.mode.set(0)
        else:
            # No file, use defaults
            self.normal_min_val = self.normal_default_min
            self.normal_max_val = self.normal_default_max
            self.hard_min_val = self.hard_default_min
            self.hard_max_val = self.hard_default_max
            self.mode.set(0)

    def save_values_to_json(self, normal_min_val, normal_max_val, hard_min_val, hard_max_val, mode=0):
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        # Load existing data if any
        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        # Get current transformation values
        paraphrase_enabled = self.지문변형_var.get()
        difficulty_level = self.지문난이도_var.get()
        length_level = self.지문길이_var.get()
        content_change_mode = self.content_change_var.get()

        # Update data with new values
        existing_data["내용일치normal_min_val"] = normal_min_val
        existing_data["내용일치normal_max_val"] = normal_max_val
        existing_data["내용일치hard_min_val"] = hard_min_val
        existing_data["내용일치hard_max_val"] = hard_max_val
        existing_data["내용일치mode"] = mode
        existing_data["내용일치paraphrase_enabled"] = paraphrase_enabled
        existing_data["내용일치difficulty_level"] = difficulty_level
        existing_data["내용일치length_level"] = length_level
        existing_data["내용일치content_change_mode"] = content_change_mode

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)

    def reset_to_defaults(self):
        """Reset all options to default values"""

        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)
        self.content_change_var.set(0)

        # Reset mode
        self.mode.set(0)

        # Reset entry values to defaults
        self.normal_min_val = self.normal_default_min
        self.normal_max_val = self.normal_default_max
        self.hard_min_val = self.hard_default_min
        self.hard_max_val = self.hard_default_max

        # Update UI
        self.restore_current_values_to_entries()

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update radio button states
        self.on_transform_toggle()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")







class QuestionOptions내용일치한(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", main_frame=None, manual_mocktest_popup=None, options_file_path=None):
        super().__init__(parent)
        self.title('내용일치(한) 옵션')
        self.geometry('650x500')
        self.minsize(650, 500)

        self.default_font = default_font

        # Store reference to main frame and question type
        self.manual_mocktest_popup = manual_mocktest_popup
        self.main_frame_ref = main_frame
        self.유형 = "내용일치(한)"

        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        # Default values
        self.normal_default_min = "10"
        self.normal_default_max = "20"
        self.hard_default_min = "15"
        self.hard_default_max = "25"

        # Values (will be loaded from JSON or default)
        self.normal_min_val = self.normal_default_min
        self.normal_max_val = self.normal_default_max
        self.hard_min_val = self.hard_default_min
        self.hard_max_val = self.hard_default_max

        # Mode variable (0-4: 0=랜덤, 1=1개, 2=2개, 3=3개, 4=4개)
        self.mode = tk.IntVar(value=0)

        # Passage transformation variables
        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)  # Default: 같은 난이도
        self.지문길이_var = tk.IntVar(value=2)  # Default: 비슷하게
        self.content_change_var = tk.IntVar(value=0)  # Default: 내용 변화 없음

        # Attempt to load saved values
        self.load_values_from_json()

        # Main frame
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)

        # Instruction Label
        intro_label = customtkinter.CTkLabel(
            self.main_frame,
            text="내용일치(한) 세부 옵션을 설정합니다. (모든 문항에 적용됩니다)",
            font=(self.default_font, 12),
            text_color=("black", "white")
        )
        intro_label.pack(side='top', anchor='center', pady=(0, 10))

        # Mode selection frame (정답 개수)
        mode_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        mode_frame.pack(side='top', fill='x', expand=False, pady=(0, 10))

        mode_label = customtkinter.CTkLabel(
            mode_frame,
            text="정답(일치하는 선지) 개수:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        mode_label.pack(side='top', anchor='w', pady=(0, 5))

        # Radio buttons frame
        mode_radio_frame = customtkinter.CTkFrame(mode_frame, fg_color="transparent")
        mode_radio_frame.pack(side='top', fill='x', expand=False)

        self.radio_mode_random = customtkinter.CTkRadioButton(
            mode_radio_frame,
            text='랜덤(1~4개)',
            font=(self.default_font, 13),
            variable=self.mode,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C",
            border_color="gray"
        )
        self.radio_mode_random.pack(side='left', padx=(0, 10))

        self.radio_mode_1 = customtkinter.CTkRadioButton(
            mode_radio_frame,
            text='1개',
            font=(self.default_font, 13),
            variable=self.mode,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C",
            border_color="gray"
        )
        self.radio_mode_1.pack(side='left', padx=(0, 10))

        self.radio_mode_2 = customtkinter.CTkRadioButton(
            mode_radio_frame,
            text='2개',
            font=(self.default_font, 13),
            variable=self.mode,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C",
            border_color="gray"
        )
        self.radio_mode_2.pack(side='left', padx=(0, 10))

        self.radio_mode_3 = customtkinter.CTkRadioButton(
            mode_radio_frame,
            text='3개',
            font=(self.default_font, 13),
            variable=self.mode,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C",
            border_color="gray"
        )
        self.radio_mode_3.pack(side='left', padx=(0, 10))

        self.radio_mode_4 = customtkinter.CTkRadioButton(
            mode_radio_frame,
            text='4개(내용 불일치 문제)',
            font=(self.default_font, 13),
            variable=self.mode,
            value=4,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C",
            border_color="gray"
        )
        self.radio_mode_4.pack(side='left')

        # Informational note
        mode_note = customtkinter.CTkLabel(
            mode_frame,
            text="*문제는 T/F 형식으로 출제되나, 편집본 추출시 'Export Question' -> '편집 옵션' -> '문제 옵션'에서 5지선다 형식으로 변경할 수 있습니다.",
            font=(self.default_font, 11),
            text_color=("gray", "lightgray"),
            wraplength=600,
            justify="left"
        )
        mode_note.pack(side='top', anchor='w', pady=(5, 0))

        # Passage transformation checkbox
        self.지문변형_checkbox = customtkinter.CTkCheckBox(
            self.main_frame,
            text="지문을 변형하여 출제",
            variable=self.지문변형_var,
            command=self.on_transform_toggle,
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25",
            checkbox_width=20,
            checkbox_height=20
        )
        self.지문변형_checkbox.pack(pady=(5, 5), anchor='w')

        # Difficulty and length options container (initially hidden)
        self.difficulty_container = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")

        # Configure grid columns
        self.difficulty_container.grid_columnconfigure(0, weight=0)  # Label column
        self.difficulty_container.grid_columnconfigure(1, weight=1)  # Radio buttons column

        # Difficulty label and radio buttons (row=0)
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 난이도:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for difficulty
        difficulty_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_radio_frame.grid(row=0, column=1, sticky="w")

        self.radio_easier = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='더 쉽게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))

        self.radio_same = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='같은 난이도',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))

        self.radio_harder = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='더 높게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')

        # Length label and radio buttons (row=1)
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for length
        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")

        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 짧게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))

        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='비슷하게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))

        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 길게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for content change mode
        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "글의 요지는 유지하되, 세부 내용(예시, 통계 등)을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 주제는 유지하되, 요지(주장/결론)를 변경합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "원문의 소재만 활용하여 전혀 다른 내용의 지문을 생성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))





        # Frame for length configurations
        length_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        length_frame.pack(side='top', fill='x', expand=False, pady=(0,10))

        self.option_length_label = customtkinter.CTkLabel(
            length_frame,
            text="선지 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.option_length_label.pack(side='top', anchor='w', pady=(0))

        # Create a frame using grid for both Normal and Hard settings
        config_frame = customtkinter.CTkFrame(length_frame, fg_color="transparent")
        config_frame.pack(side='top', fill='x', expand=False)

        # Configure columns for uniform resizing
        for col in [1, 3]:
            config_frame.grid_columnconfigure(col, weight=1)

        # Normal row
        normal_label = customtkinter.CTkLabel(
            config_frame,
            text="Normal 선지 길이:",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        normal_label.grid(row=0, column=0, padx=(0, 5), pady=5, sticky="e")

        self.length_entry1_normal = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry1_normal.grid(row=0, column=1, padx=(0, 5), pady=5, sticky="we")

        normal_tilde = customtkinter.CTkLabel(
            config_frame,
            text=" ~ ",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        normal_tilde.grid(row=0, column=2, padx=(5, 5), pady=5, sticky="we")

        self.length_entry2_normal = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry2_normal.grid(row=0, column=3, padx=(0, 5), pady=5, sticky="we")

        normal_unit = customtkinter.CTkLabel(
            config_frame,
            text="단어",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        normal_unit.grid(row=0, column=4, padx=(5, 5), pady=5, sticky="w")

        normal_default_btn = customtkinter.CTkButton(
            config_frame,
            text="기본값",
            font=(self.default_font, 12, 'bold'),
            width=40,
            height=25,
            fg_color="white",
            hover_color="#DDA15C",
            text_color="black",
            command=self.set_normal_defaults
        )
        normal_default_btn.grid(row=0, column=5, padx=5, pady=5, sticky="e")

        # Hard row
        hard_label = customtkinter.CTkLabel(
            config_frame,
            text="Hard 선지 길이:",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        hard_label.grid(row=1, column=0, padx=(0, 5), pady=5, sticky="e")

        self.length_entry1_hard = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry1_hard.grid(row=1, column=1, padx=(0, 5), pady=5, sticky="we")

        hard_tilde = customtkinter.CTkLabel(
            config_frame,
            text=" ~ ",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        hard_tilde.grid(row=1, column=2, padx=(5, 5), pady=5, sticky="we")

        self.length_entry2_hard = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry2_hard.grid(row=1, column=3, padx=(0, 5), pady=5, sticky="we")

        hard_unit = customtkinter.CTkLabel(
            config_frame,
            text="단어",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        hard_unit.grid(row=1, column=4, padx=(5, 5), pady=5, sticky="w")

        normal_default_hard = customtkinter.CTkButton(
            config_frame,
            text="기본값",
            font=(self.default_font, 12, 'bold'),
            width=40,
            height=25,
            fg_color="white",
            hover_color="#DDA15C",
            text_color="black",
            command=self.set_hard_defaults
        )
        normal_default_hard.grid(row=1, column=5, padx=5, pady=5, sticky="e")

        # Bind focus out events to validate right entries immediately
        self.length_entry2_normal.bind("<FocusOut>", self.validate_normal_range)
        self.length_entry2_hard.bind("<FocusOut>", self.validate_hard_range)

        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10,0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        self.confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        self.confirm_button.pack(side='right', padx=5, pady=(0, 5))

        # Populate entries with loaded or default values
        self.restore_current_values_to_entries()

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)

        # Show/hide difficulty options based on loaded checkbox state
        self.on_transform_toggle()

    def on_transform_toggle(self):
        """Enable/disable difficulty and length options based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        print(f"   Paraphrase enabled: {is_enabled}")
        print(f"   UI state: {state}")
        print(f"   Difficulty level: {self.지문난이도_var.get()}")
        print(f"   Length level: {self.지문길이_var.get()}")
        print(f"   Content change mode: {self.content_change_var.get()}")

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def on_confirm(self):

        # Validate entries on confirm as well
        normal_valid = self.validate_entries(self.length_entry1_normal, self.length_entry2_normal)
        hard_valid = self.validate_entries(self.length_entry1_hard, self.length_entry2_hard)

        # If validation fails for either Normal or Hard, do not close or save
        if not normal_valid or not hard_valid:
            return

        # If validation passes, proceed
        normal_min_val = self.length_entry1_normal.get().strip()
        normal_max_val = self.length_entry2_normal.get().strip()
        hard_min_val = self.length_entry1_hard.get().strip()
        hard_max_val = self.length_entry2_hard.get().strip()
        mode = self.mode.get()

        # Save to JSON, including mode
        self.save_values_to_json(
            normal_min_val=normal_min_val,
            normal_max_val=normal_max_val,
            hard_min_val=hard_min_val,
            hard_max_val=hard_max_val,
            mode=mode
        )

        # Update the option button color in real-time
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()

        self.destroy()

    def validate_entries(self, left_entry, right_entry):
        return self.check_and_fix_range(left_entry, right_entry, show_warning=True)

    def validate_normal_range(self, event=None):
        # Validate immediately after focus leaves the Normal right entry
        self.check_and_fix_range(self.length_entry1_normal, self.length_entry2_normal, show_warning=True)

    def validate_hard_range(self, event=None):
        # Validate immediately after focus leaves the Hard right entry
        self.check_and_fix_range(self.length_entry1_hard, self.length_entry2_hard, show_warning=True)

    def check_and_fix_range(self, left_entry, right_entry, show_warning=False):
        left_val = left_entry.get().strip()
        right_val = right_entry.get().strip()

        # Ensure they are integers
        try:
            left_num = int(left_val)
            right_num = int(right_val)
        except ValueError:
            if show_warning:
                messagebox.showwarning("경고", "숫자를 입력해주세요.")
            return False

        if right_num < left_num:
            if show_warning:
                messagebox.showwarning("경고", f"우측 값이 좌측 값보다 작습니다. 우측 값을 {left_num}으로 설정합니다.")
            right_entry.delete(0, tk.END)
            right_entry.insert(0, str(left_num))
            return False

        return True

    def set_normal_defaults(self):
        self.normal_min_val = self.normal_default_min
        self.normal_max_val = self.normal_default_max
        self.restore_current_values_to_entries()

    def set_hard_defaults(self):
        self.hard_min_val = self.hard_default_min
        self.hard_max_val = self.hard_default_max
        self.restore_current_values_to_entries()

    def restore_current_values_to_entries(self):
        # Set Normal entries
        self.length_entry1_normal.delete(0, tk.END)
        self.length_entry1_normal.insert(0, self.normal_min_val)
        self.length_entry2_normal.delete(0, tk.END)
        self.length_entry2_normal.insert(0, self.normal_max_val)

        # Set Hard entries
        self.length_entry1_hard.delete(0, tk.END)
        self.length_entry1_hard.insert(0, self.hard_min_val)
        self.length_entry2_hard.delete(0, tk.END)
        self.length_entry2_hard.insert(0, self.hard_max_val)

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.normal_min_val = data.get("내용일치한normal_min_val", self.normal_default_min)
                    self.normal_max_val = data.get("내용일치한normal_max_val", self.normal_default_max)
                    self.hard_min_val = data.get("내용일치한hard_min_val", self.hard_default_min)
                    self.hard_max_val = data.get("내용일치한hard_max_val", self.hard_default_max)
                    saved_mode = data.get("내용일치한mode", 1)
                    self.mode.set(saved_mode)
                    # Load transformation settings
                    paraphrase_enabled = data.get("내용일치한paraphrase_enabled", False)
                    difficulty_level = data.get("내용일치한difficulty_level", 2)
                    length_level = data.get("내용일치한length_level", 2)
                    self.지문변형_var.set(paraphrase_enabled)
                    self.지문난이도_var.set(difficulty_level)
                    self.지문길이_var.set(length_level)
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("내용일치한content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except:
                # If there's an error reading the file, fallback to defaults
                self.normal_min_val = self.normal_default_min
                self.normal_max_val = self.normal_default_max
                self.hard_min_val = self.hard_default_min
                self.hard_max_val = self.hard_default_max
                self.mode.set(0)
        else:
            # No file, use defaults
            self.normal_min_val = self.normal_default_min
            self.normal_max_val = self.normal_default_max
            self.hard_min_val = self.hard_default_min
            self.hard_max_val = self.hard_default_max
            self.mode.set(0)

    def save_values_to_json(self, normal_min_val, normal_max_val, hard_min_val, hard_max_val, mode=0):
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        # Load existing data if any
        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        # Update data with new values - use 내용일치한 prefix to separate from 내용일치
        existing_data["내용일치한normal_min_val"] = normal_min_val
        existing_data["내용일치한normal_max_val"] = normal_max_val
        existing_data["내용일치한hard_min_val"] = hard_min_val
        existing_data["내용일치한hard_max_val"] = hard_max_val
        existing_data["내용일치한mode"] = mode
        existing_data["내용일치한paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["내용일치한difficulty_level"] = self.지문난이도_var.get()
        existing_data["내용일치한length_level"] = self.지문길이_var.get()
        # Save content_change_mode (None when checkbox unchecked, actual value when checked)
        existing_data["내용일치한content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)

    def reset_to_defaults(self):
        """Reset all options to default values"""

        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)
        self.content_change_var.set(0)

        # Reset mode
        self.mode.set(0)

        # Reset entry values to defaults
        self.normal_min_val = self.normal_default_min
        self.normal_max_val = self.normal_default_max
        self.hard_min_val = self.hard_default_min
        self.hard_max_val = self.hard_default_max

        # Update UI
        self.restore_current_values_to_entries()

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

        # Update radio button states
        self.on_transform_toggle()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")







class QuestionOptions추론(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", main_frame=None, manual_mocktest_popup=None, options_file_path=None):
        super().__init__(parent)
        self.title('추론 옵션')
        self.geometry('650x500')
        self.minsize(650, 500)

        self.default_font = default_font
        self.main_frame_ref = main_frame  # Store reference to main frame
        self.manual_mocktest_popup = manual_mocktest_popup
        self.유형 = "추론"  # Store question type for button highlighting

        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        # Default values
        self.normal_default_min = "10"
        self.normal_default_max = "15"
        self.hard_default_min = "17"
        self.hard_default_max = "22"

        # Values (will be loaded from JSON or default)
        self.normal_min_val = self.normal_default_min
        self.normal_max_val = self.normal_default_max
        self.hard_min_val = self.hard_default_min
        self.hard_max_val = self.hard_default_max

        # Mode variable (1 or 2)
        self.추론_mode = tk.IntVar(value=1)

        # Passage transformation variables
        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)  # Default: 같은 난이도
        self.지문길이_var = tk.IntVar(value=2)  # Default: 비슷하게
        self.content_change_var = tk.IntVar(value=0)  # Default: 내용 변화 없음

        # Attempt to load saved values
        self.load_values_from_json()

        # Main frame
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)


        # Instruction Label
        intro_label = customtkinter.CTkLabel(
            self.main_frame,
            text="추론 세부 옵션을 설정합니다. (모든 문항에 적용됩니다)",
            font=(self.default_font, 12),
            text_color=("black", "white")
        )
        intro_label.pack(side='top', anchor='center', pady=(0, 10))






        # Frame for mode selection
        mode_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        mode_frame.pack(side='top', fill='x', expand=False, pady=(0, 10))

        mode_label = customtkinter.CTkLabel(
            mode_frame,
            text="정답 개수:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        mode_label.pack(side='top', anchor='w', pady=(0,5))

        radio_container = customtkinter.CTkFrame(mode_frame, fg_color="transparent")
        radio_container.pack(side='top', fill='x', expand=False)

        self.radio_button_multiple = customtkinter.CTkRadioButton(
            radio_container,
            text='정답 1개',
            font=(self.default_font, 13),
            variable=self.추론_mode,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_button_multiple.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        self.radio_button_single = customtkinter.CTkRadioButton(
            radio_container,
            text='정답 2개',
            font=(self.default_font, 13),
            variable=self.추론_mode,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_button_single.grid(row=0, column=1, padx=(10, 10), pady=5, sticky="w")

        # Frame for length configurations
        length_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        length_frame.pack(side='top', fill='x', expand=False, pady=(0,10))

        self.option_length_label = customtkinter.CTkLabel(
            length_frame,
            text="선지 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.option_length_label.pack(side='top', anchor='w', pady=(0))









        # Passage transformation checkbox
        self.지문변형_checkbox = customtkinter.CTkCheckBox(
            self.main_frame,
            text="지문을 변형하여 출제",
            variable=self.지문변형_var,
            command=self.on_transform_toggle,
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25",
            checkbox_width=20,
            checkbox_height=20
        )
        self.지문변형_checkbox.pack(pady=(5, 5), anchor='w')

        # Difficulty and length options container (initially hidden)
        self.difficulty_container = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")

        # Configure grid columns
        self.difficulty_container.grid_columnconfigure(0, weight=0)  # Label column
        self.difficulty_container.grid_columnconfigure(1, weight=1)  # Radio buttons column

        # Difficulty label and radio buttons (row=0)
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 난이도:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for difficulty
        difficulty_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_radio_frame.grid(row=0, column=1, sticky="w")

        self.radio_easier = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='더 쉽게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))

        self.radio_same = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='같은 난이도',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))

        self.radio_harder = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='더 높게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')

        # Length label and radio buttons (row=1)
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for length
        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")

        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 짧게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))

        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='비슷하게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))

        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 길게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for content change mode
        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "글의 요지는 유지하되, 세부 내용(예시, 통계 등)을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 주제는 유지하되, 요지(주장/결론)를 변경합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "원문의 소재만 활용하여 전혀 다른 내용의 지문을 생성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))











        # Create a frame using grid for both Normal and Hard settings
        config_frame = customtkinter.CTkFrame(length_frame, fg_color="transparent")
        config_frame.pack(side='top', fill='x', expand=False)

        # Configure columns for uniform resizing
        for col in [1, 3]:
            config_frame.grid_columnconfigure(col, weight=1)

        # Normal row
        normal_label = customtkinter.CTkLabel(
            config_frame,
            text="Normal 선지 길이:",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        normal_label.grid(row=0, column=0, padx=(0, 5), pady=5, sticky="e")

        self.length_entry1_normal = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry1_normal.grid(row=0, column=1, padx=(0, 5), pady=5, sticky="we")

        normal_tilde = customtkinter.CTkLabel(
            config_frame,
            text=" ~ ",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        normal_tilde.grid(row=0, column=2, padx=(5, 5), pady=5, sticky="we")

        self.length_entry2_normal = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry2_normal.grid(row=0, column=3, padx=(0, 5), pady=5, sticky="we")

        normal_unit = customtkinter.CTkLabel(
            config_frame,
            text="단어",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        normal_unit.grid(row=0, column=4, padx=(5, 5), pady=5, sticky="w")

        normal_default_btn = customtkinter.CTkButton(
            config_frame,
            text="기본값",
            font=(self.default_font, 12, 'bold'),
            width=40,
            height=25,
            fg_color="white",
            hover_color="#DDA15C",
            text_color="black",
            command=self.set_normal_defaults
        )
        normal_default_btn.grid(row=0, column=5, padx=5, pady=5, sticky="e")

        # Hard row
        hard_label = customtkinter.CTkLabel(
            config_frame,
            text="Hard 선지 길이:",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        hard_label.grid(row=1, column=0, padx=(0, 5), pady=5, sticky="e")

        self.length_entry1_hard = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry1_hard.grid(row=1, column=1, padx=(0, 5), pady=5, sticky="we")

        hard_tilde = customtkinter.CTkLabel(
            config_frame,
            text=" ~ ",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        hard_tilde.grid(row=1, column=2, padx=(5, 5), pady=5, sticky="we")

        self.length_entry2_hard = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry2_hard.grid(row=1, column=3, padx=(0, 5), pady=5, sticky="we")

        hard_unit = customtkinter.CTkLabel(
            config_frame,
            text="단어",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        hard_unit.grid(row=1, column=4, padx=(5, 5), pady=5, sticky="w")

        normal_default_hard = customtkinter.CTkButton(
            config_frame,
            text="기본값",
            font=(self.default_font, 12, 'bold'),
            width=40,
            height=25,
            fg_color="white",
            hover_color="#DDA15C",
            text_color="black",
            command=self.set_hard_defaults
        )
        normal_default_hard.grid(row=1, column=5, padx=5, pady=5, sticky="e")

        # Bind focus out events to validate right entries immediately
        self.length_entry2_normal.bind("<FocusOut>", self.validate_normal_range)
        self.length_entry2_hard.bind("<FocusOut>", self.validate_hard_range)

        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10,0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        self.confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        self.confirm_button.pack(side='right', padx=5, pady=(0, 5))

        # Populate entries with loaded or default values
        self.restore_current_values_to_entries()

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)

        # Show/hide difficulty options based on loaded checkbox state
        self.on_transform_toggle()

    def on_transform_toggle(self):
        """Enable/disable difficulty and length options based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        print(f"   Paraphrase enabled: {is_enabled}")
        print(f"   UI state: {state}")
        print(f"   Difficulty level: {self.지문난이도_var.get()}")
        print(f"   Length level: {self.지문길이_var.get()}")
        print(f"   Content change mode: {self.content_change_var.get()}")

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def on_confirm(self):
        # Validate entries on confirm as well
        normal_valid = self.validate_entries(self.length_entry1_normal, self.length_entry2_normal)
        hard_valid = self.validate_entries(self.length_entry1_hard, self.length_entry2_hard)

        # If validation fails for either Normal or Hard, do not close or save
        if not normal_valid or not hard_valid:
            return

        # If validation passes, proceed
        normal_min_val = self.length_entry1_normal.get().strip()
        normal_max_val = self.length_entry2_normal.get().strip()
        hard_min_val = self.length_entry1_hard.get().strip()
        hard_max_val = self.length_entry2_hard.get().strip()

        # Save to JSON, including mode
        self.save_values_to_json(
            normal_min_val=normal_min_val,
            normal_max_val=normal_max_val,
            hard_min_val=hard_min_val,
            hard_max_val=hard_max_val,
            mode=self.추론_mode.get()
        )

        # Update the option button color in real-time
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()

        self.destroy()

    def validate_entries(self, left_entry, right_entry):
        return self.check_and_fix_range(left_entry, right_entry, show_warning=True)

    def validate_normal_range(self, event=None):
        # Validate immediately after focus leaves the Normal right entry
        self.check_and_fix_range(self.length_entry1_normal, self.length_entry2_normal, show_warning=True)

    def validate_hard_range(self, event=None):
        # Validate immediately after focus leaves the Hard right entry
        self.check_and_fix_range(self.length_entry1_hard, self.length_entry2_hard, show_warning=True)

    def check_and_fix_range(self, left_entry, right_entry, show_warning=False):
        left_val = left_entry.get().strip()
        right_val = right_entry.get().strip()

        # Ensure they are integers
        try:
            left_num = int(left_val)
            right_num = int(right_val)
        except ValueError:
            if show_warning:
                messagebox.showwarning("경고", "숫자를 입력해주세요.")
            return False

        if right_num < left_num:
            if show_warning:
                messagebox.showwarning("경고", f"우측 값이 좌측 값보다 작습니다. 우측 값을 {left_num}으로 설정합니다.")
            right_entry.delete(0, tk.END)
            right_entry.insert(0, str(left_num))
            return False

        return True

    def set_normal_defaults(self):
        self.normal_min_val = self.normal_default_min
        self.normal_max_val = self.normal_default_max
        self.restore_current_values_to_entries()

    def set_hard_defaults(self):
        self.hard_min_val = self.hard_default_min
        self.hard_max_val = self.hard_default_max
        self.restore_current_values_to_entries()

    def restore_current_values_to_entries(self):
        # Set Normal entries
        self.length_entry1_normal.delete(0, tk.END)
        self.length_entry1_normal.insert(0, self.normal_min_val)
        self.length_entry2_normal.delete(0, tk.END)
        self.length_entry2_normal.insert(0, self.normal_max_val)

        # Set Hard entries
        self.length_entry1_hard.delete(0, tk.END)
        self.length_entry1_hard.insert(0, self.hard_min_val)
        self.length_entry2_hard.delete(0, tk.END)
        self.length_entry2_hard.insert(0, self.hard_max_val)

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.normal_min_val = data.get("추론normal_min_val", self.normal_default_min)
                    self.normal_max_val = data.get("추론normal_max_val", self.normal_default_max)
                    self.hard_min_val = data.get("추론hard_min_val", self.hard_default_min)
                    self.hard_max_val = data.get("추론hard_max_val", self.hard_default_max)
                    saved_mode = data.get("추론mode", 1)
                    self.추론_mode.set(saved_mode)
                    # Load transformation settings
                    paraphrase_enabled = data.get("추론paraphrase_enabled", False)
                    difficulty_level = data.get("추론difficulty_level", 2)
                    length_level = data.get("추론length_level", 2)
                    self.지문변형_var.set(paraphrase_enabled)
                    self.지문난이도_var.set(difficulty_level)
                    self.지문길이_var.set(length_level)
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("추론content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except:
                # If there's an error reading the file, fallback to defaults
                self.normal_min_val = self.normal_default_min
                self.normal_max_val = self.normal_default_max
                self.hard_min_val = self.hard_default_min
                self.hard_max_val = self.hard_default_max
                self.추론_mode.set(1)
        else:
            # No file, use defaults
            self.normal_min_val = self.normal_default_min
            self.normal_max_val = self.normal_default_max
            self.hard_min_val = self.hard_default_min
            self.hard_max_val = self.hard_default_max
            self.추론_mode.set(1)

    def save_values_to_json(self, normal_min_val, normal_max_val, hard_min_val, hard_max_val, mode=0):
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        # Load existing data if any
        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        # Update data with new values
        existing_data["추론normal_min_val"] = normal_min_val
        existing_data["추론normal_max_val"] = normal_max_val
        existing_data["추론hard_min_val"] = hard_min_val
        existing_data["추론hard_max_val"] = hard_max_val
        existing_data["추론mode"] = mode
        existing_data["추론paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["추론difficulty_level"] = self.지문난이도_var.get()
        existing_data["추론length_level"] = self.지문길이_var.get()
        # Save content_change_mode (None when checkbox unchecked, actual value when checked)
        existing_data["추론content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # Reset mode
        self.추론_mode.set(1)

        # Reset entry values to defaults
        self.normal_min_val = self.normal_default_min
        self.normal_max_val = self.normal_default_max
        self.hard_min_val = self.hard_default_min
        self.hard_max_val = self.hard_default_max

        # Update UI
        self.restore_current_values_to_entries()

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

        # Update radio button states
        self.on_transform_toggle()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")





class QuestionOptions추론불가(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", main_frame=None, manual_mocktest_popup=None, options_file_path=None):
        super().__init__(parent)
        self.title('추론불가 옵션')
        self.geometry('650x500')
        self.minsize(650, 500)

        self.default_font = default_font
        self.main_frame_ref = main_frame  # Store reference to main frame
        self.manual_mocktest_popup = manual_mocktest_popup
        self.유형 = "추론불가"  # Store question type for button highlighting

        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        # Default values
        self.normal_default_min = "10"
        self.normal_default_max = "15"
        self.hard_default_min = "17"
        self.hard_default_max = "22"

        # Values (will be loaded from JSON or default)
        self.normal_min_val = self.normal_default_min
        self.normal_max_val = self.normal_default_max
        self.hard_min_val = self.hard_default_min
        self.hard_max_val = self.hard_default_max

        # Mode variable (1 or 2)
        self.추론불가_mode = tk.IntVar(value=1)

        # Passage transformation variables
        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)  # Default: 같은 난이도
        self.지문길이_var = tk.IntVar(value=2)  # Default: 비슷하게
        self.content_change_var = tk.IntVar(value=0)  # Default: 내용 변화 없음

        # Attempt to load saved values
        self.load_values_from_json()

        # Main frame
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)






        # Instruction Label
        intro_label = customtkinter.CTkLabel(
            self.main_frame,
            text="추론불가 세부 옵션을 설정합니다. (모든 문항에 적용됩니다)",
            font=(self.default_font, 12),
            text_color=("black", "white")
        )
        intro_label.pack(side='top', anchor='center', pady=(0, 10))

        # Frame for mode selection
        mode_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        mode_frame.pack(side='top', fill='x', expand=False, pady=(0, 10))

        mode_label = customtkinter.CTkLabel(
            mode_frame,
            text="정답 개수:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        mode_label.pack(side='top', anchor='w', pady=(0,5))

        radio_container = customtkinter.CTkFrame(mode_frame, fg_color="transparent")
        radio_container.pack(side='top', fill='x', expand=False)

        self.radio_button_multiple = customtkinter.CTkRadioButton(
            radio_container,
            text='정답 1개',
            font=(self.default_font, 13),
            variable=self.추론불가_mode,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_button_multiple.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        self.radio_button_single = customtkinter.CTkRadioButton(
            radio_container,
            text='정답 2개',
            font=(self.default_font, 13),
            variable=self.추론불가_mode,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_button_single.grid(row=0, column=1, padx=(10, 10), pady=5, sticky="w")

        # Frame for length configurations
        length_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        length_frame.pack(side='top', fill='x', expand=False, pady=(0,10))

        self.option_length_label = customtkinter.CTkLabel(
            length_frame,
            text="선지 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.option_length_label.pack(side='top', anchor='w', pady=(0))

        # Create a frame using grid for both Normal and Hard settings
        config_frame = customtkinter.CTkFrame(length_frame, fg_color="transparent")
        config_frame.pack(side='top', fill='x', expand=False)

        # Configure columns for uniform resizing
        for col in [1, 3]:
            config_frame.grid_columnconfigure(col, weight=1)

        # Normal row
        normal_label = customtkinter.CTkLabel(
            config_frame,
            text="Normal 선지 길이:",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        normal_label.grid(row=0, column=0, padx=(0, 5), pady=5, sticky="e")

        self.length_entry1_normal = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry1_normal.grid(row=0, column=1, padx=(0, 5), pady=5, sticky="we")

        normal_tilde = customtkinter.CTkLabel(
            config_frame,
            text=" ~ ",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        normal_tilde.grid(row=0, column=2, padx=(5, 5), pady=5, sticky="we")

        self.length_entry2_normal = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry2_normal.grid(row=0, column=3, padx=(0, 5), pady=5, sticky="we")

        normal_unit = customtkinter.CTkLabel(
            config_frame,
            text="단어",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        normal_unit.grid(row=0, column=4, padx=(5, 5), pady=5, sticky="w")

        normal_default_btn = customtkinter.CTkButton(
            config_frame,
            text="기본값",
            font=(self.default_font, 12, 'bold'),
            width=40,
            height=25,
            fg_color="white",
            hover_color="#DDA15C",
            text_color="black",
            command=self.set_normal_defaults
        )
        normal_default_btn.grid(row=0, column=5, padx=5, pady=5, sticky="e")

        # Hard row
        hard_label = customtkinter.CTkLabel(
            config_frame,
            text="Hard 선지 길이:",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        hard_label.grid(row=1, column=0, padx=(0, 5), pady=5, sticky="e")

        self.length_entry1_hard = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry1_hard.grid(row=1, column=1, padx=(0, 5), pady=5, sticky="we")

        hard_tilde = customtkinter.CTkLabel(
            config_frame,
            text=" ~ ",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        hard_tilde.grid(row=1, column=2, padx=(5, 5), pady=5, sticky="we")

        self.length_entry2_hard = customtkinter.CTkEntry(
            config_frame,
            width=30,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry2_hard.grid(row=1, column=3, padx=(0, 5), pady=5, sticky="we")

        hard_unit = customtkinter.CTkLabel(
            config_frame,
            text="단어",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        hard_unit.grid(row=1, column=4, padx=(5, 5), pady=5, sticky="w")

        normal_default_hard = customtkinter.CTkButton(
            config_frame,
            text="기본값",
            font=(self.default_font, 12, 'bold'),
            width=40,
            height=25,
            fg_color="white",
            hover_color="#DDA15C",
            text_color="black",
            command=self.set_hard_defaults
        )
        normal_default_hard.grid(row=1, column=5, padx=5, pady=5, sticky="e")

        # Bind focus out events to validate right entries immediately
        self.length_entry2_normal.bind("<FocusOut>", self.validate_normal_range)
        self.length_entry2_hard.bind("<FocusOut>", self.validate_hard_range)




        # Passage transformation checkbox
        self.지문변형_checkbox = customtkinter.CTkCheckBox(
            self.main_frame,
            text="지문을 변형하여 출제",
            variable=self.지문변형_var,
            command=self.on_transform_toggle,
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25",
            checkbox_width=20,
            checkbox_height=20
        )
        self.지문변형_checkbox.pack(pady=(5, 5), anchor='w')

        # Difficulty and length options container (initially hidden)
        self.difficulty_container = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")

        # Configure grid columns
        self.difficulty_container.grid_columnconfigure(0, weight=0)  # Label column
        self.difficulty_container.grid_columnconfigure(1, weight=1)  # Radio buttons column

        # Difficulty label and radio buttons (row=0)
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 난이도:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for difficulty
        difficulty_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_radio_frame.grid(row=0, column=1, sticky="w")

        self.radio_easier = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='더 쉽게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))

        self.radio_same = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='같은 난이도',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))

        self.radio_harder = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='더 높게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')

        # Length label and radio buttons (row=1)
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for length
        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")

        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 짧게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))

        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='비슷하게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))

        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 길게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "글의 요지는 유지하되, 세부 내용(예시, 통계 등)을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 주제는 유지하되, 요지(주장/결론)를 변경합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "원문의 소재만 활용하여 전혀 다른 내용의 지문을 생성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))




        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10,0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        self.confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        self.confirm_button.pack(side='right', padx=5, pady=(0, 5))

        # Populate entries with loaded or default values
        self.restore_current_values_to_entries()

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)

        # Show/hide difficulty options based on loaded checkbox state
        self.on_transform_toggle()

    def on_transform_toggle(self):
        """Enable/disable difficulty and length options based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        print(f"   Paraphrase enabled: {is_enabled}")
        print(f"   UI state: {state}")
        print(f"   Difficulty level: {self.지문난이도_var.get()}")
        print(f"   Length level: {self.지문길이_var.get()}")
        print(f"   Content change mode: {self.content_change_var.get()}")

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def on_confirm(self):
        # Validate entries on confirm as well
        normal_valid = self.validate_entries(self.length_entry1_normal, self.length_entry2_normal)
        hard_valid = self.validate_entries(self.length_entry1_hard, self.length_entry2_hard)

        # If validation fails for either Normal or Hard, do not close or save
        if not normal_valid or not hard_valid:
            return

        # If validation passes, proceed
        normal_min_val = self.length_entry1_normal.get().strip()
        normal_max_val = self.length_entry2_normal.get().strip()
        hard_min_val = self.length_entry1_hard.get().strip()
        hard_max_val = self.length_entry2_hard.get().strip()

        # Save to JSON, including mode
        self.save_values_to_json(
            normal_min_val=normal_min_val,
            normal_max_val=normal_max_val,
            hard_min_val=hard_min_val,
            hard_max_val=hard_max_val,
            mode=self.추론불가_mode.get()
        )

        # Update the option button color in real-time
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()

        self.destroy()

    def validate_entries(self, left_entry, right_entry):
        return self.check_and_fix_range(left_entry, right_entry, show_warning=True)

    def validate_normal_range(self, event=None):
        # Validate immediately after focus leaves the Normal right entry
        self.check_and_fix_range(self.length_entry1_normal, self.length_entry2_normal, show_warning=True)

    def validate_hard_range(self, event=None):
        # Validate immediately after focus leaves the Hard right entry
        self.check_and_fix_range(self.length_entry1_hard, self.length_entry2_hard, show_warning=True)

    def check_and_fix_range(self, left_entry, right_entry, show_warning=False):
        left_val = left_entry.get().strip()
        right_val = right_entry.get().strip()

        # Ensure they are integers
        try:
            left_num = int(left_val)
            right_num = int(right_val)
        except ValueError:
            if show_warning:
                messagebox.showwarning("경고", "숫자를 입력해주세요.")
            return False

        if right_num < left_num:
            if show_warning:
                messagebox.showwarning("경고", f"우측 값이 좌측 값보다 작습니다. 우측 값을 {left_num}으로 설정합니다.")
            right_entry.delete(0, tk.END)
            right_entry.insert(0, str(left_num))
            return False

        return True

    def set_normal_defaults(self):
        self.normal_min_val = self.normal_default_min
        self.normal_max_val = self.normal_default_max
        self.restore_current_values_to_entries()

    def set_hard_defaults(self):
        self.hard_min_val = self.hard_default_min
        self.hard_max_val = self.hard_default_max
        self.restore_current_values_to_entries()

    def restore_current_values_to_entries(self):
        # Set Normal entries
        self.length_entry1_normal.delete(0, tk.END)
        self.length_entry1_normal.insert(0, self.normal_min_val)
        self.length_entry2_normal.delete(0, tk.END)
        self.length_entry2_normal.insert(0, self.normal_max_val)

        # Set Hard entries
        self.length_entry1_hard.delete(0, tk.END)
        self.length_entry1_hard.insert(0, self.hard_min_val)
        self.length_entry2_hard.delete(0, tk.END)
        self.length_entry2_hard.insert(0, self.hard_max_val)

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.normal_min_val = data.get("추론불가normal_min_val", self.normal_default_min)
                    self.normal_max_val = data.get("추론불가normal_max_val", self.normal_default_max)
                    self.hard_min_val = data.get("추론불가hard_min_val", self.hard_default_min)
                    self.hard_max_val = data.get("추론불가hard_max_val", self.hard_default_max)
                    saved_mode = data.get("추론불가mode", 1)
                    self.추론불가_mode.set(saved_mode)
                    # Load transformation settings
                    paraphrase_enabled = data.get("추론불가paraphrase_enabled", False)
                    difficulty_level = data.get("추론불가difficulty_level", 2)
                    length_level = data.get("추론불가length_level", 2)
                    self.지문변형_var.set(paraphrase_enabled)
                    self.지문난이도_var.set(difficulty_level)
                    self.지문길이_var.set(length_level)
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("추론불가content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except:
                # If there's an error reading the file, fallback to defaults
                self.normal_min_val = self.normal_default_min
                self.normal_max_val = self.normal_default_max
                self.hard_min_val = self.hard_default_min
                self.hard_max_val = self.hard_default_max
                self.추론불가_mode.set(1)
        else:
            # No file, use defaults
            self.normal_min_val = self.normal_default_min
            self.normal_max_val = self.normal_default_max
            self.hard_min_val = self.hard_default_min
            self.hard_max_val = self.hard_default_max
            self.추론불가_mode.set(1)

    def save_values_to_json(self, normal_min_val, normal_max_val, hard_min_val, hard_max_val, mode=0):
        print("save_values_to_json called")
        print(f"mode: {mode}")
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        # Load existing data if any
        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        # Update data with new values
        existing_data["추론불가normal_min_val"] = normal_min_val
        existing_data["추론불가normal_max_val"] = normal_max_val
        existing_data["추론불가hard_min_val"] = hard_min_val
        existing_data["추론불가hard_max_val"] = hard_max_val
        existing_data["추론불가mode"] = mode
        existing_data["추론불가paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["추론불가difficulty_level"] = self.지문난이도_var.get()
        existing_data["추론불가length_level"] = self.지문길이_var.get()
        existing_data["추론불가content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # Reset mode
        self.추론불가_mode.set(1)

        # Reset entry values to defaults
        self.normal_min_val = self.normal_default_min
        self.normal_max_val = self.normal_default_max
        self.hard_min_val = self.hard_default_min
        self.hard_max_val = self.hard_default_max

        # Update UI
        self.restore_current_values_to_entries()

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

        # Update radio button states
        self.on_transform_toggle()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")





class QuestionOptions순서(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, 실모flag=None, 수동출제할지문번호=None, row_idx=None, 유형=None, 난이도=None, passage_ids=None, manual_mocktest_popup=None, options_file_path=None):
        super().__init__(parent)
        self.title('순서 옵션')
        self.geometry('650x250')
        self.minsize(650, 250)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame
        self.excel_file = excel_file
        self.실모flag = 실모flag
        self.수동출제할지문번호 = 수동출제할지문번호
        self.row_idx = row_idx
        self.유형 = 유형
        self.난이도 = 난이도
        self.passage_ids = passage_ids
        self.manual_mocktest_popup = manual_mocktest_popup

        # Passage transformation variables
        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)  # Default: 같은 난이도
        self.지문길이_var = tk.IntVar(value=2)  # Default: 비슷하게
        self.content_change_var = tk.IntVar(value=0)  # Default: 변화 없음

        self.default_font = default_font
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        # Main frame
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)

        # Passage transformation frame
        transform_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        transform_frame.pack(side='top', fill='x', expand=False, pady=(10, 0))

        # Checkbox
        self.transform_checkbox = customtkinter.CTkCheckBox(
            transform_frame,
            text="지문을 변형하여 출제",
            variable=self.지문변형_var,
            command=self.toggle_difficulty_options,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.transform_checkbox.pack(side='top', anchor='w', pady=(0, 5))

        # Difficulty and length options container (hidden by default)
        self.difficulty_container = customtkinter.CTkFrame(transform_frame, fg_color="transparent")

        # Configure grid columns
        self.difficulty_container.grid_columnconfigure(0, weight=0)  # Label column
        self.difficulty_container.grid_columnconfigure(1, weight=1)  # Radio buttons column

        # Difficulty label and radio buttons (row=0)
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 난이도:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for difficulty
        difficulty_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_radio_frame.grid(row=0, column=1, sticky="w")

        self.radio_easier = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='더 쉽게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))

        self.radio_same = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='같은 난이도',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))

        self.radio_harder = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='더 높게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')

        # Length label and radio buttons (row=1)
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for length
        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")

        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 짧게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))

        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='비슷하게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))

        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 길게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "요지는 유지하되, 예시/설명 등 세부 사항을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 핵심 주장/요지를 변경합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "관련 소재로 완전히 새로운 지문을 생성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Load saved values from JSON
        self.load_values_from_json()

        # Initialize radio button states (after loading)
        self.toggle_difficulty_options()

        # Action frame with 3 buttons (기본값, 수동출제, 확인)
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10, 0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=100,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Manual placement button (middle)
        if not self.opened_from_dashboard:
            if 실모flag == True:
                수동출제버튼텍스트 = "순서 수동출제\n(현재 문항)"
                수동출제버튼커맨드 = self.on_manual_placement실모
            else:
                수동출제버튼텍스트 = "순서 수동출제"
                수동출제버튼커맨드 = self.on_manual_placement

            self.manual_button = customtkinter.CTkButton(
                action_frame,
                text=수동출제버튼텍스트,
                font=(self.default_font, 13, 'bold'),
                width=160,
                height=40,
                fg_color="#FEF9E0",
                hover_color="#DDA15C",
                text_color="black",
                command=수동출제버튼커맨드
            )
            self.manual_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=100,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        confirm_button.pack(side='right', padx=5, pady=(0, 5))


        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"
        
        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()



    def on_manual_placement(self):
        
        popup = ManualQuestionPopup문제선택(
            parent=self.master,
            main_frame_ref=self.main_frame_ref,
            excel_file=self.excel_file,
            default_font=self.default_font,
            passage_ids=self.passage_ids,
            유형=self.유형,
            난이도=self.난이도,
        )
        self.destroy()

        popup.grab_set()

    def on_manual_placement실모(self):
        # Open the manual placement popup with 실모flag = True
        if self.main_frame_ref is None or self.실모flag is None or self.row_idx is None or self.수동출제할지문번호 is None:
            messagebox.showerror("오류", "필요한 정보가 부족합니다.")
            return

        def save_callback(row_idx, 수동출제할지문번호, 유형, 난이도, edited_text):
            # Called by popup after user hits '확인'
            self.main_frame_ref.save_manual_placement_text실모(row_idx, 수동출제할지문번호, 유형, 난이도, edited_text)
            passageid유형난이도합본 = 수동출제할지문번호 + " // " + 유형 + "_" + 난이도
            self.manual_mocktest_popup.update_current_status_label수동실모(None, passageid유형난이도합본) #전체
        
        popup = ManualPlacementPopup(
            parent=self.master,
            default_font=self.default_font,
            excel_file=self.excel_file, 
            row_idx=self.row_idx,
            수동출제할지문번호=self.수동출제할지문번호,
            유형=self.유형,
            난이도=self.난이도,
            save_callback=save_callback,
            manual_edited_texts=self.main_frame_ref.manual_edited_texts,
            일반or실모="실모",
            manual_mocktest_popup=self.manual_mocktest_popup,
        )
        self.destroy()

        popup.grab_set()

    def on_confirm(self):
        """Save options and update button color"""
        self.save_values_to_json()

        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def load_values_from_json(self):
        """Load saved option values from JSON"""
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.지문변형_var.set(data.get("순서paraphrase_enabled", False))
                    self.지문난이도_var.set(data.get("순서difficulty_level", 2))
                    self.지문길이_var.set(data.get("순서length_level", 2))
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("순서content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except:
                pass

    def save_values_to_json(self):
        """Save current option values to JSON"""
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)
        
        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}
        
        existing_data["순서paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["순서difficulty_level"] = self.지문난이도_var.get()
        existing_data["순서length_level"] = self.지문길이_var.get()
        existing_data["순서content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)

        








class QuestionOptions삽입(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, 실모flag=None, 수동출제할지문번호=None, row_idx=None, 유형=None, 난이도=None, passage_ids=None, manual_mocktest_popup=None, options_file_path=None):
        super().__init__(parent)
        self.title('삽입 옵션')
        self.geometry('650x250')
        self.minsize(650, 250)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame
        self.excel_file = excel_file
        self.실모flag = 실모flag
        self.수동출제할지문번호 = 수동출제할지문번호
        self.row_idx = row_idx
        self.유형 = 유형
        self.난이도 = 난이도
        self.passage_ids = passage_ids
        self.manual_mocktest_popup = manual_mocktest_popup

        # Passage transformation variables
        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)  # Default: 같은 난이도
        self.지문길이_var = tk.IntVar(value=2)  # Default: 비슷하게
        self.content_change_var = tk.IntVar(value=0)  # Default: 변화 없음

        self.default_font = default_font
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        # Main frame
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)

        # Passage transformation frame
        transform_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        transform_frame.pack(side='top', fill='x', expand=False, pady=(10, 0))

        # Checkbox
        self.transform_checkbox = customtkinter.CTkCheckBox(
            transform_frame,
            text="지문을 변형하여 출제",
            variable=self.지문변형_var,
            command=self.toggle_difficulty_options,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.transform_checkbox.pack(side='top', anchor='w', pady=(0, 5))

        # Difficulty and length options container (hidden by default)
        self.difficulty_container = customtkinter.CTkFrame(transform_frame, fg_color="transparent")

        # Configure grid columns
        self.difficulty_container.grid_columnconfigure(0, weight=0)  # Label column
        self.difficulty_container.grid_columnconfigure(1, weight=1)  # Radio buttons column

        # Difficulty label and radio buttons (row=0)
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 난이도:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for difficulty
        difficulty_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_radio_frame.grid(row=0, column=1, sticky="w")

        self.radio_easier = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='더 쉽게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))

        self.radio_same = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='같은 난이도',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))

        self.radio_harder = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='더 높게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')

        # Length label and radio buttons (row=1)
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for length
        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")

        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 짧게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))

        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='비슷하게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))

        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 길게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "요지는 유지하되, 예시/설명 등 세부 사항을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 핵심 주장/요지를 변경합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "관련 소재로 완전히 새로운 지문을 생성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Load saved values from JSON
        self.load_values_from_json()

        # Initialize radio button states (after loading)
        self.toggle_difficulty_options()

        # Action frame with 3 buttons (기본값, 수동출제, 확인)
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10, 0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=100,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Manual placement button (middle)
        if not self.opened_from_dashboard:
            if 실모flag == True:
                수동출제버튼텍스트 = "삽입 수동출제\n(현재 문항)"
                수동출제버튼커맨드 = self.on_manual_placement실모
            else:
                수동출제버튼텍스트 = "삽입 수동출제"
                수동출제버튼커맨드 = self.on_manual_placement

            self.manual_button = customtkinter.CTkButton(
                action_frame,
                text=수동출제버튼텍스트,
                font=(self.default_font, 13, 'bold'),
                width=160,
                height=40,
                fg_color="#FEF9E0",
                hover_color="#DDA15C",
                text_color="black",
                command=수동출제버튼커맨드
            )
            self.manual_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=100,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        confirm_button.pack(side='right', padx=5, pady=(0, 5))


        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"
        
        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()



    def on_manual_placement(self):
        
        popup = ManualQuestionPopup문제선택(
            parent=self.master,
            main_frame_ref=self.main_frame_ref,
            excel_file=self.excel_file,
            default_font=self.default_font,
            passage_ids=self.passage_ids,
            유형=self.유형,
            난이도=self.난이도,
        )
        self.destroy()

        popup.grab_set()

    def on_manual_placement실모(self):
        # Open the manual placement popup with 실모flag = True
        if self.main_frame_ref is None or self.실모flag is None or self.row_idx is None or self.수동출제할지문번호 is None:
            messagebox.showerror("오류", "필요한 정보가 부족합니다.")
            return

        def save_callback(row_idx, 수동출제할지문번호, 유형, 난이도, edited_text):
            # Called by popup after user hits '확인'
            self.main_frame_ref.save_manual_placement_text실모(row_idx, 수동출제할지문번호, 유형, 난이도, edited_text)
            passageid유형난이도합본 = 수동출제할지문번호 + " // " + 유형 + "_" + 난이도
            self.manual_mocktest_popup.update_current_status_label수동실모(None, passageid유형난이도합본) #전체
        
        popup = ManualPlacementPopup(
            parent=self.master,
            default_font=self.default_font,
            excel_file=self.excel_file, 
            row_idx=self.row_idx,
            수동출제할지문번호=self.수동출제할지문번호,
            유형=self.유형,
            난이도=self.난이도,
            save_callback=save_callback,
            manual_edited_texts=self.main_frame_ref.manual_edited_texts,
            일반or실모="실모",
            manual_mocktest_popup=self.manual_mocktest_popup,
        )
        self.destroy()

        popup.grab_set()

    def on_confirm(self):
        """Save options and update button color"""
        self.save_values_to_json()

        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def load_values_from_json(self):
        """Load saved option values from JSON"""
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.지문변형_var.set(data.get("삽입paraphrase_enabled", False))
                    self.지문난이도_var.set(data.get("삽입difficulty_level", 2))
                    self.지문길이_var.set(data.get("삽입length_level", 2))
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("삽입content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except:
                pass

    def save_values_to_json(self):
        """Save current option values to JSON"""
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        existing_data["삽입paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["삽입difficulty_level"] = self.지문난이도_var.get()
        existing_data["삽입length_level"] = self.지문길이_var.get()
        existing_data["삽입content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)

        







class QuestionOptions요지(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", main_frame=None, manual_mocktest_popup=None, options_file_path=None):
        super().__init__(parent)
        self.title('요지 옵션')
        self.geometry('650x400')
        self.minsize(650, 400)

        self.default_font = default_font
        self.main_frame_ref = main_frame
        self.manual_mocktest_popup = manual_mocktest_popup
        self.유형 = "요지"

        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)


        # Mode variable (1 or 2)
        self.요지_mode = tk.IntVar(value=1)

        # Passage transformation variables
        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)  # Default: 같은 난이도
        self.지문길이_var = tk.IntVar(value=2)  # Default: 비슷하게
        self.content_change_var = tk.IntVar(value=0)  # Default: 변화 없음

        # Attempt to load saved values
        self.load_values_from_json()

        # Main frame
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)





        # Instruction Label
        intro_label = customtkinter.CTkLabel(
            self.main_frame,
            text="요지 세부 옵션을 설정합니다. (모든 문항에 적용됩니다)",
            font=(self.default_font, 12),
            text_color=("black", "white")
        )
        intro_label.pack(side='top', anchor='center', pady=(0, 10))

        # Frame for mode selection
        mode_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        mode_frame.pack(side='top', fill='x', expand=False, pady=(0, 10))

        mode_label = customtkinter.CTkLabel(
            mode_frame,
            text="선지 언어:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        mode_label.pack(side='top', anchor='w', pady=(0,5))

        radio_container = customtkinter.CTkFrame(mode_frame, fg_color="transparent")
        radio_container.pack(side='top', fill='x', expand=False)

        self.radio_button_multiple = customtkinter.CTkRadioButton(
            radio_container,
            text='한글 선지',
            font=(self.default_font, 13),
            variable=self.요지_mode,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_button_multiple.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        self.radio_button_single = customtkinter.CTkRadioButton(
            radio_container,
            text='영어 선지',
            font=(self.default_font, 13),
            variable=self.요지_mode,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_button_single.grid(row=0, column=1, padx=(10, 10), pady=5, sticky="w")






        # Passage transformation checkbox
        self.지문변형_checkbox = customtkinter.CTkCheckBox(
            self.main_frame,
            text="지문을 변형하여 출제",
            variable=self.지문변형_var,
            command=self.toggle_difficulty_options,
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25",
            checkbox_width=20,
            checkbox_height=20
        )
        self.지문변형_checkbox.pack(pady=(5, 5), anchor='w')

        # Difficulty and length options container (initially hidden)
        self.difficulty_container = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")

        # Configure grid columns
        self.difficulty_container.grid_columnconfigure(0, weight=0)  # Label column
        self.difficulty_container.grid_columnconfigure(1, weight=1)  # Radio buttons column

        # Difficulty label and radio buttons (row=0)
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 난이도:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for difficulty
        difficulty_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_radio_frame.grid(row=0, column=1, sticky="w")

        self.radio_easier = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='더 쉽게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))

        self.radio_same = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='같은 난이도',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))

        self.radio_harder = customtkinter.CTkRadioButton(
            difficulty_radio_frame,
            text='더 높게',
            font=(self.default_font, 13),
            variable=self.지문난이도_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')

        # Length label and radio buttons (row=1)
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")

        # Radio buttons frame for length
        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")

        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 짧게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))

        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='비슷하게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))

        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame,
            text='더 길게',
            font=(self.default_font, 13),
            variable=self.지문길이_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "요지는 유지하되, 예시/설명 등 세부 사항을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 핵심 주장/요지를 변경합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "관련 소재로 완전히 새로운 지문을 생성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Initialize radio button states
        self.toggle_difficulty_options()




        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10,0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        self.confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        self.confirm_button.pack(side='right', padx=5, pady=(0, 5))

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def on_confirm(self):
        # Save to JSON, including mode
        self.save_values_to_json(
            mode=self.요지_mode.get()
        )

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)
        self.요지_mode.set(1)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update UI state
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    saved_mode = data.get("요지mode", 1)
                    self.요지_mode.set(saved_mode)
                    
                    # Load transformation settings
                    paraphrase_enabled = data.get("요지paraphrase_enabled", False)
                    difficulty_level = data.get("요지difficulty_level", 2)
                    length_level = data.get("요지length_level", 2)
                    self.지문변형_var.set(paraphrase_enabled)
                    self.지문난이도_var.set(difficulty_level)
                    self.지문길이_var.set(length_level)
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("요지content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)

            except:
                self.요지_mode.set(1)

    def save_values_to_json(self, mode=1):
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)
        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        existing_data["요지mode"] = mode
        existing_data["요지paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["요지difficulty_level"] = self.지문난이도_var.get()
        existing_data["요지length_level"] = self.지문길이_var.get()
        existing_data["요지content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)







class QuestionOptions요약(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, 실모flag=None, 수동출제할지문번호=None, row_idx=None, 유형=None, 난이도=None, passage_ids=None, manual_mocktest_popup=None, options_file_path=None):
        super().__init__(parent)
        self.title('요약 옵션')
        self.geometry('650x250')
        self.minsize(650, 250)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame
        self.excel_file = excel_file
        self.실모flag = 실모flag
        self.수동출제할지문번호 = 수동출제할지문번호
        self.row_idx = row_idx
        self.유형 = 유형
        self.난이도 = 난이도
        self.passage_ids = passage_ids
        self.manual_mocktest_popup = manual_mocktest_popup

        self.default_font = default_font
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        # Transformation variables
        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)
        self.지문길이_var = tk.IntVar(value=2)
        self.content_change_var = tk.IntVar(value=0)  # Default: 변화 없음

        # Main frame
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)

        # Transformation checkbox
        self.지문변형_checkbox = customtkinter.CTkCheckBox(
            self.main_frame,
            text="지문을 변형하여 출제",
            variable=self.지문변형_var,
            command=self.toggle_difficulty_options,
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.지문변형_checkbox.pack(pady=(0, 10), anchor='w')

        # Container for difficulty and length options
        self.difficulty_container = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")

        # Difficulty options (row 0)
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 난이도:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        difficulty_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_frame.grid(row=0, column=1, sticky="w")

        self.difficulty_easier = customtkinter.CTkRadioButton(
            difficulty_frame,
            text="더 쉽게",
            variable=self.지문난이도_var,
            value=1,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.difficulty_easier.pack(side='left', padx=5)

        self.difficulty_same = customtkinter.CTkRadioButton(
            difficulty_frame,
            text="같은 난이도",
            variable=self.지문난이도_var,
            value=2,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.difficulty_same.pack(side='left', padx=5)

        self.difficulty_harder = customtkinter.CTkRadioButton(
            difficulty_frame,
            text="더 높게",
            variable=self.지문난이도_var,
            value=3,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.difficulty_harder.pack(side='left', padx=5)

        # Length options (row 1)
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")

        length_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_frame.grid(row=1, column=1, sticky="w")

        self.length_shorter = customtkinter.CTkRadioButton(
            length_frame,
            text="더 짧게",
            variable=self.지문길이_var,
            value=1,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.length_shorter.pack(side='left', padx=5)

        self.length_similar = customtkinter.CTkRadioButton(
            length_frame,
            text="비슷하게",
            variable=self.지문길이_var,
            value=2,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.length_similar.pack(side='left', padx=5)

        self.length_longer = customtkinter.CTkRadioButton(
            length_frame,
            text="더 길게",
            variable=self.지문길이_var,
            value=3,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.length_longer.pack(side='left', padx=5)

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "요지는 유지하되, 예시/설명 등 세부 사항을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 핵심 주장/요지를 변경합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "관련 소재로 완전히 새로운 지문을 생성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Load saved values from JSON
        self.load_values_from_json()

        # Initialize radio button states (after loading)
        self.toggle_difficulty_options()

        # Action frame with 3 buttons (기본값, 수동출제, 확인)
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10, 0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=100,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Manual placement button (middle)
        if not self.opened_from_dashboard:
            if 실모flag == True:
                수동출제버튼텍스트 = "요약문 수동출제\n(현재 문항)"
                수동출제버튼커맨드 = self.on_manual_placement실모
            else:
                수동출제버튼텍스트 = "요약문 수동출제"
                수동출제버튼커맨드 = self.on_manual_placement

            self.manual_button = customtkinter.CTkButton(
                action_frame,
                text=수동출제버튼텍스트,
                font=(self.default_font, 13, 'bold'),
                width=160,
                height=40,
                fg_color="#FEF9E0",
                hover_color="#DDA15C",
                text_color="black",
                command=수동출제버튼커맨드
            )
            self.manual_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=100,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        confirm_button.pack(side='right', padx=5, pady=(0, 5))

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.difficulty_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.difficulty_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.difficulty_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.length_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.length_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.length_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()



    def on_manual_placement(self):
        
        popup = ManualQuestionPopup문제선택(
            parent=self.master,
            main_frame_ref=self.main_frame_ref,
            excel_file=self.excel_file,
            default_font=self.default_font,
            passage_ids=self.passage_ids,
            유형=self.유형,
            난이도=self.난이도,
        )
        self.destroy()

        popup.grab_set()

    def on_manual_placement실모(self):
        # Open the manual placement popup with 실모flag = True
        if self.main_frame_ref is None or self.실모flag is None or self.row_idx is None or self.수동출제할지문번호 is None:
            messagebox.showerror("오류", "필요한 정보가 부족합니다.")
            return

        def save_callback(row_idx, 수동출제할지문번호, 유형, 난이도, edited_text):
            # Called by popup after user hits '확인'
            self.main_frame_ref.save_manual_placement_text실모(row_idx, 수동출제할지문번호, 유형, 난이도, edited_text)
            passageid유형난이도합본 = 수동출제할지문번호 + " // " + 유형 + "_" + 난이도
            self.manual_mocktest_popup.update_current_status_label수동실모(None, passageid유형난이도합본) #전체
        
        popup = ManualPlacementPopup(
            parent=self.master,
            default_font=self.default_font,
            excel_file=self.excel_file, 
            row_idx=self.row_idx,
            수동출제할지문번호=self.수동출제할지문번호,
            유형=self.유형,
            난이도=self.난이도,
            save_callback=save_callback,
            manual_edited_texts=self.main_frame_ref.manual_edited_texts,
            일반or실모="실모",
            manual_mocktest_popup=self.manual_mocktest_popup,
        )
        self.destroy()

        popup.grab_set()

    def on_confirm(self):
        """Save options and update button color"""
        self.save_values_to_json()

        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def load_values_from_json(self):
        """Load saved option values from JSON"""
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.지문변형_var.set(data.get("요약paraphrase_enabled", False))
                    self.지문난이도_var.set(data.get("요약difficulty_level", 2))
                    self.지문길이_var.set(data.get("요약length_level", 2))
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("요약content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except:
                pass

    def save_values_to_json(self):
        """Save current option values to JSON"""
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        existing_data["요약paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["요약difficulty_level"] = self.지문난이도_var.get()
        existing_data["요약length_level"] = self.지문길이_var.get()
        existing_data["요약content_change_mode"] = self.content_change_var.get()
        
        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)

        



class QuestionOptions영작1(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, 실모flag=None, 수동출제할지문번호=None, row_idx=None, 유형=None, 난이도=None, passage_ids=None, manual_mocktest_popup=None, options_file_path=None):
        super().__init__(parent)
        self.title('영작1 옵션')
        self.geometry('650x350')
        self.minsize(650, 350)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame
        self.excel_file = excel_file
        self.실모flag = 실모flag
        self.수동출제할지문번호 = 수동출제할지문번호
        self.row_idx = row_idx
        self.유형 = 유형
        self.난이도 = 난이도
        self.passage_ids = passage_ids
        self.manual_mocktest_popup = manual_mocktest_popup

        self.default_font = default_font
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        # Transformation variables
        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)
        self.지문길이_var = tk.IntVar(value=2)
        self.content_change_var = tk.IntVar(value=0)  # Default: 변화 없음

        # Checkbox variable
        self.blank_mode_var = tk.IntVar(value=0)

        # Questions per passage variable (default: 1)
        self.questions_per_passage_var = tk.IntVar(value=1)

        # Load saved value from JSON
        self.load_values_from_json()

        # Main frame
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)

        # Questions per passage option (NEW)
        questions_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        questions_frame.pack(side='top', fill='x', expand=False, pady=(10, 10))

        questions_label = customtkinter.CTkLabel(
            questions_frame,
            text="한 지문당 영작 문제 수:",
            font=(self.default_font, 12, 'bold'),
            text_color=("black", "white")
        )
        questions_label.pack(side='left', padx=(0, 15))

        radio_frame = customtkinter.CTkFrame(questions_frame, fg_color="transparent")
        radio_frame.pack(side='left', fill='x', expand=True)

        self.radio_1_question = customtkinter.CTkRadioButton(
            radio_frame,
            text='1개',
            font=(self.default_font, 12),
            variable=self.questions_per_passage_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C",
            border_color="gray"
        )
        self.radio_1_question.pack(side='left', padx=(0, 15))

        self.radio_2_questions = customtkinter.CTkRadioButton(
            radio_frame,
            text='2개',
            font=(self.default_font, 12),
            variable=self.questions_per_passage_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C",
            border_color="gray"
        )
        self.radio_2_questions.pack(side='left', padx=(0, 15))

        self.radio_3_questions = customtkinter.CTkRadioButton(
            radio_frame,
            text='3개',
            font=(self.default_font, 12),
            variable=self.questions_per_passage_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C",
            border_color="gray"
        )
        self.radio_3_questions.pack(side='left', padx=(0, 15))






        # Checkbox (existing feature)
        self.blank_mode_checkbox = customtkinter.CTkCheckBox(
            self.main_frame,
            text="한글 뜻 없이 빈칸으로 출제",
            variable=self.blank_mode_var,
            font=(self.default_font, 12, 'bold'),
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray",
            command=self.on_checkbox_changed
        )
        self.blank_mode_checkbox.pack(pady=(10, 10), anchor='w')








        # Transformation checkbox
        self.지문변형_checkbox = customtkinter.CTkCheckBox(
            self.main_frame,
            text="지문을 변형하여 출제",
            variable=self.지문변형_var,
            command=self.toggle_difficulty_options,
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.지문변형_checkbox.pack(pady=(0, 10), anchor='w')

        # Container for difficulty and length options
        self.difficulty_container = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")

        # Difficulty options (row 0)
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 난이도:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        difficulty_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_frame.grid(row=0, column=1, sticky="w")

        self.difficulty_easier = customtkinter.CTkRadioButton(
            difficulty_frame,
            text="더 쉽게",
            variable=self.지문난이도_var,
            value=1,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.difficulty_easier.pack(side='left', padx=5)

        self.difficulty_same = customtkinter.CTkRadioButton(
            difficulty_frame,
            text="같은 난이도",
            variable=self.지문난이도_var,
            value=2,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.difficulty_same.pack(side='left', padx=5)

        self.difficulty_harder = customtkinter.CTkRadioButton(
            difficulty_frame,
            text="더 높게",
            variable=self.지문난이도_var,
            value=3,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.difficulty_harder.pack(side='left', padx=5)

        # Length options (row 1)
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")

        length_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_frame.grid(row=1, column=1, sticky="w")

        self.length_shorter = customtkinter.CTkRadioButton(
            length_frame,
            text="더 짧게",
            variable=self.지문길이_var,
            value=1,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.length_shorter.pack(side='left', padx=5)

        self.length_similar = customtkinter.CTkRadioButton(
            length_frame,
            text="비슷하게",
            variable=self.지문길이_var,
            value=2,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.length_similar.pack(side='left', padx=5)

        self.length_longer = customtkinter.CTkRadioButton(
            length_frame,
            text="더 길게",
            variable=self.지문길이_var,
            value=3,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.length_longer.pack(side='left', padx=5)

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "요지는 유지하되, 예시/설명 등 세부 사항을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 핵심 주장/요지를 변경합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "관련 소재로 완전히 새로운 지문을 생성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Initialize radio button states
        self.toggle_difficulty_options()





        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=100,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        if not self.opened_from_dashboard:
            if 실모flag == True:
                수동출제버튼텍스트 = "영작1 수동출제\n(현재 문항)"
                수동출제버튼커맨드 = self.on_manual_placement실모
            else:
                수동출제버튼텍스트 = "영작1 수동출제"
                수동출제버튼커맨드 = self.on_manual_placement

            self.manual_button = customtkinter.CTkButton(
                action_frame,
                text=수동출제버튼텍스트,
                font=(self.default_font, 13, 'bold'),
                width=160,
                height=40,
                fg_color="#FEF9E0",
                hover_color="#DDA15C",
                text_color="black",
                command=수동출제버튼커맨드
            )
            self.manual_button.pack(side='left', padx=5, pady=(0, 5))

        self.confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        self.confirm_button.pack(side='right', padx=5, pady=(0, 5))
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10, 0))


        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.difficulty_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.difficulty_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.difficulty_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.length_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.length_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.length_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.blank_mode_var.set(data.get("영작1_blank_mode", 0))
                    self.questions_per_passage_var.set(data.get("영작1_questions_per_passage", 1))

                    # Load transformation settings
                    paraphrase_enabled = data.get("영작1paraphrase_enabled", False)
                    difficulty_level = data.get("영작1difficulty_level", 2)
                    length_level = data.get("영작1length_level", 2)
                    self.지문변형_var.set(paraphrase_enabled)
                    self.지문난이도_var.set(difficulty_level)
                    self.지문길이_var.set(length_level)
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("영작1content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)

            except:
                self.blank_mode_var.set(0)
                self.questions_per_passage_var.set(1)
        else:
            self.blank_mode_var.set(0)
            self.questions_per_passage_var.set(1)

    def save_values_to_json(self):
        # Load existing data first
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
            except:
                data = {}
        else:
            data = {}

        # Update only our value
        data["영작1_blank_mode"] = self.blank_mode_var.get()
        data["영작1_questions_per_passage"] = self.questions_per_passage_var.get()
        data["영작1paraphrase_enabled"] = self.지문변형_var.get()
        data["영작1difficulty_level"] = self.지문난이도_var.get()
        data["영작1length_level"] = self.지문길이_var.get()
        data["영작1content_change_mode"] = self.content_change_var.get()

        # Create directory if needed
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        # Write back
        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(data, f, ensure_ascii=False, indent=4)

    def on_checkbox_changed(self):
        self.save_values_to_json()

    def on_confirm(self):
        """Save options and update button color"""
        self.save_values_to_json()

        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # Reset blank_mode
        self.blank_mode_var.set(0)

        # Reset questions per passage
        self.questions_per_passage_var.set(1)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update radio button states
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def on_manual_placement(self):

        popup = ManualQuestionPopup문제선택(
            parent=self.master,
            main_frame_ref=self.main_frame_ref,
            excel_file=self.excel_file,
            default_font=self.default_font,
            passage_ids=self.passage_ids,
            유형=self.유형,
            난이도=self.난이도,
        )
        self.destroy()

        popup.grab_set()

    def on_manual_placement실모(self):
        # Open the manual placement popup with 실모flag = True
        if self.main_frame_ref is None or self.실모flag is None or self.row_idx is None or self.수동출제할지문번호 is None:
            messagebox.showerror("오류", "필요한 정보가 부족합니다.")
            return

        def save_callback(row_idx, 수동출제할지문번호, 유형, 난이도, edited_text):
            # Called by popup after user hits '확인'
            self.main_frame_ref.save_manual_placement_text실모(row_idx, 수동출제할지문번호, 유형, 난이도, edited_text)
            passageid유형난이도합본 = 수동출제할지문번호 + " // " + 유형 + "_" + 난이도
            self.manual_mocktest_popup.update_current_status_label수동실모(None, passageid유형난이도합본) #전체
        
        popup = ManualPlacementPopup(
            parent=self.master,
            default_font=self.default_font,
            excel_file=self.excel_file, 
            row_idx=self.row_idx,
            수동출제할지문번호=self.수동출제할지문번호,
            유형=self.유형,
            난이도=self.난이도,
            save_callback=save_callback,
            manual_edited_texts=self.main_frame_ref.manual_edited_texts,
            일반or실모="실모",
            manual_mocktest_popup=self.manual_mocktest_popup,
        )
        self.destroy()

        popup.grab_set()

        




class QuestionOptions영작2(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, 실모flag=None, 수동출제할지문번호=None, row_idx=None, 유형=None, 난이도=None, passage_ids=None, manual_mocktest_popup=None, options_file_path=None):
        super().__init__(parent)
        self.title('영작2 옵션')
        self.geometry('650x350')
        self.minsize(650, 350)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame
        self.excel_file = excel_file
        self.실모flag = 실모flag
        self.수동출제할지문번호 = 수동출제할지문번호
        self.row_idx = row_idx
        self.유형 = 유형
        self.난이도 = 난이도
        self.passage_ids = passage_ids
        self.manual_mocktest_popup = manual_mocktest_popup

        self.default_font = default_font
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        # Transformation variables
        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)
        self.지문길이_var = tk.IntVar(value=2)
        self.content_change_var = tk.IntVar(value=0)  # Default: 변화 없음

        # Checkbox variable
        self.blank_mode_var = tk.IntVar(value=0)

        # Questions per passage variable (default: 1)
        self.questions_per_passage_var = tk.IntVar(value=1)

        # Load saved value from JSON
        self.load_values_from_json()

        # Main frame
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)

        # Questions per passage option (NEW)
        questions_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        questions_frame.pack(side='top', fill='x', expand=False, pady=(10, 10))

        questions_label = customtkinter.CTkLabel(
            questions_frame,
            text="한 지문당 영작 문제 수:",
            font=(self.default_font, 12, 'bold'),
            text_color=("black", "white")
        )
        questions_label.pack(side='left', padx=(0, 15))

        radio_frame = customtkinter.CTkFrame(questions_frame, fg_color="transparent")
        radio_frame.pack(side='left', fill='x', expand=True)

        self.radio_1_question = customtkinter.CTkRadioButton(
            radio_frame,
            text='1개',
            font=(self.default_font, 12),
            variable=self.questions_per_passage_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C",
            border_color="gray"
        )
        self.radio_1_question.pack(side='left', padx=(0, 15))

        self.radio_2_questions = customtkinter.CTkRadioButton(
            radio_frame,
            text='2개',
            font=(self.default_font, 12),
            variable=self.questions_per_passage_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C",
            border_color="gray"
        )
        self.radio_2_questions.pack(side='left', padx=(0, 15))

        self.radio_3_questions = customtkinter.CTkRadioButton(
            radio_frame,
            text='3개',
            font=(self.default_font, 12),
            variable=self.questions_per_passage_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C",
            border_color="gray"
        )
        self.radio_3_questions.pack(side='left', padx=(0, 15))




        # Checkbox (existing feature)
        self.blank_mode_checkbox = customtkinter.CTkCheckBox(
            self.main_frame,
            text="한글 뜻 없이 빈칸으로 출제",
            variable=self.blank_mode_var,
            font=(self.default_font, 12, 'bold'),
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray",
            command=self.on_checkbox_changed
        )
        self.blank_mode_checkbox.pack(pady=(10, 10), anchor='w')






        
        # Transformation checkbox
        self.지문변형_checkbox = customtkinter.CTkCheckBox(
            self.main_frame,
            text="지문을 변형하여 출제",
            variable=self.지문변형_var,
            command=self.toggle_difficulty_options,
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.지문변형_checkbox.pack(pady=(0, 10), anchor='w')

        # Container for difficulty and length options
        self.difficulty_container = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")

        # Difficulty options (row 0)
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 난이도:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        difficulty_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_frame.grid(row=0, column=1, sticky="w")

        self.difficulty_easier = customtkinter.CTkRadioButton(
            difficulty_frame,
            text="더 쉽게",
            variable=self.지문난이도_var,
            value=1,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.difficulty_easier.pack(side='left', padx=5)

        self.difficulty_same = customtkinter.CTkRadioButton(
            difficulty_frame,
            text="같은 난이도",
            variable=self.지문난이도_var,
            value=2,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.difficulty_same.pack(side='left', padx=5)

        self.difficulty_harder = customtkinter.CTkRadioButton(
            difficulty_frame,
            text="더 높게",
            variable=self.지문난이도_var,
            value=3,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.difficulty_harder.pack(side='left', padx=5)

        # Length options (row 1)
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")

        length_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_frame.grid(row=1, column=1, sticky="w")

        self.length_shorter = customtkinter.CTkRadioButton(
            length_frame,
            text="더 짧게",
            variable=self.지문길이_var,
            value=1,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.length_shorter.pack(side='left', padx=5)

        self.length_similar = customtkinter.CTkRadioButton(
            length_frame,
            text="비슷하게",
            variable=self.지문길이_var,
            value=2,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.length_similar.pack(side='left', padx=5)

        self.length_longer = customtkinter.CTkRadioButton(
            length_frame,
            text="더 길게",
            variable=self.지문길이_var,
            value=3,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.length_longer.pack(side='left', padx=5)

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "요지는 유지하되, 예시/설명 등 세부 사항을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 핵심 주장/요지를 변경합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "관련 소재로 완전히 새로운 지문을 생성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Initialize radio button states
        self.toggle_difficulty_options()




        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=100,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        if not self.opened_from_dashboard:
            if 실모flag == True:
                수동출제버튼텍스트 = "영작2 수동출제\n(현재 문항)"
                수동출제버튼커맨드 = self.on_manual_placement실모
            else:
                수동출제버튼텍스트 = "영작2 수동출제"
                수동출제버튼커맨드 = self.on_manual_placement

            self.manual_button = customtkinter.CTkButton(
                action_frame,
                text=수동출제버튼텍스트,
                font=(self.default_font, 13, 'bold'),
                width=160,
                height=40,
                fg_color="#FEF9E0",
                hover_color="#DDA15C",
                text_color="black",
                command=수동출제버튼커맨드
            )
            self.manual_button.pack(side='left', padx=5, pady=(0, 5))

        self.confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        self.confirm_button.pack(side='right', padx=5, pady=(0, 5))
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10, 0))


        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.difficulty_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.difficulty_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.difficulty_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.length_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.length_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.length_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.blank_mode_var.set(data.get("영작2_blank_mode", 0))
                    self.questions_per_passage_var.set(data.get("영작2_questions_per_passage", 1))

                    # Load transformation settings
                    paraphrase_enabled = data.get("영작2paraphrase_enabled", False)
                    difficulty_level = data.get("영작2difficulty_level", 2)
                    length_level = data.get("영작2length_level", 2)
                    self.지문변형_var.set(paraphrase_enabled)
                    self.지문난이도_var.set(difficulty_level)
                    self.지문길이_var.set(length_level)
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("영작2content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)

            except:
                self.blank_mode_var.set(0)
                self.questions_per_passage_var.set(1)
        else:
            self.blank_mode_var.set(0)
            self.questions_per_passage_var.set(1)

    def save_values_to_json(self):
        # Load existing data first
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
            except:
                data = {}
        else:
            data = {}

        # Update only our value
        data["영작2_blank_mode"] = self.blank_mode_var.get()
        data["영작2_questions_per_passage"] = self.questions_per_passage_var.get()
        data["영작2paraphrase_enabled"] = self.지문변형_var.get()
        data["영작2difficulty_level"] = self.지문난이도_var.get()
        data["영작2length_level"] = self.지문길이_var.get()
        data["영작2content_change_mode"] = self.content_change_var.get()

        # Create directory if needed
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        # Write back
        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(data, f, ensure_ascii=False, indent=4)

    def on_checkbox_changed(self):
        self.save_values_to_json()

    def on_confirm(self):
        """Save options and update button color"""
        self.save_values_to_json()

        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # Reset blank_mode
        self.blank_mode_var.set(0)

        # Reset questions per passage
        self.questions_per_passage_var.set(1)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update radio button states
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def on_manual_placement(self):

        popup = ManualQuestionPopup문제선택(
            parent=self.master,
            main_frame_ref=self.main_frame_ref,
            excel_file=self.excel_file,
            default_font=self.default_font,
            passage_ids=self.passage_ids,
            유형=self.유형,
            난이도=self.난이도,
        )
        self.destroy()

        popup.grab_set()

    def on_manual_placement실모(self):
        # Open the manual placement popup with 실모flag = True
        if self.main_frame_ref is None or self.실모flag is None or self.row_idx is None or self.수동출제할지문번호 is None:
            messagebox.showerror("오류", "필요한 정보가 부족합니다.")
            return

        def save_callback(row_idx, 수동출제할지문번호, 유형, 난이도, edited_text):
            # Called by popup after user hits '확인'
            self.main_frame_ref.save_manual_placement_text실모(row_idx, 수동출제할지문번호, 유형, 난이도, edited_text)
            passageid유형난이도합본 = 수동출제할지문번호 + " // " + 유형 + "_" + 난이도
            self.manual_mocktest_popup.update_current_status_label수동실모(None, passageid유형난이도합본) #전체
        
        popup = ManualPlacementPopup(
            parent=self.master,
            default_font=self.default_font,
            excel_file=self.excel_file, 
            row_idx=self.row_idx,
            수동출제할지문번호=self.수동출제할지문번호,
            유형=self.유형,
            난이도=self.난이도,
            save_callback=save_callback,
            manual_edited_texts=self.main_frame_ref.manual_edited_texts,
            일반or실모="실모",
            manual_mocktest_popup=self.manual_mocktest_popup,
        )
        self.destroy()

        popup.grab_set()


class QuestionOptions주제영작(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", main_frame=None, excel_file=None, 실모flag=None, 수동출제할지문번호=None, row_idx=None, 유형=None, 난이도=None, passage_ids=None, manual_mocktest_popup=None, options_file_path=None):
        super().__init__(parent)
        self.title('주제영작 옵션')
        self.geometry('650x400')
        self.minsize(650, 400)

        self.default_font = default_font
        self.main_frame_ref = main_frame
        self.excel_file = excel_file
        self.실모flag = 실모flag
        self.수동출제할지문번호 = 수동출제할지문번호
        self.row_idx = row_idx
        self.유형 = 유형
        self.난이도 = 난이도
        self.passage_ids = passage_ids
        self.manual_mocktest_popup = manual_mocktest_popup

        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        # Transformation variables
        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)
        self.지문길이_var = tk.IntVar(value=2)
        self.content_change_var = tk.IntVar(value=0)  # Default: 변화 없음

        # Default values
        self.phrase_default = "10"
        self.sentence_default = "20"

        # Mode variable (1 for 명사구, 2 for 문장)
        self.주제영작_mode = tk.IntVar(value=1)

        # Number of words value
        self.number_of_words = self.phrase_default

        # Attempt to load saved values
        self.load_values_from_json()

        # Main frame
        self.main_frame_widget = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame_widget.pack(pady=10, padx=20, fill='both', expand=True)






        # Instruction Label
        intro_label = customtkinter.CTkLabel(
            self.main_frame_widget,
            text="주제영작 세부 옵션을 설정합니다. (모든 문항에 적용됩니다)",
            font=(self.default_font, 12),
            text_color=("black", "white")
        )
        intro_label.pack(side='top', anchor='center', pady=(0, 10))

        # Frame for mode selection
        mode_frame = customtkinter.CTkFrame(self.main_frame_widget, fg_color="transparent")
        mode_frame.pack(side='top', fill='x', expand=False, pady=(0, 10))

        mode_label = customtkinter.CTkLabel(
            mode_frame,
            text="주제 유형:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        mode_label.pack(side='top', anchor='w', pady=(0, 5))

        radio_container = customtkinter.CTkFrame(mode_frame, fg_color="transparent")
        radio_container.pack(side='top', fill='x', expand=False)

        self.radio_button_phrase = customtkinter.CTkRadioButton(
            radio_container,
            text='명사구로 주제 영작',
            font=(self.default_font, 13),
            variable=self.주제영작_mode,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray",
            command=self.on_mode_change
        )
        self.radio_button_phrase.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        self.radio_button_sentence = customtkinter.CTkRadioButton(
            radio_container,
            text='문장으로 주제문 영작',
            font=(self.default_font, 13),
            variable=self.주제영작_mode,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray",
            command=self.on_mode_change
        )
        self.radio_button_sentence.grid(row=0, column=1, padx=(10, 10), pady=5, sticky="w")

        # Frame for length configuration
        length_frame = customtkinter.CTkFrame(self.main_frame_widget, fg_color="transparent")
        length_frame.pack(side='top', fill='x', expand=False, pady=(0, 10))

        # Create a frame using grid for the length entry - all in one row
        config_frame = customtkinter.CTkFrame(length_frame, fg_color="transparent")
        config_frame.pack(side='top', fill='x', expand=False)

        # Bold label
        length_text_label_bold = customtkinter.CTkLabel(
            config_frame,
            text="주제(문) 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        length_text_label_bold.grid(row=0, column=0, padx=(0, 0), pady=5, sticky="w")

        # Normal label for (약)
        length_text_label_normal = customtkinter.CTkLabel(
            config_frame,
            text=" (약)",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        length_text_label_normal.grid(row=0, column=1, padx=(0, 5), pady=5, sticky="w")

        self.length_entry = customtkinter.CTkEntry(
            config_frame,
            width=60,
            font=(self.default_font, 13),
            fg_color="white",
            text_color="black"
        )
        self.length_entry.grid(row=0, column=2, padx=(0, 5), pady=5, sticky="w")

        length_unit = customtkinter.CTkLabel(
            config_frame,
            text="단어",
            font=(self.default_font, 13),
            text_color=("black", "white")
        )
        length_unit.grid(row=0, column=3, padx=(0, 5), pady=5, sticky="w")

        default_btn = customtkinter.CTkButton(
            config_frame,
            text="기본값",
            font=(self.default_font, 12, 'bold'),
            width=60,
            height=25,
            fg_color="white",
            hover_color="#DDA15C",
            text_color="black",
            command=self.set_defaults
        )
        default_btn.grid(row=0, column=4, padx=(5, 0), pady=5, sticky="w")





        # Transformation checkbox
        self.지문변형_checkbox = customtkinter.CTkCheckBox(
            self.main_frame_widget,
            text="지문을 변형하여 출제",
            variable=self.지문변형_var,
            command=self.toggle_difficulty_options,
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.지문변형_checkbox.pack(pady=(0, 10), anchor='w')

        # Container for difficulty and length options
        self.difficulty_container = customtkinter.CTkFrame(self.main_frame_widget, fg_color="transparent")

        # Difficulty options (row 0)
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 난이도:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        difficulty_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_frame.grid(row=0, column=1, sticky="w")

        self.difficulty_easier = customtkinter.CTkRadioButton(
            difficulty_frame,
            text="더 쉽게",
            variable=self.지문난이도_var,
            value=1,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.difficulty_easier.pack(side='left', padx=5)

        self.difficulty_same = customtkinter.CTkRadioButton(
            difficulty_frame,
            text="같은 난이도",
            variable=self.지문난이도_var,
            value=2,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.difficulty_same.pack(side='left', padx=5)

        self.difficulty_harder = customtkinter.CTkRadioButton(
            difficulty_frame,
            text="더 높게",
            variable=self.지문난이도_var,
            value=3,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.difficulty_harder.pack(side='left', padx=5)

        # Length options (row 1)
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")

        length_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_frame.grid(row=1, column=1, sticky="w")

        self.length_shorter = customtkinter.CTkRadioButton(
            length_frame,
            text="더 짧게",
            variable=self.지문길이_var,
            value=1,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.length_shorter.pack(side='left', padx=5)

        self.length_similar = customtkinter.CTkRadioButton(
            length_frame,
            text="비슷하게",
            variable=self.지문길이_var,
            value=2,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.length_similar.pack(side='left', padx=5)

        self.length_longer = customtkinter.CTkRadioButton(
            length_frame,
            text="더 길게",
            variable=self.지문길이_var,
            value=3,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            fg_color="#DDA15C", border_color="gray",
            hover_color="#BB6C25"
        )
        self.length_longer.pack(side='left', padx=5)

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "글의 요지는 유지하되, 세부 사항을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 요지를 변경하여 새로운 내용으로 작성합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "원문과 간접적으로 연관된 새로운 내용으로 작성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Initialize radio button states
        self.toggle_difficulty_options()





        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame_widget, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10, 0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=100,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        self.confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        self.confirm_button.pack(side='right', padx=5, pady=(0, 5))

        # Populate entry with loaded or default value
        self.restore_current_value_to_entry()

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.difficulty_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.difficulty_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.difficulty_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.length_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.length_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.length_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def on_mode_change(self):
        """Called when radio button selection changes"""
        mode = self.주제영작_mode.get()
        if mode == 1:
            self.number_of_words = self.phrase_default
        else:
            self.number_of_words = self.sentence_default
        self.restore_current_value_to_entry()

    def on_confirm(self):
        """Save options and update button color"""
        # Validate entry
        if not self.validate_entry():
            return

        # Get the value
        number_of_words_val = self.length_entry.get().strip()

        # Save to JSON
        self.save_values_to_json(
            number_of_words=number_of_words_val,
            mode=self.주제영작_mode.get()
        )

        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()

        # Close the popup
        self.destroy()

    def validate_entry(self):
        """Validate that the entry is a positive integer"""
        val = self.length_entry.get().strip()
        try:
            num = int(val)
            if num <= 0:
                messagebox.showwarning("경고", "양수를 입력해주세요.")
                return False
            return True
        except ValueError:
            messagebox.showwarning("경고", "숫자를 입력해주세요.")
            return False

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # Reset mode to 명사구 (1)
        self.주제영작_mode.set(1)

        # Reset entry value to phrase default
        self.number_of_words = self.phrase_default

        # Update UI
        self.restore_current_value_to_entry()

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update radio button states
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def set_defaults(self):
        """Reset to default value based on current mode"""
        mode = self.주제영작_mode.get()
        if mode == 1:
            self.number_of_words = self.phrase_default
        else:
            self.number_of_words = self.sentence_default
        self.restore_current_value_to_entry()

    def restore_current_value_to_entry(self):
        """Update the entry with current value"""
        self.length_entry.delete(0, tk.END)
        self.length_entry.insert(0, self.number_of_words)

    def load_values_from_json(self):
        """Load saved values from JSON file"""
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    saved_mode = data.get("주제영작mode", 1)
                    self.주제영작_mode.set(saved_mode)

                    # Load number_of_words based on mode
                    self.number_of_words = data.get("주제영작number_of_words",
                                                    self.phrase_default if saved_mode == 1 else self.sentence_default)
                    
                    # Load transformation settings
                    paraphrase_enabled = data.get("주제영작paraphrase_enabled", False)
                    difficulty_level = data.get("주제영작difficulty_level", 2)
                    length_level = data.get("주제영작length_level", 2)
                    self.지문변형_var.set(paraphrase_enabled)
                    self.지문난이도_var.set(difficulty_level)
                    self.지문길이_var.set(length_level)
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("주제영작content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)

            except:
                # If there's an error reading the file, fallback to defaults
                self.주제영작_mode.set(1)
                self.number_of_words = self.phrase_default
        else:
            # No file, use defaults
            self.주제영작_mode.set(1)
            self.number_of_words = self.phrase_default

    def save_values_to_json(self, number_of_words, mode=1):
        """Save values to JSON file"""
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        # Load existing data if any
        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        # Update data with new values
        existing_data["주제영작number_of_words"] = number_of_words
        existing_data["주제영작mode"] = mode
        existing_data["주제영작paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["주제영작difficulty_level"] = self.지문난이도_var.get()
        existing_data["주제영작length_level"] = self.지문길이_var.get()
        existing_data["주제영작content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)


# Simple option windows for additional question types (transformation only)
class QuestionOptions어휘1단계(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, options_file_path=None):
        super().__init__(parent)
        self.title('어휘1단계 옵션')
        self.geometry('650x250')
        self.minsize(650, 250)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame
        self.excel_file = excel_file
        self.default_font = default_font
        self.유형 = "어휘1단계"
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)
        
        # Passage transformation variables
        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)
        self.지문길이_var = tk.IntVar(value=2)
        self.content_change_var = tk.IntVar(value=0)  # Default: 내용 변화 없음

        # Load saved values
        self.load_values_from_json()
        
        # Main frame
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)
        
        # Passage transformation frame
        transform_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        transform_frame.pack(side='top', fill='x', expand=False, pady=(10, 0))
        
        # Checkbox
        self.transform_checkbox = customtkinter.CTkCheckBox(
            transform_frame,
            text="지문을 변형하여 출제",
            variable=self.지문변형_var,
            command=self.toggle_difficulty_options,
            font=(self.default_font, 13),
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.transform_checkbox.pack(side='top', anchor='w', pady=(0, 5))
        
        # Difficulty and length options container
        self.difficulty_container = customtkinter.CTkFrame(transform_frame, fg_color="transparent")
        self.difficulty_container.grid_columnconfigure(0, weight=0)
        self.difficulty_container.grid_columnconfigure(1, weight=1)
        
        # Difficulty label and radio buttons
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 난이도:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")
        
        difficulty_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_radio_frame.grid(row=0, column=1, sticky="w")

        self.radio_easier = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 쉽게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))

        self.radio_same = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='같은 난이도', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))

        self.radio_harder = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 높게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')

        # Length label and radio buttons
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="지문 길이:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")

        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")

        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 짧게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))

        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame, text='비슷하게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))

        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 길게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change mode label and radio buttons
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame, text='내용 변화 없음', font=(self.default_font, 13),
            variable=self.content_change_var, value=0, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame, text='세부 사항 변경', font=(self.default_font, 13),
            variable=self.content_change_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "글의 요지는 유지하되, 세부사항에 변화를 줍니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame, text='요지 변경', font=(self.default_font, 13),
            variable=self.content_change_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 요지 자체를 바꿉니다", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame, text='간접연계', font=(self.default_font, 13),
            variable=self.content_change_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "EBS 간접연계처럼 소재만 연계하여 새로운 글을 씁니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10, 0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        confirm_button.pack(side='right', padx=5, pady=(0, 5))

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)
        self.toggle_difficulty_options()

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_confirm(self):
        self.save_values_to_json()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update UI state
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.지문변형_var.set(data.get("어휘1단계paraphrase_enabled", False))
                    self.지문난이도_var.set(data.get("어휘1단계difficulty_level", 2))
                    self.지문길이_var.set(data.get("어휘1단계length_level", 2))
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("어휘1단계content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except:
                pass

    def save_values_to_json(self):
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        existing_data["어휘1단계paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["어휘1단계difficulty_level"] = self.지문난이도_var.get()
        existing_data["어휘1단계length_level"] = self.지문길이_var.get()
        # Save content_change_mode (None when checkbox unchecked, actual value when checked)
        existing_data["어휘1단계content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)


class QuestionOptions어휘2단계(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, options_file_path=None):
        super().__init__(parent)
        self.title('어휘2단계 옵션')
        self.geometry('650x250')
        self.minsize(650, 250)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame
        self.excel_file = excel_file
        self.default_font = default_font
        self.유형 = "어휘2단계"
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)
        self.지문길이_var = tk.IntVar(value=2)
        self.content_change_var = tk.IntVar(value=0)  # Default: 변화 없음

        self.load_values_from_json()
        
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)
        
        transform_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        transform_frame.pack(side='top', fill='x', expand=False, pady=(10, 0))
        
        self.transform_checkbox = customtkinter.CTkCheckBox(
            transform_frame, text="지문을 변형하여 출제",
            variable=self.지문변형_var, command=self.toggle_difficulty_options,
            font=(self.default_font, 13), text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.transform_checkbox.pack(side='top', anchor='w', pady=(0, 5))
        
        self.difficulty_container = customtkinter.CTkFrame(transform_frame, fg_color="transparent")
        self.difficulty_container.grid_columnconfigure(0, weight=0)
        self.difficulty_container.grid_columnconfigure(1, weight=1)
        
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 난이도:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")
        
        difficulty_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_radio_frame.grid(row=0, column=1, sticky="w")
        
        self.radio_easier = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 쉽게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))
        
        self.radio_same = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='같은 난이도', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))
        
        self.radio_harder = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 높게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')
        
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 길이:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")
        
        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")
        
        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 짧게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))
        
        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame, text='비슷하게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))
        
        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 길게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "글의 요지는 유지하되, 세부 사항을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 요지를 변경하여 새로운 내용으로 작성합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "원문과 간접적으로 연관된 새로운 내용으로 작성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10, 0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        confirm_button.pack(side='right', padx=5, pady=(0, 5))

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_confirm(self):
        self.save_values_to_json()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update UI state
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.지문변형_var.set(data.get("어휘2단계paraphrase_enabled", False))
                    self.지문난이도_var.set(data.get("어휘2단계difficulty_level", 2))
                    self.지문길이_var.set(data.get("어휘2단계length_level", 2))
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("어휘2단계content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except:
                pass

    def save_values_to_json(self):
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        existing_data["어휘2단계paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["어휘2단계difficulty_level"] = self.지문난이도_var.get()
        existing_data["어휘2단계length_level"] = self.지문길이_var.get()
        existing_data["어휘2단계content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)


class QuestionOptions밑줄의미(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, manual_mocktest_popup=None, options_file_path=None):
        super().__init__(parent)
        self.title('밑줄의미 옵션')
        self.geometry('650x250')
        self.minsize(650, 250)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame
        self.manual_mocktest_popup = manual_mocktest_popup
        self.excel_file = excel_file
        self.default_font = default_font
        self.유형 = "밑줄의미"
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)
        self.지문길이_var = tk.IntVar(value=2)
        self.content_change_var = tk.IntVar(value=0)  # Default: 변화 없음

        self.load_values_from_json()
        
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)
        
        transform_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        transform_frame.pack(side='top', fill='x', expand=False, pady=(10, 0))
        
        self.transform_checkbox = customtkinter.CTkCheckBox(
            transform_frame, text="지문을 변형하여 출제",
            variable=self.지문변형_var, command=self.toggle_difficulty_options,
            font=(self.default_font, 13), text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.transform_checkbox.pack(side='top', anchor='w', pady=(0, 5))
        
        self.difficulty_container = customtkinter.CTkFrame(transform_frame, fg_color="transparent")
        self.difficulty_container.grid_columnconfigure(0, weight=0)
        self.difficulty_container.grid_columnconfigure(1, weight=1)
        
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 난이도:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")
        
        difficulty_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_radio_frame.grid(row=0, column=1, sticky="w")
        
        self.radio_easier = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 쉽게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))
        
        self.radio_same = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='같은 난이도', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))
        
        self.radio_harder = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 높게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')
        
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 길이:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")
        
        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")
        
        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 짧게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))
        
        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame, text='비슷하게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))
        
        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 길게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "글의 요지는 유지하되, 세부 사항을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 요지를 변경하여 새로운 내용으로 작성합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "원문과 간접적으로 연관된 새로운 내용으로 작성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10, 0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        confirm_button.pack(side='right', padx=5, pady=(0, 5))

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)
        self.toggle_difficulty_options()

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_confirm(self):
        self.save_values_to_json()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update UI state
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.지문변형_var.set(data.get("밑줄의미paraphrase_enabled", False))
                    self.지문난이도_var.set(data.get("밑줄의미difficulty_level", 2))
                    self.지문길이_var.set(data.get("밑줄의미length_level", 2))
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("밑줄의미content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except:
                pass

    def save_values_to_json(self):
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        existing_data["밑줄의미paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["밑줄의미difficulty_level"] = self.지문난이도_var.get()
        existing_data["밑줄의미length_level"] = self.지문길이_var.get()
        existing_data["밑줄의미content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)


class QuestionOptions무관한문장(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, manual_mocktest_popup=None, options_file_path=None):
        super().__init__(parent)
        self.title('무관한문장 옵션')
        self.geometry('650x250')
        self.minsize(650, 250)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame
        self.manual_mocktest_popup = manual_mocktest_popup
        self.excel_file = excel_file
        self.default_font = default_font
        self.유형 = "무관한문장"
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)
        self.지문길이_var = tk.IntVar(value=2)
        self.content_change_var = tk.IntVar(value=0)  # Default: 변화 없음

        self.load_values_from_json()

        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)

        transform_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        transform_frame.pack(side='top', fill='x', expand=False, pady=(10, 0))

        self.transform_checkbox = customtkinter.CTkCheckBox(
            transform_frame, text="지문을 변형하여 출제",
            variable=self.지문변형_var, command=self.toggle_difficulty_options,
            font=(self.default_font, 13), text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.transform_checkbox.pack(side='top', anchor='w', pady=(0, 5))

        self.difficulty_container = customtkinter.CTkFrame(transform_frame, fg_color="transparent")
        self.difficulty_container.grid_columnconfigure(0, weight=0)
        self.difficulty_container.grid_columnconfigure(1, weight=1)

        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 난이도:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        difficulty_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_radio_frame.grid(row=0, column=1, sticky="w")

        self.radio_easier = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 쉽게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))

        self.radio_same = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='같은 난이도', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))

        self.radio_harder = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 높게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')

        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 길이:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")

        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")

        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 짧게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))

        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame, text='비슷하게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))

        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 길게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "글의 요지는 유지하되, 세부 사항을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 요지를 변경하여 새로운 내용으로 작성합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "원문과 간접적으로 연관된 새로운 내용으로 작성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10, 0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        confirm_button.pack(side='right', padx=5, pady=(0, 5))

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)
        self.toggle_difficulty_options()

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_confirm(self):
        self.save_values_to_json()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update UI state
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.지문변형_var.set(data.get("무관한문장paraphrase_enabled", False))
                    self.지문난이도_var.set(data.get("무관한문장difficulty_level", 2))
                    self.지문길이_var.set(data.get("무관한문장length_level", 2))
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("무관한문장content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except:
                pass

    def save_values_to_json(self):
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        existing_data["무관한문장paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["무관한문장difficulty_level"] = self.지문난이도_var.get()
        existing_data["무관한문장length_level"] = self.지문길이_var.get()
        existing_data["무관한문장content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)


class QuestionOptions주제(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, manual_mocktest_popup=None, options_file_path=None):
        super().__init__(parent)
        self.title('주제 옵션')
        self.geometry('650x250')
        self.minsize(650, 250)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame
        self.manual_mocktest_popup = manual_mocktest_popup
        self.excel_file = excel_file
        self.default_font = default_font
        self.유형 = "주제"
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)
        self.지문길이_var = tk.IntVar(value=2)
        self.content_change_var = tk.IntVar(value=0)  # Default: 변화 없음

        self.load_values_from_json()

        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)

        transform_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        transform_frame.pack(side='top', fill='x', expand=False, pady=(10, 0))

        self.transform_checkbox = customtkinter.CTkCheckBox(
            transform_frame, text="지문을 변형하여 출제",
            variable=self.지문변형_var, command=self.toggle_difficulty_options,
            font=(self.default_font, 13), text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.transform_checkbox.pack(side='top', anchor='w', pady=(0, 5))

        self.difficulty_container = customtkinter.CTkFrame(transform_frame, fg_color="transparent")
        self.difficulty_container.grid_columnconfigure(0, weight=0)
        self.difficulty_container.grid_columnconfigure(1, weight=1)

        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 난이도:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        difficulty_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_radio_frame.grid(row=0, column=1, sticky="w")

        self.radio_easier = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 쉽게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))

        self.radio_same = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='같은 난이도', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))

        self.radio_harder = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 높게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')

        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 길이:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")

        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")

        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 짧게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))

        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame, text='비슷하게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))

        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 길게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "글의 요지는 유지하되, 세부 사항을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 요지를 변경하여 새로운 내용으로 작성합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "원문과 간접적으로 연관된 새로운 내용으로 작성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10, 0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        confirm_button.pack(side='right', padx=5, pady=(0, 5))

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)
        self.toggle_difficulty_options()

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_confirm(self):
        self.save_values_to_json()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update UI state
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.지문변형_var.set(data.get("주제paraphrase_enabled", False))
                    self.지문난이도_var.set(data.get("주제difficulty_level", 2))
                    self.지문길이_var.set(data.get("주제length_level", 2))
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("주제content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except:
                pass

    def save_values_to_json(self):
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        existing_data["주제paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["주제difficulty_level"] = self.지문난이도_var.get()
        existing_data["주제length_level"] = self.지문길이_var.get()
        existing_data["주제content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)


class QuestionOptions제목(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, manual_mocktest_popup=None, options_file_path=None):
        super().__init__(parent)
        self.title('제목 옵션')
        self.geometry('650x250')
        self.minsize(650, 250)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame
        self.manual_mocktest_popup = manual_mocktest_popup
        self.excel_file = excel_file
        self.default_font = default_font
        self.유형 = "제목"
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)
        self.지문길이_var = tk.IntVar(value=2)
        self.content_change_var = tk.IntVar(value=0)  # Default: 변화 없음

        self.load_values_from_json()

        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)

        transform_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        transform_frame.pack(side='top', fill='x', expand=False, pady=(10, 0))

        self.transform_checkbox = customtkinter.CTkCheckBox(
            transform_frame, text="지문을 변형하여 출제",
            variable=self.지문변형_var, command=self.toggle_difficulty_options,
            font=(self.default_font, 13), text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.transform_checkbox.pack(side='top', anchor='w', pady=(0, 5))

        self.difficulty_container = customtkinter.CTkFrame(transform_frame, fg_color="transparent")
        self.difficulty_container.grid_columnconfigure(0, weight=0)
        self.difficulty_container.grid_columnconfigure(1, weight=1)

        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 난이도:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        difficulty_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_radio_frame.grid(row=0, column=1, sticky="w")

        self.radio_easier = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 쉽게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))

        self.radio_same = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='같은 난이도', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))

        self.radio_harder = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 높게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')

        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 길이:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")

        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")

        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 짧게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))

        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame, text='비슷하게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))

        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 길게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "글의 요지는 유지하되, 세부 사항을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 요지를 변경하여 새로운 내용으로 작성합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "원문과 간접적으로 연관된 새로운 내용으로 작성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10, 0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        confirm_button.pack(side='right', padx=5, pady=(0, 5))

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)
        self.toggle_difficulty_options()

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_confirm(self):
        self.save_values_to_json()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update UI state
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.지문변형_var.set(data.get("제목paraphrase_enabled", False))
                    self.지문난이도_var.set(data.get("제목difficulty_level", 2))
                    self.지문길이_var.set(data.get("제목length_level", 2))
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("제목content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except:
                pass

    def save_values_to_json(self):
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        existing_data["제목paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["제목difficulty_level"] = self.지문난이도_var.get()
        existing_data["제목length_level"] = self.지문길이_var.get()
        existing_data["제목content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)


class QuestionOptions연결어(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, options_file_path=None):
        super().__init__(parent)
        self.title('연결어 옵션')
        self.geometry('650x250')
        self.minsize(650, 250)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame
        self.excel_file = excel_file
        self.default_font = default_font
        self.유형 = "연결어"
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)
        self.지문길이_var = tk.IntVar(value=2)
        self.content_change_var = tk.IntVar(value=0)  # Default: 변화 없음

        self.load_values_from_json()
        
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)
        
        transform_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        transform_frame.pack(side='top', fill='x', expand=False, pady=(10, 0))
        
        self.transform_checkbox = customtkinter.CTkCheckBox(
            transform_frame, text="지문을 변형하여 출제",
            variable=self.지문변형_var, command=self.toggle_difficulty_options,
            font=(self.default_font, 13), text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.transform_checkbox.pack(side='top', anchor='w', pady=(0, 5))
        
        self.difficulty_container = customtkinter.CTkFrame(transform_frame, fg_color="transparent")
        self.difficulty_container.grid_columnconfigure(0, weight=0)
        self.difficulty_container.grid_columnconfigure(1, weight=1)
        
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 난이도:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")
        
        difficulty_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_radio_frame.grid(row=0, column=1, sticky="w")
        
        self.radio_easier = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 쉽게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))
        
        self.radio_same = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='같은 난이도', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))
        
        self.radio_harder = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 높게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')
        
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 길이:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")
        
        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")
        
        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 짧게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))
        
        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame, text='비슷하게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))
        
        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 길게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "글의 요지는 유지하되, 세부 사항을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 요지를 변경하여 새로운 내용으로 작성합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "원문과 간접적으로 연관된 새로운 내용으로 작성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10, 0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        confirm_button.pack(side='right', padx=5, pady=(0, 5))

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)
        self.toggle_difficulty_options()

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_confirm(self):
        self.save_values_to_json()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update UI state
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.지문변형_var.set(data.get("연결어paraphrase_enabled", False))
                    self.지문난이도_var.set(data.get("연결어difficulty_level", 2))
                    self.지문길이_var.set(data.get("연결어length_level", 2))
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("연결어content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except:
                pass

    def save_values_to_json(self):
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        existing_data["연결어paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["연결어difficulty_level"] = self.지문난이도_var.get()
        existing_data["연결어length_level"] = self.지문길이_var.get()
        existing_data["연결어content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)


class QuestionOptions어법1단계(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, options_file_path=None):
        super().__init__(parent)
        self.title('어법1단계 옵션')
        self.geometry('650x250')
        self.minsize(650, 250)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame
        self.excel_file = excel_file
        self.default_font = default_font
        self.유형 = "어법1단계"
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)
        self.지문길이_var = tk.IntVar(value=2)
        self.content_change_var = tk.IntVar(value=0)  # Default: 변화 없음

        self.load_values_from_json()
        
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)
        
        transform_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        transform_frame.pack(side='top', fill='x', expand=False, pady=(10, 0))
        
        self.transform_checkbox = customtkinter.CTkCheckBox(
            transform_frame, text="지문을 변형하여 출제",
            variable=self.지문변형_var, command=self.toggle_difficulty_options,
            font=(self.default_font, 13), text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.transform_checkbox.pack(side='top', anchor='w', pady=(0, 5))
        
        self.difficulty_container = customtkinter.CTkFrame(transform_frame, fg_color="transparent")
        self.difficulty_container.grid_columnconfigure(0, weight=0)
        self.difficulty_container.grid_columnconfigure(1, weight=1)
        
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 난이도:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")
        
        difficulty_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_radio_frame.grid(row=0, column=1, sticky="w")
        
        self.radio_easier = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 쉽게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))
        
        self.radio_same = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='같은 난이도', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))
        
        self.radio_harder = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 높게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')
        
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 길이:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")
        
        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")
        
        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 짧게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))
        
        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame, text='비슷하게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))
        
        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 길게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "글의 요지는 유지하되, 세부 사항을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 요지를 변경하여 새로운 내용으로 작성합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "원문과 간접적으로 연관된 새로운 내용으로 작성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10, 0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        confirm_button.pack(side='right', padx=5, pady=(0, 5))

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)
        self.toggle_difficulty_options()

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_confirm(self):
        self.save_values_to_json()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update UI state
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.지문변형_var.set(data.get("어법1단계paraphrase_enabled", False))
                    self.지문난이도_var.set(data.get("어법1단계difficulty_level", 2))
                    self.지문길이_var.set(data.get("어법1단계length_level", 2))
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("어법1단계content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except:
                pass

    def save_values_to_json(self):
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        existing_data["어법1단계paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["어법1단계difficulty_level"] = self.지문난이도_var.get()
        existing_data["어법1단계length_level"] = self.지문길이_var.get()
        existing_data["어법1단계content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)


class QuestionOptions어법2단계(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, manual_mocktest_popup=None, options_file_path=None):
        super().__init__(parent)
        self.title('어법2단계 옵션')
        self.geometry('780x360')
        self.minsize(780, 360)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame
        self.manual_mocktest_popup = manual_mocktest_popup
        self.excel_file = excel_file
        self.default_font = default_font
        self.유형 = "어법2단계"
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)
        self.지문길이_var = tk.IntVar(value=2)
        self.content_change_var = tk.IntVar(value=0)  # Default: 변화 없음
        self.mode = tk.IntVar(value=1)  # Default: 1개 (backward compatible)

        self.load_values_from_json()

        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)

        transform_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        transform_frame.pack(side='top', fill='x', expand=False, pady=(10, 0))

        self.transform_checkbox = customtkinter.CTkCheckBox(
            transform_frame, text="지문을 변형하여 출제",
            variable=self.지문변형_var, command=self.toggle_difficulty_options,
            font=(self.default_font, 13), text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.transform_checkbox.pack(side='top', anchor='w', pady=(0, 5))

        self.difficulty_container = customtkinter.CTkFrame(transform_frame, fg_color="transparent")
        self.difficulty_container.grid_columnconfigure(0, weight=0)
        self.difficulty_container.grid_columnconfigure(1, weight=1)

        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 난이도:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")

        difficulty_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_radio_frame.grid(row=0, column=1, sticky="w")

        self.radio_easier = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 쉽게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))

        self.radio_same = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='같은 난이도', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))

        self.radio_harder = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 높게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')

        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 길이:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")

        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")

        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 짧게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))

        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame, text='비슷하게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))

        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 길게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "글의 요지는 유지하되, 세부 사항을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 요지를 변경하여 새로운 내용으로 작성합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "원문과 간접적으로 연관된 새로운 내용으로 작성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Mode selection - 정답(틀린 것) 개수 (separate section, not part of 지문변형)
        # Note: This option only applies to 어법2단계_Normal, not 어법2단계_Hard

        # Add "(Normal 전용)" note above
        mode_note_label = customtkinter.CTkLabel(
            self.main_frame,
            text="(Normal 전용)",
            font=(self.default_font, 12),
            text_color="black"
        )
        mode_note_label.pack(side='top', anchor='w', pady=(15, 0))

        mode_section_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        mode_section_frame.pack(side='top', fill='x', expand=False, pady=(0, 0))

        self.mode_label = customtkinter.CTkLabel(
            mode_section_frame,
            text="정답(틀린 것) 개수:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.mode_label.pack(side='left', padx=(0, 10))

        mode_radio_frame = customtkinter.CTkFrame(mode_section_frame, fg_color="transparent")
        mode_radio_frame.pack(side='left', fill='x', expand=True)

        self.radio_mode_1 = customtkinter.CTkRadioButton(
            mode_radio_frame,
            text='1개',
            font=(self.default_font, 13),
            variable=self.mode,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_mode_1.pack(side='left', padx=(0, 10))

        self.radio_mode_2 = customtkinter.CTkRadioButton(
            mode_radio_frame,
            text='2개',
            font=(self.default_font, 13),
            variable=self.mode,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_mode_2.pack(side='left', padx=(0, 10))

        self.radio_mode_3 = customtkinter.CTkRadioButton(
            mode_radio_frame,
            text='3개',
            font=(self.default_font, 13),
            variable=self.mode,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_mode_3.pack(side='left', padx=(0, 10))

        self.radio_mode_4 = customtkinter.CTkRadioButton(
            mode_radio_frame,
            text='4개(맞는 것 고르기)',
            font=(self.default_font, 13),
            variable=self.mode,
            value=4,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_mode_4.pack(side='left', padx=(0, 10))

        self.radio_mode_random = customtkinter.CTkRadioButton(
            mode_radio_frame,
            text='랜덤(2~4개)',
            font=(self.default_font, 13),
            variable=self.mode,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_mode_random.pack(side='left')

        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10, 0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        confirm_button.pack(side='right', padx=5, pady=(0, 5))

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)
        self.toggle_difficulty_options()

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_confirm(self):
        self.save_values_to_json()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)
        self.mode.set(1)  # Reset to 1개 (default)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update UI state
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.지문변형_var.set(data.get("어법2단계paraphrase_enabled", False))
                    self.지문난이도_var.set(data.get("어법2단계difficulty_level", 2))
                    self.지문길이_var.set(data.get("어법2단계length_level", 2))
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("어법2단계content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
                    # Load mode with default 1 (1개, backward compatible)
                    saved_mode = data.get("어법2단계mode", 1)
                    self.mode.set(saved_mode)
            except:
                pass

    def save_values_to_json(self):
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        existing_data["어법2단계paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["어법2단계difficulty_level"] = self.지문난이도_var.get()
        existing_data["어법2단계length_level"] = self.지문길이_var.get()
        existing_data["어법2단계content_change_mode"] = self.content_change_var.get()
        existing_data["어법2단계mode"] = self.mode.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)


class QuestionOptions어휘종합(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, options_file_path=None):
        super().__init__(parent)
        self.title('어휘종합 옵션')
        self.geometry('650x250')
        self.minsize(650, 250)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame
        self.excel_file = excel_file
        self.default_font = default_font
        self.유형 = "어휘종합"
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)
        self.지문길이_var = tk.IntVar(value=2)
        self.content_change_var = tk.IntVar(value=0)  # Default: 변화 없음

        self.load_values_from_json()
        
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)
        
        transform_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        transform_frame.pack(side='top', fill='x', expand=False, pady=(10, 0))
        
        self.transform_checkbox = customtkinter.CTkCheckBox(
            transform_frame, text="지문을 변형하여 출제",
            variable=self.지문변형_var, command=self.toggle_difficulty_options,
            font=(self.default_font, 13), text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.transform_checkbox.pack(side='top', anchor='w', pady=(0, 5))
        
        self.difficulty_container = customtkinter.CTkFrame(transform_frame, fg_color="transparent")
        self.difficulty_container.grid_columnconfigure(0, weight=0)
        self.difficulty_container.grid_columnconfigure(1, weight=1)
        
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 난이도:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")
        
        difficulty_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_radio_frame.grid(row=0, column=1, sticky="w")
        
        self.radio_easier = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 쉽게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))
        
        self.radio_same = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='같은 난이도', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))
        
        self.radio_harder = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 높게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')
        
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 길이:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")
        
        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")
        
        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 짧게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))
        
        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame, text='비슷하게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))
        
        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 길게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "글의 요지는 유지하되, 세부 사항을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 요지를 변경하여 새로운 내용으로 작성합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "원문과 간접적으로 연관된 새로운 내용으로 작성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10, 0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        confirm_button.pack(side='right', padx=5, pady=(0, 5))

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)
        self.toggle_difficulty_options()

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_confirm(self):
        self.save_values_to_json()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update UI state
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.지문변형_var.set(data.get("어휘종합paraphrase_enabled", False))
                    self.지문난이도_var.set(data.get("어휘종합difficulty_level", 2))
                    self.지문길이_var.set(data.get("어휘종합length_level", 2))
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("어휘종합content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except:
                pass

    def save_values_to_json(self):
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        existing_data["어휘종합paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["어휘종합difficulty_level"] = self.지문난이도_var.get()
        existing_data["어휘종합length_level"] = self.지문길이_var.get()
        existing_data["어휘종합content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)


class QuestionOptions내용종합(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, options_file_path=None):
        super().__init__(parent)
        self.title('내용종합 옵션')
        self.geometry('650x250')
        self.minsize(650, 250)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame
        self.excel_file = excel_file
        self.default_font = default_font
        self.유형 = "내용종합"
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        self.지문변형_var = tk.BooleanVar(value=False)
        self.지문난이도_var = tk.IntVar(value=2)
        self.지문길이_var = tk.IntVar(value=2)
        self.content_change_var = tk.IntVar(value=0)  # Default: 변화 없음

        self.load_values_from_json()
        
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)
        
        transform_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        transform_frame.pack(side='top', fill='x', expand=False, pady=(10, 0))
        
        self.transform_checkbox = customtkinter.CTkCheckBox(
            transform_frame, text="지문을 변형하여 출제",
            variable=self.지문변형_var, command=self.toggle_difficulty_options,
            font=(self.default_font, 13), text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.transform_checkbox.pack(side='top', anchor='w', pady=(0, 5))
        
        self.difficulty_container = customtkinter.CTkFrame(transform_frame, fg_color="transparent")
        self.difficulty_container.grid_columnconfigure(0, weight=0)
        self.difficulty_container.grid_columnconfigure(1, weight=1)
        
        self.difficulty_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 난이도:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.difficulty_label.grid(row=0, column=0, padx=(0, 10), pady=5, sticky="w")
        
        difficulty_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        difficulty_radio_frame.grid(row=0, column=1, sticky="w")
        
        self.radio_easier = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 쉽게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_easier.pack(side='left', padx=(0, 10))
        
        self.radio_same = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='같은 난이도', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_same.pack(side='left', padx=(0, 10))
        
        self.radio_harder = customtkinter.CTkRadioButton(
            difficulty_radio_frame, text='더 높게', font=(self.default_font, 13),
            variable=self.지문난이도_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_harder.pack(side='left')
        
        self.length_label = customtkinter.CTkLabel(
            self.difficulty_container, text="지문 길이:",
            font=(self.default_font, 13, 'bold'), text_color=("black", "white")
        )
        self.length_label.grid(row=1, column=0, padx=(0, 10), pady=5, sticky="w")
        
        length_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        length_radio_frame.grid(row=1, column=1, sticky="w")
        
        self.radio_shorter = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 짧게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_shorter.pack(side='left', padx=(0, 10))
        
        self.radio_similar = customtkinter.CTkRadioButton(
            length_radio_frame, text='비슷하게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_similar.pack(side='left', padx=(0, 10))
        
        self.radio_longer = customtkinter.CTkRadioButton(
            length_radio_frame, text='더 길게', font=(self.default_font, 13),
            variable=self.지문길이_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_longer.pack(side='left')

        # Content change label and radio buttons (row=2)
        self.content_change_label = customtkinter.CTkLabel(
            self.difficulty_container,
            text="내용 변경 방식:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        self.content_change_label.grid(row=2, column=0, padx=(0, 10), pady=5, sticky="w")

        content_change_radio_frame = customtkinter.CTkFrame(self.difficulty_container, fg_color="transparent")
        content_change_radio_frame.grid(row=2, column=1, sticky="w")

        self.radio_content_none = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='변화 없음',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=0,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_none.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_none, "글의 요지 및 세부사항을 그대로 유지합니다.", self.default_font)

        self.radio_content_detail = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='세부 사항 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=1,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_detail.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_detail, "글의 요지는 유지하되, 세부 사항을 변경합니다.", self.default_font)

        self.radio_content_main = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='요지 변경',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=2,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_main.pack(side='left', padx=(0, 10))
        ToolTip유형설명(self.radio_content_main, "글의 요지를 변경하여 새로운 내용으로 작성합니다.", self.default_font)

        self.radio_content_external = customtkinter.CTkRadioButton(
            content_change_radio_frame,
            text='간접연계',
            font=(self.default_font, 13),
            variable=self.content_change_var,
            value=3,
            text_color=("black", "white"),
            hover_color="#BB6C25",
            fg_color="#DDA15C", border_color="gray"
        )
        self.radio_content_external.pack(side='left')
        ToolTip유형설명(self.radio_content_external, "원문과 간접적으로 연관된 새로운 내용으로 작성합니다.", self.default_font)

        # Pack difficulty container (always visible)
        self.difficulty_container.pack(side='top', fill='x', expand=False, padx=(20, 0))

        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(10, 0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        confirm_button.pack(side='right', padx=5, pady=(0, 5))

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)
        self.toggle_difficulty_options()

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def toggle_difficulty_options(self):
        """Enable/disable radio buttons and update colors based on checkbox state"""
        is_enabled = self.지문변형_var.get()
        state = "normal" if is_enabled else "disabled"
        text_color = ("black", "white") if is_enabled else "gray"
        border_color = "gray" if is_enabled else "#d0d0d0"

        # Update labels
        self.difficulty_label.configure(text_color=text_color)
        self.length_label.configure(text_color=text_color)
        self.content_change_label.configure(text_color=text_color)

        # Update radio buttons
        self.radio_easier.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_same.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_harder.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_shorter.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_similar.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_longer.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_none.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_detail.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_main.configure(state=state, text_color=text_color, border_color=border_color)
        self.radio_content_external.configure(state=state, text_color=text_color, border_color=border_color)

    def on_confirm(self):
        self.save_values_to_json()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler BEFORE destroying the dialog
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset transformation options
        self.지문변형_var.set(False)
        self.지문난이도_var.set(2)
        self.지문길이_var.set(2)
        self.content_change_var.set(0)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update UI state
        self.toggle_difficulty_options()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.지문변형_var.set(data.get("내용종합paraphrase_enabled", False))
                    self.지문난이도_var.set(data.get("내용종합difficulty_level", 2))
                    self.지문길이_var.set(data.get("내용종합length_level", 2))
                    # Load content_change_mode with proper default (convert None to 0)
                    content_change_value = data.get("내용종합content_change_mode", 0)
                    self.content_change_var.set(content_change_value if content_change_value is not None else 0)
            except:
                pass

    def save_values_to_json(self):
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        existing_data["내용종합paraphrase_enabled"] = self.지문변형_var.get()
        existing_data["내용종합difficulty_level"] = self.지문난이도_var.get()
        existing_data["내용종합length_level"] = self.지문길이_var.get()
        existing_data["내용종합content_change_mode"] = self.content_change_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)


class QuestionOptions단어정리(customtkinter.CTkToplevel):
    def __init__(self, parent, default_font="Arial", excel_file=None, main_frame=None, options_file_path=None):
        super().__init__(parent)
        self.title('단어정리 옵션')
        self.geometry('300x320')
        self.minsize(300, 320)

        self.parent = parent
        self.opened_from_dashboard = getattr(parent, "is_options_dashboard", False)
        self.main_frame_ref = main_frame
        self.excel_file = excel_file
        self.default_font = default_font
        self.유형 = "단어정리"
        self.app_data_dir = Path.home() / ".my_application_data"
        if options_file_path:
            self.make_questions_options_file_path = options_file_path
        else:
            self.make_questions_options_file_path = get_default_options_file_path(self.app_data_dir)

        # Vocabulary level variable (0: 중3, 1: 고1, 2: 고2, 3: 고3)
        self.vocab_level_var = tk.IntVar(value=1)  # Default: 고1

        # Load saved values
        self.load_values_from_json()

        # Main frame
        self.main_frame = customtkinter.CTkFrame(self, fg_color="transparent")
        self.main_frame.pack(pady=10, padx=20, fill='both', expand=True)

        # Vocabulary level selection frame
        vocab_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        vocab_frame.pack(side='top', fill='both', expand=True, pady=(10, 0))

        # Label
        vocab_label = customtkinter.CTkLabel(
            vocab_frame,
            text="어휘 수준:",
            font=(self.default_font, 13, 'bold'),
            text_color=("black", "white")
        )
        vocab_label.pack(side='top', pady=(0, 10))

        # Radio buttons frame
        radio_frame = customtkinter.CTkFrame(vocab_frame, fg_color="transparent")
        radio_frame.pack(side='top', fill='both', expand=True)

        self.radio_중3 = customtkinter.CTkRadioButton(
            radio_frame, text='중3', font=(self.default_font, 13),
            variable=self.vocab_level_var, value=0, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_중3.pack(side='top', anchor='w', pady=5)

        self.radio_고1 = customtkinter.CTkRadioButton(
            radio_frame, text='고1', font=(self.default_font, 13),
            variable=self.vocab_level_var, value=1, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_고1.pack(side='top', anchor='w', pady=5)

        self.radio_고2 = customtkinter.CTkRadioButton(
            radio_frame, text='고2', font=(self.default_font, 13),
            variable=self.vocab_level_var, value=2, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_고2.pack(side='top', anchor='w', pady=5)

        self.radio_고3 = customtkinter.CTkRadioButton(
            radio_frame, text='고3', font=(self.default_font, 13),
            variable=self.vocab_level_var, value=3, text_color=("black", "white"),
            hover_color="#BB6C25", fg_color="#DDA15C", border_color="gray"
        )
        self.radio_고3.pack(side='top', anchor='w', pady=5)

        # Action buttons at the bottom
        action_frame = customtkinter.CTkFrame(self.main_frame, fg_color="transparent")
        action_frame.pack(side='bottom', fill='x', expand=False, pady=(30, 0))

        # Default button (left side)
        default_button = customtkinter.CTkButton(
            action_frame,
            text="기본값",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.reset_to_defaults
        )
        default_button.pack(side='left', padx=5, pady=(0, 5))

        # Confirm button (right side)
        confirm_button = customtkinter.CTkButton(
            action_frame,
            text="확인",
            font=(self.default_font, 13, 'bold'),
            width=160,
            height=40,
            fg_color="#FEF9E0",
            hover_color="#DDA15C",
            text_color="black",
            command=self.on_confirm
        )
        confirm_button.pack(side='right', padx=5, pady=(0, 5))

        self.bind("<Escape>", self.on_popup_close)
        self.protocol("WM_DELETE_WINDOW", self.on_popup_close)

    def on_popup_close(self, event=None):
        # CRITICAL: Restore baseline if opened from manual mocktest (ESC/X button case)
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)

        # Notify main frame to update button color when options change
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def on_confirm(self):
        self.save_values_to_json()

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # Update button colors in manual mocktest popup if it exists
        if hasattr(self, 'manual_mocktest_popup'):
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute")

        self.destroy()

    def reset_to_defaults(self):
        """Reset all options to default values"""
        # Reset to default (고1)
        self.vocab_level_var.set(1)

        # DO NOT call save_values_to_json() here
        # Save only happens when user clicks 확인

        # Update button color in main frame
        if self.main_frame_ref and hasattr(self.main_frame_ref, 'update_option_button_color'):
            self.main_frame_ref.update_option_button_color(self.유형)

        # CRITICAL: Call option override handler to detect reset
        if hasattr(self, '_option_override_manager'):
            manager = getattr(self, '_option_override_manager')
            if manager and hasattr(manager, '_handle_option_popup_destroy'):
                manager._handle_option_popup_destroy(self)
        elif hasattr(self, 'manual_mocktest_popup'):
            # Fallback: update button colors in manual mocktest popup if it exists
            print(f"     manual_mocktest_popup exists: {self.manual_mocktest_popup is not None}")
            if self.manual_mocktest_popup and hasattr(self.manual_mocktest_popup, 'update_all_option_button_colors'):
                self.manual_mocktest_popup.update_all_option_button_colors()
            else:
                print(f"   manual_mocktest_popup missing or no update method")
        else:
            print(f"     No manual_mocktest_popup attribute or override manager")

    def load_values_from_json(self):
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    data = json.load(f)
                    self.vocab_level_var.set(data.get("단어정리vocab_level", 1))
            except:
                pass

    def save_values_to_json(self):
        if not os.path.exists(self.app_data_dir):
            os.makedirs(self.app_data_dir, exist_ok=True)

        existing_data = {}
        if os.path.exists(self.make_questions_options_file_path):
            try:
                with open(self.make_questions_options_file_path, 'r', encoding='utf-8') as f:
                    existing_data = json.load(f)
            except:
                existing_data = {}

        existing_data["단어정리vocab_level"] = self.vocab_level_var.get()

        with open(self.make_questions_options_file_path, 'w', encoding='utf-8') as f:
            json.dump(existing_data, f, ensure_ascii=False, indent=4)