"""Convenience wrappers around product/support URLs opened from the UI."""

import webbrowser

_PURCHASE_URL = 'https://frontierenglish.net/product-category/credit/'
_DOWNLOAD_URL = 'https://frontierenglish.net/autoqm-download/'
_SUBSCRIBE_URL = 'https://frontierenglish.net/product-category/autoqmsub/'
_HELP_URL = 'https://frontierenglish.net/autoqm-%eb%a9%94%eb%89%b4%ec%96%bc/'
_HELP_TYPE_URL = 'https://frontierenglish.net/autoqm-%eb%8f%84%ec%9b%80%eb%a7%90/'
_HELP_PRICE_URL = 'https://frontierenglish.net/autoqm-%eb%8f%84%ec%9b%80%eb%a7%90/'


def open_purchase_webpage():
    webbrowser.open(_PURCHASE_URL)


def open_download_webpage():
    webbrowser.open(_DOWNLOAD_URL)


def open_subscribe_webpage():
    webbrowser.open(_SUBSCRIBE_URL)


def open_help_webpage():
    webbrowser.open(_HELP_URL)


def open_help_webpage_type():
    webbrowser.open(_HELP_TYPE_URL)


def open_help_webpage_price():
    webbrowser.open(_HELP_PRICE_URL)


__all__ = [
    "open_purchase_webpage",
    "open_download_webpage",
    "open_subscribe_webpage",
    "open_help_webpage",
    "open_help_webpage_type",
    "open_help_webpage_price",
]
