#modules/copymanager.py

import tkinter as tk  # For tkinter components
from tkinter import messagebox, ttk  # For messagebox and Treeview
import platform  # To check the operating system
import csv  # For handling CSV operations
import io  # For handling in-memory file operations
import pyperclip  # For clipboard handling (install using `pip install pyperclip` if not already installed)



class CopyManager: #원래 이거 자체가 한국어 키보드용..... 근데 트리뷰는 영어로 해도 여기가 불려옴
    COMMAND_KEY_MASK = 8  # Based on the state value provided
    SHIFT_KEY_MASK = 1  # Based on the state value provided
    TOGETHER_MASK = 9  # Based on the state value provided


    # Windows-specific masks
    WINDOWS_CONTROL = 4  # Control key state for Windows
    WINDOWS_SHIFT = 1  # Shift key state for Windows

    
    def __init__(self, parent_window):
        self.parent_window = parent_window
        #self.parent_window.bind("<KeyPress>", self.handle_keypress)

        self.clipboard_data = None
        self.last_system_clipboard = None
        self._is_pasting = False  # Re-entry guard for paste operations

    ## 영어로 해도 이게 불려오네????
    def update_clipboard(self):
        current_system_clipboard = pyperclip.paste()
        if current_system_clipboard != self.last_system_clipboard:
            self.last_system_clipboard = current_system_clipboard
            try:
                csv_reader = csv.reader(io.StringIO(current_system_clipboard), delimiter='\t')
                self.clipboard_data = list(csv_reader)
            except:
                self.clipboard_data = None




    def handle_keypress(self, event):
        #print(event.state)
        #print(event.keycode)
        #print(event.keysym)

        # CRITICAL: Skip processing for non-modifier keypresses to avoid
        # interfering with Korean Input Method (IMK) XPC communication.
        # Only process Command/Control key combinations.
        is_command = event.state & self.COMMAND_KEY_MASK
        is_control = event.state & self.WINDOWS_CONTROL
        if not is_command and not is_control:
            return  # Let normal typing pass through without interference

        # Copy (command+ㅊ)
        if event.keycode == 134217827 and (event.state & self.COMMAND_KEY_MASK):  # keycode for ㅊ
            #print("Copy text called")
            event.widget.event_generate("<<Copy>>")

        ######## 이게 ㅍ 보다 앞에 있어야 함. v를 먼저 막아야 함.
        elif event.keysym == 'v' and (event.state & self.COMMAND_KEY_MASK):  # keysym for 'v'
            # Do nothing, let the system handle the paste
            pass
            print("Ignoring system paste")
 
        # Paste (command+ㅍ)
        elif event.keycode == 150995062 and (event.state & self.COMMAND_KEY_MASK):  # keycode for ㅍ (v)
            # Re-entry guard to prevent multiple paste operations
            if self._is_pasting:
                print("Paste already in progress, ignoring")
                return

            print("Paste text called1")
            self._is_pasting = True
            widget = event.widget  # Capture widget reference for after() callback

            # Get the clipboard content
            try:
                clipboard_content = widget.clipboard_get()

                # Modify the clipboard content (e.g., replace '/i' with '\n')
                #modified_content = clipboard_content.replace('', '\n')
                modified_content = (clipboard_content
                    .replace("\u2028", "\n")
                    .replace("\u2029", "\n")
                    .replace("\f", "")
                    .replace("\u2013", "-")
                    .replace("\u200B", "")   # zero-width space
                    .replace("\u200C", "")   # zero-width non-joiner
                    .replace("\u200D", "")   # zero-width joiner
                    .replace("\uFEFF", "")   # byte order mark
                )

                # Set the modified content back to the clipboard
                widget.clipboard_clear()
                widget.clipboard_append(modified_content)

                # Use after() to decouple paste from clipboard modification
                # This gives macOS IMK time to process clipboard changes
                def do_paste():
                    try:
                        widget.event_generate("<<Paste>>")
                    except tk.TclError:
                        pass  # Widget might be destroyed
                    finally:
                        self._is_pasting = False

                widget.after(50, do_paste)  # 50ms delay to let Korean IMK settle

            except tk.TclError:
                # Handle empty clipboard
                print("Clipboard is empty or contains non-text data")
                self._is_pasting = False




        # Select All (command+ㅁ)
        elif event.keycode == 97 and (event.state & self.COMMAND_KEY_MASK):  # keycode for ㅁ
            event.widget.event_generate("<<SelectAll>>")

        # Cut (command+ㅌ)
        elif event.keycode == 117440632 and (event.state & self.COMMAND_KEY_MASK):  # keycode for ㅌ
            event.widget.event_generate("<<Cut>>")



        # Windows-specific Redo (Ctrl+Shift+Z)
        elif event.keysym == 'Z' and (event.state & self.WINDOWS_CONTROL) and (event.state & self.WINDOWS_SHIFT):
            event.widget.event_generate("<<Redo>>") 
        


        # 일단 z를 막고 그 다음에 ㅋ
        elif event.keysym == 'z' and (event.state & self.COMMAND_KEY_MASK):  # keysym for 'z'
            # Do nothing, let the system handle the paste
            pass
            #print("Ignoring system paste")

        # Undo (command+ㅋ)
        elif event.keycode == 100663418 and (event.state & self.COMMAND_KEY_MASK):  # keycode for ㅋ
            print("실행취소")
            event.widget.event_generate("<<Undo>>")

        # Redo (command+shift+ㅋ)
        elif event.keycode == 104857722 and (event.state & self.COMMAND_KEY_MASK) and (event.state & self.SHIFT_KEY_MASK):  # keycode for ㅋ with Shift
            print("재실행")
            event.widget.event_generate("<<Redo>>")
        """
        # Redo (command+shift+ㅋ)
        elif event.keycode == 104857722 and (event.state & self.TOGETHER_MASK):  # keycode for ㅋ with Shift
            print("재실행")
            event.widget.event_generate("<<Redo>>")
        """

