#modules/font_handler.py

import re
from tkinter import font

class FontHandler:
    def __init__(self):
        self.default_font = None

    def set_default_font(self):
        # Filter out fonts that start with '@'
        font_names = [f for f in sorted(list(font.families())) if not f.startswith('@')]

        # Custom sort function to prioritize Korean names
        def sort_fonts(x):
            if re.search("[가-힣]+", x):
                return (0, x)  # Korean fonts first
            else:
                return (1, x)  # Others after

        font_names = sorted(font_names, key=sort_fonts)
        
        preferred_fonts = ["나눔고딕", "Nanum Gothic", "나눔 고딕"]
        self.default_font = next((f for f in preferred_fonts if f in font_names), "굴림")

font_handler = FontHandler()
